/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusManager;
import java.util.ArrayList;

public abstract class CloseEditorsActionBase
extends AnAction
implements DumbAware {
    protected ArrayList<Pair<EditorComposite, EditorWindow>> getFilesToClose(AnActionEvent event) {
        ArrayList<Pair<EditorComposite, EditorWindow>> res = new ArrayList<Pair<EditorComposite, EditorWindow>>();
        DataContext dataContext = event.getDataContext();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        EditorWindow[] windows = editorWindow != null ? new EditorWindow[]{editorWindow} : editorManager.getWindows();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        if (fileStatusManager != null) {
            for (int i = 0; i != windows.length; ++i) {
                EditorWithProviderComposite[] editors;
                EditorWindow window = windows[i];
                for (EditorWithProviderComposite editor : editors = window.getEditors()) {
                    if (!this.isFileToClose(editor, window)) continue;
                    res.add((Pair<EditorComposite, EditorWindow>)Pair.create((Object)editor, (Object)window));
                }
            }
        }
        return res;
    }

    protected abstract boolean isFileToClose(EditorComposite var1, EditorWindow var2);

    public void actionPerformed(final AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, new Runnable(){

            @Override
            public void run() {
                ArrayList<Pair<EditorComposite, EditorWindow>> filesToClose = CloseEditorsActionBase.this.getFilesToClose(e);
                for (int i = 0; i != filesToClose.size(); ++i) {
                    Pair<EditorComposite, EditorWindow> we = filesToClose.get(i);
                    ((EditorWindow)we.getSecond()).closeFile(((EditorComposite)we.getFirst()).getFile());
                }
            }
        }, IdeBundle.message((String)"command.close.all.unmodified.editors", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        boolean enabled;
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        boolean inSplitter = editorWindow != null && editorWindow.inSplitter();
        presentation.setText(this.getPresentationText(inSplitter));
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        boolean bl = enabled = project2 != null && this.isActionEnabled(project2, event);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setEnabled(enabled);
        }
    }

    protected boolean isActionEnabled(Project project2, AnActionEvent event) {
        return this.getFilesToClose(event).size() > 0;
    }

    protected abstract String getPresentationText(boolean var1);
}

