/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public final class BrowserLauncherImpl
extends BrowserLauncherAppless {
    public void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/browsers/BrowserLauncherImpl", "browse"));
        }
        BuiltInServerManager serverManager = BuiltInServerManager.getInstance();
        Url parsedUrl = Urls.parse(url, false);
        if (parsedUrl != null && serverManager.isOnBuiltInWebServer(parsedUrl)) {
            if (Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false)) {
                PropertiesComponent.getInstance().setValue("ide.built.in.web.server.active", true);
            }
            url = serverManager.addAuthToken(parsedUrl).toExternalForm();
        }
        super.browse(url, browser, project2);
    }

    protected void browseUsingNotSystemDefaultBrowserPolicy(@NotNull URI uri, @NotNull GeneralSettings settings, @Nullable Project project2) {
        WebBrowser browser;
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/ide/browsers/BrowserLauncherImpl", "browseUsingNotSystemDefaultBrowserPolicy"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/browsers/BrowserLauncherImpl", "browseUsingNotSystemDefaultBrowserPolicy"));
        }
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        if ((browserManager.getDefaultBrowserPolicy() == DefaultBrowserPolicy.FIRST || SystemInfo.isMac && "open".equals(settings.getBrowserPath())) && (browser = browserManager.getFirstActiveBrowser()) != null) {
            this.browseUsingPath(uri.toString(), null, browser, project2, ArrayUtil.EMPTY_STRING_ARRAY);
            return;
        }
        super.browseUsingNotSystemDefaultBrowserPolicy(uri, settings, project2);
    }

    protected void showError(final @Nullable String error, final @Nullable WebBrowser browser, final @Nullable Project project2, final String title, final @Nullable Runnable launchTask) {
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                if (Messages.showYesNoDialog((Project)project2, (String)StringUtil.notNullize((String)error, (String)"Unknown error"), (String)(title == null ? IdeBundle.message((String)"browser.error", (Object[])new Object[0]) : title), (String)Messages.OK_BUTTON, (String)IdeBundle.message((String)"button.fix", (Object[])new Object[0]), null) == 1) {
                    final BrowserSettings browserSettings = new BrowserSettings();
                    if (ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)browserSettings, browser == null ? null : new Runnable(){

                        @Override
                        public void run() {
                            browserSettings.selectBrowser(browser);
                        }
                    }) && launchTask != null) {
                        launchTask.run();
                    }
                }
            }
        }, project2 == null ? null : project2.getDisposed());
    }

    protected void checkCreatedProcess(final @Nullable WebBrowser browser, final @Nullable Project project2, @NotNull GeneralCommandLine commandLine, final @NotNull Process process, final @Nullable Runnable launchTask) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/ide/browsers/BrowserLauncherImpl", "checkCreatedProcess"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/ide/browsers/BrowserLauncherImpl", "checkCreatedProcess"));
        }
        if (BrowserLauncherImpl.isOpenCommandUsed((GeneralCommandLine)commandLine)) {
            final Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (process.waitFor() == 1) {
                            BrowserLauncherImpl.this.showError(ExecUtil.readFirstLine((InputStream)process.getErrorStream(), null), browser, project2, null, launchTask);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            JobScheduler.getScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    future2.cancel(true);
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }
}

