/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.call.CallHierarchyBrowser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JavaCallHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/hierarchy/call/JavaCallHierarchyProvider", "getTarget"));
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        CallHierarchyBrowser callHierarchyBrowser = new CallHierarchyBrowser(target.getProject(), (PsiMethod)target);
        if (callHierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/call/JavaCallHierarchyProvider", "createHierarchyBrowser"));
        }
        return callHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/intellij/ide/hierarchy/call/JavaCallHierarchyProvider", "browserActivated"));
        }
        ((CallHierarchyBrowser)hierarchyBrowser).changeView(CallHierarchyBrowserBase.CALLER_TYPE);
    }
}

