/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.navigationToolbar.NavBarIdeView;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListener;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.NavBarRootPaneExtension;
import com.intellij.ide.navigationToolbar.NavBarUpdateQueue;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.plaf.PanelUI;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPanel
extends JPanel
implements DataProvider,
PopupOwner,
Disposable,
Queryable {
    private final NavBarModel myModel;
    private final NavBarPresentation myPresentation;
    private final Project myProject;
    private final ArrayList<NavBarItem> myList;
    private final ModuleDeleteProvider myDeleteModuleProvider;
    private final IdeView myIdeView;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private LightweightHint myHint;
    private NavBarPopup myNodePopup;
    private JComponent myHintContainer;
    private Component myContextComponent;
    private final NavBarUpdateQueue myUpdateQueue;
    private NavBarItem myContextObject;
    private boolean myDisposed;
    private RelativePoint myLocationCache;

    public NavBarPanel(@NotNull Project project2, boolean docked) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/navigationToolbar/NavBarPanel", "<init>"));
        }
        super(new FlowLayout(0, 0, 0));
        this.myList = new ArrayList();
        this.myDeleteModuleProvider = new ModuleDeleteProvider();
        this.myHint = null;
        this.myNodePopup = null;
        this.myDisposed = false;
        this.myProject = project2;
        this.myModel = this.createModel();
        this.myIdeView = new NavBarIdeView(this);
        this.myPresentation = new NavBarPresentation(this.myProject);
        this.myUpdateQueue = new NavBarUpdateQueue(this);
        CustomizationUtil.installPopupHandler(this, "NavbarPopupMenu", "NavBar");
        this.setOpaque(false);
        if (!docked && UIUtil.isUnderDarcula()) {
            this.setBorder(new LineBorder((Color)Gray._120, 1));
        }
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray;
                PsiElement element = NavBarPanel.this.getSelectedElement(PsiElement.class);
                if (element == null) {
                    psiElementArray = PsiElement.EMPTY_ARRAY;
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = element;
                }
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPanel$1", "getSelectedElements"));
                }
                return psiElementArray;
            }
        };
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        if (!docked) {
            ActionCallback typeAheadDone = new ActionCallback();
            IdeFocusManager.getInstance((Project)project2).typeAheadUntil(typeAheadDone);
            this.myUpdateQueue.queueTypeAheadDone(typeAheadDone);
        }
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    protected NavBarModel createModel() {
        return new NavBarModel(this.myProject);
    }

    public boolean isNodePopupActive() {
        return this.myNodePopup != null && this.myNodePopup.isVisible();
    }

    public LightweightHint getHint() {
        return this.myHint;
    }

    public NavBarPresentation getPresentation() {
        return this.myPresentation;
    }

    public void setContextComponent(@Nullable Component contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public NavBarItem getContextObject() {
        return this.myContextObject;
    }

    public List<NavBarItem> getItems() {
        return Collections.unmodifiableList(this.myList);
    }

    public void addItem(NavBarItem item) {
        this.myList.add(item);
    }

    public void clearItems() {
        final NavBarItem[] toDispose = this.myList.toArray(new NavBarItem[this.myList.size()]);
        this.myList.clear();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (NavBarItem item : toDispose) {
                    Disposer.dispose((Disposable)item);
                }
            }
        });
        this.getNavBarUI().clearItems();
    }

    @Override
    public void setUI(PanelUI ui) {
        this.getNavBarUI().clearItems();
        super.setUI(ui);
    }

    public NavBarUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    public void escape() {
        this.myModel.setSelectedIndex(-1);
        this.hideHint();
        ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
    }

    public void enter() {
        this.navigateInsideBar(this.myModel.getSelectedValue());
    }

    public void moveHome() {
        this.shiftFocus(-this.myModel.getSelectedIndex());
    }

    public void navigate() {
        if (this.myModel.getSelectedIndex() != -1) {
            this.doubleClick(this.myModel.getSelectedIndex());
        }
    }

    public void moveDown() {
        int index = this.myModel.getSelectedIndex();
        if (index != -1) {
            if (this.myModel.size() - 1 == index) {
                this.shiftFocus(-1);
                this.ctrlClick(index - 1);
            } else {
                this.ctrlClick(index);
            }
        }
    }

    public void moveEnd() {
        this.shiftFocus(this.myModel.size() - 1 - this.myModel.getSelectedIndex());
    }

    public Project getProject() {
        return this.myProject;
    }

    public NavBarModel getModel() {
        return this.myModel;
    }

    public void dispose() {
        this.cancelPopup();
        this.getNavBarUI().clearItems();
        this.myDisposed = true;
        NavBarListener.unsubscribeFrom(this);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    boolean isSelectedInPopup(Object object) {
        return this.isNodePopupActive() && Arrays.asList(this.myNodePopup.getSelectedValues()).contains(object);
    }

    static Object optimizeTarget(Object target) {
        PsiDirectory[] subDir;
        if (target instanceof PsiDirectory && ((PsiDirectory)target).getFiles().length == 0 && (subDir = ((PsiDirectory)target).getSubdirectories()).length == 1) {
            return NavBarPanel.optimizeTarget(subDir[0]);
        }
        return target;
    }

    void updateItems() {
        NavBarRootPaneExtension.NavBarWrapperPanel wrapperPanel;
        for (NavBarItem item : this.myList) {
            item.update();
        }
        if (UISettings.getInstance().SHOW_NAVIGATION_BAR && (wrapperPanel = (NavBarRootPaneExtension.NavBarWrapperPanel)SwingUtilities.getAncestorOfClass(NavBarRootPaneExtension.NavBarWrapperPanel.class, this)) != null) {
            wrapperPanel.revalidate();
            wrapperPanel.repaint();
        }
    }

    public void rebuildAndSelectTail(final boolean requestFocus) {
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueSelect(new Runnable(){

            @Override
            public void run() {
                if (!NavBarPanel.this.myList.isEmpty()) {
                    NavBarPanel.this.myModel.setSelectedIndex(NavBarPanel.this.myList.size() - 1);
                    if (requestFocus) {
                        IdeFocusManager.getInstance((Project)NavBarPanel.this.myProject).requestFocus((Component)NavBarPanel.this, true);
                    }
                }
            }
        });
        this.myUpdateQueue.flush();
    }

    public void moveLeft() {
        this.shiftFocus(-1);
    }

    public void moveRight() {
        this.shiftFocus(1);
    }

    void shiftFocus(int direction) {
        int selectedIndex = this.myModel.getSelectedIndex();
        int index = this.myModel.getIndexByModel(selectedIndex + direction);
        this.myModel.setSelectedIndex(index);
    }

    void scrollSelectionToVisible() {
        int selectedIndex = this.myModel.getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex >= this.myList.size()) {
            return;
        }
        this.scrollRectToVisible(this.myList.get(selectedIndex).getBounds());
    }

    @Nullable
    private NavBarItem getItem(int index) {
        if (index != -1 && index < this.myList.size()) {
            return this.myList.get(index);
        }
        return null;
    }

    public boolean isInFloatingMode() {
        return this.myHint != null && this.myHint.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.myList.isEmpty()) {
            return super.getPreferredSize();
        }
        final NavBarItem item = new NavBarItem(this, null, 0, null);
        Dimension size = item.getPreferredSize();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Disposer.dispose((Disposable)item);
            }
        });
        return size;
    }

    boolean isRebuildUiNeeded() {
        this.myModel.revalidate();
        if (this.myList.size() == this.myModel.size()) {
            int index = 0;
            for (NavBarItem eachLabel : this.myList) {
                Object eachElement = this.myModel.get(index);
                if (eachLabel.getObject() == null || !eachLabel.getObject().equals(eachElement)) {
                    return true;
                }
                if (!StringUtil.equals((CharSequence)eachLabel.getText(), (CharSequence)this.getPresentation().getPresentableText(eachElement))) {
                    return true;
                }
                SimpleTextAttributes modelAttributes1 = this.myPresentation.getTextAttributes(eachElement, true);
                SimpleTextAttributes modelAttributes2 = this.myPresentation.getTextAttributes(eachElement, false);
                SimpleTextAttributes labelAttributes = eachLabel.getAttributes();
                if (!modelAttributes1.toTextAttributes().equals((Object)labelAttributes.toTextAttributes()) && !modelAttributes2.toTextAttributes().equals((Object)labelAttributes.toTextAttributes())) {
                    return true;
                }
                ++index;
            }
            return false;
        }
        return true;
    }

    @Nullable
    Window getWindow() {
        return !this.isShowing() ? null : (Window)UIUtil.findUltimateParent((Component)this);
    }

    public void installActions(final int index, NavBarItem component) {
        ListenerUtil.addMouseListener((Component)((Object)component), new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    NavBarPanel.this.myModel.setSelectedIndex(index);
                    IdeFocusManager.getInstance((Project)NavBarPanel.this.myProject).requestFocus((Component)NavBarPanel.this, true);
                    NavBarPanel.this.rightClick(index);
                    e.consume();
                } else if (!e.isPopupTrigger()) {
                    if (e.getClickCount() == 1) {
                        NavBarPanel.this.ctrlClick(index);
                        NavBarPanel.this.myModel.setSelectedIndex(index);
                        e.consume();
                    } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                        NavBarPanel.this.myModel.setSelectedIndex(index);
                        IdeFocusManager.getInstance((Project)NavBarPanel.this.myProject).requestFocus((Component)NavBarPanel.this, true);
                        NavBarPanel.this.doubleClick(index);
                        e.consume();
                    }
                }
            }
        });
    }

    private void installDnD(final int index, NavBarItem component) {
        DnDSupport.createBuilder((JComponent)((Object)component)).setBeanProvider((Function)new Function<DnDActionInfo, DnDDragStartBean>(){

            public DnDDragStartBean fun(DnDActionInfo dnDActionInfo) {
                return new DnDDragStartBean((Object)new TransferableWrapper(){

                    @Override
                    public List<File> asFileList() {
                        Object o = NavBarPanel.this.myModel.get(index);
                        if (o instanceof PsiElement) {
                            VirtualFile vf;
                            VirtualFile virtualFile = vf = o instanceof PsiDirectory ? ((PsiDirectory)o).getVirtualFile() : ((PsiElement)o).getContainingFile().getVirtualFile();
                            if (vf != null) {
                                return Arrays.asList(new File(vf.getPath()).getAbsoluteFile());
                            }
                        }
                        return Collections.emptyList();
                    }

                    @Override
                    public TreeNode[] getTreeNodes() {
                        return null;
                    }

                    @Override
                    public PsiElement[] getPsiElements() {
                        return null;
                    }
                });
            }
        }).setDisposableParent((Disposable)component).install();
    }

    private void doubleClick(int index) {
        this.doubleClick(this.myModel.getElement(index));
    }

    private void doubleClick(Object object) {
        if (object instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)object;
            if (navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else if (object instanceof Module) {
            ProjectView projectView = ProjectView.getInstance(this.myProject);
            AbstractProjectViewPane projectViewPane = projectView.getProjectViewPaneById(projectView.getCurrentViewId());
            if (projectViewPane != null) {
                projectViewPane.selectModule((Module)object, true);
            }
        } else if (object instanceof Project) {
            return;
        }
        this.hideHint(true);
    }

    private void ctrlClick(int index) {
        Object object;
        List<Object> objects;
        if (this.isNodePopupShowing()) {
            this.cancelPopup();
            if (this.myModel.getSelectedIndex() == index) {
                return;
            }
        }
        if (!(objects = this.myModel.getChildren(object = this.myModel.getElement(index))).isEmpty()) {
            Object[] siblings = new Object[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                siblings[i] = objects.get(i);
            }
            NavBarItem item = this.getItem(index);
            int selectedIndex = index < this.myModel.size() - 1 ? objects.indexOf(this.myModel.getElement(index + 1)) : 0;
            this.myNodePopup = new NavBarPopup(this, siblings, selectedIndex);
            if (item != null && item.isShowing()) {
                this.myNodePopup.show(item);
                item.update();
            }
        }
    }

    boolean isNodePopupShowing() {
        return this.myNodePopup != null && this.myNodePopup.isVisible();
    }

    protected void navigateInsideBar(Object object) {
        final Object obj = NavBarPanel.optimizeTarget(object);
        this.myContextObject = null;
        this.myUpdateQueue.cancelAllUpdates();
        if (this.myNodePopup != null && this.myNodePopup.isVisible()) {
            this.myUpdateQueue.queueModelUpdateForObject(obj);
        }
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueAfterAll(new Runnable(){

            @Override
            public void run() {
                int index = NavBarPanel.this.myModel.indexOf(obj);
                if (index >= 0) {
                    NavBarPanel.this.myModel.setSelectedIndex(index);
                }
                if (NavBarPanel.this.myModel.hasChildren(obj)) {
                    NavBarPanel.this.restorePopup();
                } else {
                    NavBarPanel.this.doubleClick(obj);
                }
            }
        }, NavBarUpdateQueue.ID.NAVIGATE_INSIDE);
    }

    void rightClick(int index) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("NavbarPopupMenu");
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("NavBar", group);
        NavBarItem item = this.getItem(index);
        if (item != null) {
            popupMenu.getComponent().show(this, item.getX(), item.getY() + item.getHeight());
        }
    }

    void restorePopup() {
        this.cancelPopup();
        this.ctrlClick(this.myModel.getSelectedIndex());
    }

    void cancelPopup() {
        this.cancelPopup(false);
    }

    void cancelPopup(boolean ok) {
        if (this.myNodePopup != null) {
            this.myNodePopup.hide(ok);
            this.myNodePopup = null;
        }
    }

    void hideHint() {
        this.hideHint(false);
    }

    void hideHint(boolean ok) {
        this.cancelPopup(ok);
        if (this.myHint != null) {
            this.myHint.hide(ok);
            this.myHint = null;
        }
    }

    @Nullable
    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !this.myProject.isDisposed() ? this.myProject : null;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            Module module2 = this.getSelectedElement(Module.class);
            if (module2 != null && !module2.isDisposed()) {
                return module2;
            }
            PsiElement element = this.getSelectedElement(PsiElement.class);
            if (element != null) {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            }
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            VirtualFile dir;
            PsiDirectory directory = this.getSelectedElement(PsiDirectory.class);
            if (directory != null && ProjectRootsUtil.isModuleContentRoot(dir = directory.getVirtualFile(), this.myProject)) {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
            }
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element = this.getSelectedElement(PsiElement.class);
            return element != null && element.isValid() ? element : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List<PsiElement> elements = this.getSelectedElements(PsiElement.class);
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiElement element : elements) {
                if (element == null || !element.isValid()) continue;
                result.add(element);
            }
            return result.isEmpty() ? null : result.toArray(new PsiElement[result.size()]);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            PsiElement[] psiElements = (PsiElement[])this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
            if (psiElements == null) {
                return null;
            }
            LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
            for (PsiElement element : psiElements) {
                PsiFile file2 = element.getContainingFile();
                if (file2 != null) {
                    VirtualFile virtualFile = file2.getVirtualFile();
                    if (virtualFile == null) continue;
                    files.add(virtualFile);
                    continue;
                }
                if (!(element instanceof PsiFileSystemItem)) continue;
                files.add(((PsiFileSystemItem)element).getVirtualFile());
            }
            return !files.isEmpty() ? VfsUtilCore.toVirtualFileArray(files) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> elements = this.getSelectedElements(Navigatable.class);
            return elements == null || elements.isEmpty() ? null : elements.toArray(new Navigatable[elements.size()]);
        }
        if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectedElement(Module.class) != null ? this.myDeleteModuleProvider : new DeleteHandler.DefaultDeleteProvider();
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        return null;
    }

    @Nullable
    <T> T getSelectedElement(Class<T> klass) {
        int modelSize;
        Object value = null;
        if (this.myNodePopup != null) {
            value = this.myNodePopup.getSelectedValue();
        }
        if (value == null) {
            value = this.myModel.getSelectedValue();
        }
        if (value == null && (modelSize = this.myModel.size()) > 0) {
            value = this.myModel.getElement(modelSize - 1);
        }
        return (T)(value != null && klass.isAssignableFrom(value.getClass()) ? value : null);
    }

    @Nullable
    <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] values = null;
        if (this.myNodePopup != null) {
            values = this.myNodePopup.getSelectedValues();
        }
        if (values == null) {
            T selectedElement = this.getSelectedElement(klass);
            return selectedElement == null ? null : Arrays.asList(selectedElement);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            if (value == null || !klass.isAssignableFrom(value.getClass())) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public Point getBestPopupPosition() {
        NavBarItem item;
        int index = this.myModel.getSelectedIndex();
        int modelSize = this.myModel.size();
        if (index == -1) {
            index = modelSize - 1;
        }
        if (index > -1 && index < modelSize && (item = this.getItem(index)) != null) {
            return new Point(item.getX(), item.getY() + item.getHeight());
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        NavBarListener.subscribeTo(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            Disposer.dispose((Disposable)this);
        }
    }

    public void updateState(boolean show) {
        if (show) {
            this.myUpdateQueue.queueModelUpdateFromFocus();
            this.myUpdateQueue.queueRebuildUi();
        }
    }

    public void showHint(final @Nullable Editor editor, DataContext dataContext) {
        this.myModel.updateModel(dataContext);
        if (this.myModel.isEmpty()) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this);
        panel.setOpaque(true);
        panel.setBackground(UIUtil.isUnderGTKLookAndFeel() ? Color.WHITE : UIUtil.getListBackground());
        this.myHint = new LightweightHint(panel){

            @Override
            public void hide() {
                super.hide();
                NavBarPanel.this.cancelPopup();
                Disposer.dispose((Disposable)NavBarPanel.this);
            }
        };
        this.myHint.setForceShowAsPopup(true);
        this.myHint.setFocusRequestor(this);
        final KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.myUpdateQueue.rebuildUi();
        if (editor == null) {
            this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.getHintContainerShowPoint().doWhenDone((Consumer)new Consumer<RelativePoint>(){

                public void consume(RelativePoint relativePoint) {
                    Component owner = focusManager.getFocusOwner();
                    Component cmp = relativePoint.getComponent();
                    if (cmp instanceof JComponent && cmp.isShowing()) {
                        NavBarPanel.this.myHint.show((JComponent)cmp, relativePoint.getPoint().x, relativePoint.getPoint().y, owner instanceof JComponent ? (JComponent)owner : null, new HintHint(relativePoint.getComponent(), relativePoint.getPoint()));
                    }
                }
            });
        } else {
            this.myHintContainer = editor.getContentComponent();
            this.getHintContainerShowPoint().doWhenDone((Consumer)new Consumer<RelativePoint>(){

                public void consume(RelativePoint rp) {
                    Point p = rp.getPointOn((Component)NavBarPanel.this.myHintContainer).getPoint();
                    HintHint hintInfo = new HintHint(editor, p);
                    HintManagerImpl.getInstanceImpl().showEditorHint(NavBarPanel.this.myHint, editor, p, 1, 0, true, hintInfo);
                }
            });
        }
        this.rebuildAndSelectTail(true);
    }

    AsyncResult<RelativePoint> getHintContainerShowPoint() {
        Component c;
        AsyncResult result = new AsyncResult();
        if (this.myLocationCache == null) {
            if (this.myHintContainer != null) {
                Point p = AbstractPopup.getCenterOf(this.myHintContainer, this);
                p.y -= this.myHintContainer.getVisibleRect().height / 4;
                this.myLocationCache = RelativePoint.fromScreen((Point)p);
            } else if (this.myContextComponent != null) {
                this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(DataManager.getInstance().getDataContext(this.myContextComponent));
            } else {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                    public void consume(DataContext dataContext) {
                        NavBarPanel.this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                        NavBarPanel.this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(DataManager.getInstance().getDataContext(NavBarPanel.this.myContextComponent));
                    }
                });
            }
        }
        if (!((c = this.myLocationCache.getComponent()) instanceof JComponent) || !c.isShowing()) {
            JComponent ideFrame = WindowManager.getInstance().getIdeFrame(this.getProject()).getComponent();
            JRootPane rootPane = UIUtil.getRootPane((Component)ideFrame);
            this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)rootPane);
        }
        result.setDone((Object)this.myLocationCache);
        return result;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ide/navigationToolbar/NavBarPanel", "putInfo"));
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.myList.size(); ++i) {
            NavBarItem each = this.myList.get(i);
            if (each.isSelected()) {
                result.append("[" + each.getText() + "]");
            } else {
                result.append(each.getText());
            }
            if (i >= this.myList.size() - 1) continue;
            result.append(">");
        }
        info.put("navBar", result.toString());
        if (this.isNodePopupShowing()) {
            StringBuilder popupText = new StringBuilder();
            JBList list = this.myNodePopup.getList();
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                Object eachElement = list.getModel().getElementAt(i);
                String text = new NavBarItem(this, eachElement, this.myNodePopup).getText();
                int selectedIndex = list.getSelectedIndex();
                if (selectedIndex != -1 && eachElement.equals(list.getSelectedValue())) {
                    popupText.append("[" + text + "]");
                } else {
                    popupText.append(text);
                }
                if (i >= list.getModel().getSize() - 1) continue;
                popupText.append(">");
            }
            info.put("navBarPopup", popupText.toString());
        }
    }

    @NotNull
    public NavBarUI getNavBarUI() {
        NavBarUI navBarUI = NavBarUIManager.getUI();
        if (navBarUI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPanel", "getNavBarUI"));
        }
        return navBarUI;
    }
}

