/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.formatter.JsonFormattingBuilderModel;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBlock
implements ASTBlock {
    private static final TokenSet JSON_OPEN_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.L_CURLY});
    private static final TokenSet JSON_CLOSE_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.R_BRACKET, JsonElementTypes.R_CURLY});
    private static final TokenSet JSON_ALL_BRACES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSON_OPEN_BRACES, JSON_CLOSE_BRACES});
    private final JsonBlock myParent;
    private final ASTNode myNode;
    private final PsiElement myPsiElement;
    private final Alignment myAlignment;
    private final Indent myIndent;
    private final Wrap myWrap;
    private final CodeStyleSettings mySettings;
    private final SpacingBuilder mySpacingBuilder;
    private List<Block> mySubBlocks;
    private final Alignment myPropertyValueAlignment;
    private final Wrap myChildWrap;

    public JsonBlock(@Nullable JsonBlock parent, @NotNull ASTNode node, @NotNull CodeStyleSettings settings, @Nullable Alignment alignment, @NotNull Indent indent, @Nullable Wrap wrap) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/formatter/JsonBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/json/formatter/JsonBlock", "<init>"));
        }
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/json/formatter/JsonBlock", "<init>"));
        }
        this.mySubBlocks = null;
        this.myParent = parent;
        this.myNode = node;
        this.myPsiElement = node.getPsi();
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.mySettings = settings;
        this.mySpacingBuilder = JsonFormattingBuilderModel.createSpacingBuilder(settings);
        this.myChildWrap = this.myPsiElement instanceof JsonObject ? Wrap.createWrap((int)this.getCustomSettings().OBJECT_WRAPPING, (boolean)true) : (this.myPsiElement instanceof JsonArray ? Wrap.createWrap((int)this.getCustomSettings().ARRAY_WRAPPING, (boolean)true) : null);
        this.myPropertyValueAlignment = this.myPsiElement instanceof JsonObject ? Alignment.createAlignment((boolean)true) : null;
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = ContainerUtil.mapNotNull((Object[])this.myNode.getChildren(null), (Function)new Function<ASTNode, Block>(){

                public Block fun(ASTNode node) {
                    if (JsonBlock.isWhitespaceOrEmpty(node)) {
                        return null;
                    }
                    return JsonBlock.this.makeSubBlock(node);
                }
            });
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonBlock", "getSubBlocks"));
        }
        return list;
    }

    private Block makeSubBlock(@NotNull ASTNode childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/json/formatter/JsonBlock", "makeSubBlock"));
        }
        Indent indent = Indent.getNoneIndent();
        Alignment alignment = null;
        Wrap wrap = null;
        JsonCodeStyleSettings customSettings = this.getCustomSettings();
        if (JsonPsiUtil.hasElementType(this.myNode, JsonParserDefinition.JSON_CONTAINERS)) {
            if (JsonPsiUtil.hasElementType(childNode, JsonElementTypes.COMMA)) {
                wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
            } else if (!JsonPsiUtil.hasElementType(childNode, JSON_ALL_BRACES)) {
                assert (this.myChildWrap != null);
                wrap = this.myChildWrap;
                indent = Indent.getNormalIndent();
            } else if (JsonPsiUtil.hasElementType(childNode, JSON_OPEN_BRACES) && JsonPsiUtil.isPropertyValue(this.myPsiElement) && customSettings.PROPERTY_ALIGNMENT == JsonCodeStyleSettings.ALIGN_PROPERTY_ON_VALUE) {
                assert (this.myParent != null && this.myParent.myParent != null && this.myParent.myParent.myPropertyValueAlignment != null);
                alignment = this.myParent.myParent.myPropertyValueAlignment;
            }
        } else if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.PROPERTY)) {
            assert (this.myParent != null && this.myParent.myPropertyValueAlignment != null);
            if (JsonPsiUtil.hasElementType(childNode, JsonElementTypes.COLON) && customSettings.PROPERTY_ALIGNMENT == JsonCodeStyleSettings.ALIGN_PROPERTY_ON_COLON) {
                alignment = this.myParent.myPropertyValueAlignment;
            } else if (JsonPsiUtil.isPropertyValue(childNode.getPsi()) && customSettings.PROPERTY_ALIGNMENT == JsonCodeStyleSettings.ALIGN_PROPERTY_ON_VALUE && !JsonPsiUtil.hasElementType(childNode, JsonParserDefinition.JSON_CONTAINERS)) {
                alignment = this.myParent.myPropertyValueAlignment;
            }
        }
        return new JsonBlock(this, childNode, this.mySettings, alignment, indent, wrap);
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/json/formatter/JsonBlock", "getSpacing"));
        }
        return this.mySpacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (JsonPsiUtil.hasElementType(this.myNode, JsonParserDefinition.JSON_CONTAINERS)) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.myNode.getPsi() instanceof PsiFile) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(null, null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.OBJECT)) {
            return lastChildNode != null && lastChildNode.getElementType() != JsonElementTypes.R_CURLY;
        }
        if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.ARRAY)) {
            return lastChildNode != null && lastChildNode.getElementType() != JsonElementTypes.R_BRACKET;
        }
        if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.PROPERTY)) {
            return ((JsonProperty)this.myPsiElement).getValue() == null;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    private static boolean isWhitespaceOrEmpty(ASTNode node) {
        return node.getElementType() == TokenType.WHITE_SPACE || node.getTextLength() == 0;
    }

    private JsonCodeStyleSettings getCustomSettings() {
        return (JsonCodeStyleSettings)this.mySettings.getCustomSettings(JsonCodeStyleSettings.class);
    }

    private CommonCodeStyleSettings getCommonSettings() {
        return this.mySettings.getCommonSettings((Language)JsonLanguage.INSTANCE);
    }
}

