/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNode<T>
extends SimpleNode
implements Comparable<ExternalSystemNode> {
    @NotNull
    public static final Comparator<ExternalSystemNode> ORDER_AWARE_COMPARATOR = new Comparator<ExternalSystemNode>(){

        @Override
        public int compare(@NotNull ExternalSystemNode o1, @NotNull ExternalSystemNode o2) {
            int order2;
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/externalSystem/view/ExternalSystemNode$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/externalSystem/view/ExternalSystemNode$1", "compare"));
            }
            int order1 = this.getOrder(o1);
            if (order1 == (order2 = this.getOrder(o2))) {
                return o1.compareTo(o2);
            }
            return order1 < order2 ? -1 : 1;
        }

        private int getOrder(@NotNull Comparable o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/externalSystem/view/ExternalSystemNode$1", "getOrder"));
            }
            Order annotation = o.getClass().getAnnotation(Order.class);
            if (annotation != null) {
                return annotation.value();
            }
            return 0;
        }
    };
    protected static final ExternalSystemNode[] NO_CHILDREN = new ExternalSystemNode[0];
    private final ExternalProjectsView myExternalProjectsView;
    private final List<ExternalSystemNode<?>> myChildrenList;
    protected DataNode<T> myDataNode;
    @Nullable
    private ExternalSystemNode myParent;
    private ExternalSystemNode[] myChildren;
    private ExternalProjectsStructure.ErrorLevel myErrorLevel;
    private final List<String> myErrors;
    private ExternalProjectsStructure.ErrorLevel myTotalErrorLevel;

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "<init>"));
        }
        this(externalProjectsView, parent, null);
    }

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "<init>"));
        }
        super(externalProjectsView.getProject(), null);
        this.myChildrenList = ContainerUtil.newArrayList();
        this.myErrorLevel = ExternalProjectsStructure.ErrorLevel.NONE;
        this.myErrors = ContainerUtil.newArrayList();
        this.myTotalErrorLevel = null;
        this.myExternalProjectsView = externalProjectsView;
        this.myDataNode = dataNode;
        this.myParent = parent;
    }

    public boolean isAutoExpandNode() {
        SimpleNode parent = this.getParent();
        return parent != null && parent.getChildCount() == 1;
    }

    public void setParent(@Nullable ExternalSystemNode parent) {
        this.myParent = parent;
    }

    @Nullable
    public T getData() {
        return (T)(this.myDataNode != null ? this.myDataNode.getData() : null);
    }

    public NodeDescriptor getParentDescriptor() {
        return this.myParent;
    }

    protected ExternalProjectsView getExternalProjectsView() {
        return this.myExternalProjectsView;
    }

    protected ExternalSystemUiAware getUiAware() {
        return this.myExternalProjectsView.getUiAware();
    }

    protected ExternalProjectsStructure getStructure() {
        return this.myExternalProjectsView.getStructure();
    }

    protected ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myExternalProjectsView.getShortcutsManager();
    }

    protected ExternalSystemTaskActivator getTaskActivator() {
        return this.myExternalProjectsView.getTaskActivator();
    }

    @Nullable
    public <DataType extends ExternalSystemNode> DataType findParent(Class<DataType> parentClass) {
        ExternalSystemNode node = this;
        while ((node = node.myParent) != null && !parentClass.isInstance(node)) {
        }
        return (DataType)node;
    }

    @Nullable
    public <DataType> DataType findParentData(Class<DataType> parentDataClass) {
        ExternalSystemNode node = this;
        do {
            if ((node = node.myParent) != null) continue;
            return null;
        } while (node.getData() == null || !parentDataClass.isInstance(node.getData()));
        return (DataType)node.getData();
    }

    public boolean isVisible() {
        return this.getDisplayKind() != ExternalProjectsStructure.DisplayKind.NEVER && (!this.isIgnored() || this.myExternalProjectsView.getShowIgnored());
    }

    public boolean isIgnored() {
        if (this.myDataNode != null) {
            return this.myDataNode.isIgnored();
        }
        SimpleNode parent = this.getParent();
        return parent instanceof ExternalSystemNode && ((ExternalSystemNode)parent).isIgnored();
    }

    public void setIgnored(boolean ignored) {
        if (this.myDataNode != null) {
            ExternalProjectsManager.getInstance(this.myExternalProjectsView.getProject()).setIgnored(this.myDataNode, ignored);
        }
    }

    public ExternalProjectsStructure.DisplayKind getDisplayKind() {
        Class<? extends ExternalSystemNode>[] visibles = this.getStructure().getVisibleNodesClasses();
        if (visibles == null) {
            return ExternalProjectsStructure.DisplayKind.NORMAL;
        }
        for (Class<? extends ExternalSystemNode> each : visibles) {
            if (!each.isInstance(this)) continue;
            return ExternalProjectsStructure.DisplayKind.ALWAYS;
        }
        return ExternalProjectsStructure.DisplayKind.NEVER;
    }

    @NotNull
    public final ExternalSystemNode[] getChildren() {
        if (this.myChildren == null) {
            this.myChildren = this.buildChildren();
            this.onChildrenBuilt();
        }
        if (this.myChildren == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "getChildren"));
        }
        return this.myChildren;
    }

    protected void onChildrenBuilt() {
    }

    @NotNull
    private ExternalSystemNode[] buildChildren() {
        List<ExternalSystemNode> newChildrenCandidates = this.doBuildChildren();
        if (newChildrenCandidates.isEmpty()) {
            if (NO_CHILDREN == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "buildChildren"));
            }
            return NO_CHILDREN;
        }
        this.addAll(newChildrenCandidates, true);
        this.sort(this.myChildrenList);
        ArrayList visibleNodes = new ArrayList();
        for (ExternalSystemNode<?> each : this.myChildrenList) {
            if (!each.isVisible()) continue;
            visibleNodes.add(each);
        }
        ExternalSystemNode[] externalSystemNodeArray = visibleNodes.toArray(new ExternalSystemNode[visibleNodes.size()]);
        if (externalSystemNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "buildChildren"));
        }
        return externalSystemNodeArray;
    }

    public void cleanUpCache() {
        this.myChildren = null;
        this.myChildrenList.clear();
        this.myTotalErrorLevel = null;
    }

    @Nullable
    protected ExternalSystemNode[] getCached() {
        return this.myChildren;
    }

    protected void sort(List<? extends ExternalSystemNode> list) {
        Collections.sort(list, ORDER_AWARE_COMPARATOR);
    }

    public boolean addAll(Collection<? extends ExternalSystemNode> externalSystemNodes) {
        return this.addAll(externalSystemNodes, false);
    }

    private boolean addAll(Collection<? extends ExternalSystemNode> externalSystemNodes, boolean silently) {
        if (externalSystemNodes.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : externalSystemNodes) {
            externalSystemNode.setParent(this);
            this.myChildrenList.add(externalSystemNode);
        }
        if (!silently) {
            this.childrenChanged();
        }
        return true;
    }

    public boolean add(ExternalSystemNode externalSystemNode) {
        return this.addAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    public boolean removeAll(Collection<ExternalSystemNode> externalSystemNodes) {
        return this.removeAll(externalSystemNodes, false);
    }

    private boolean removeAll(Collection<ExternalSystemNode> externalSystemNodes, boolean silently) {
        if (externalSystemNodes.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : externalSystemNodes) {
            externalSystemNode.setParent(null);
            this.myChildrenList.remove(externalSystemNode);
        }
        if (!silently) {
            this.childrenChanged();
        }
        return true;
    }

    public void remove(ExternalSystemNode externalSystemNode) {
        this.removeAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    protected void childrenChanged() {
        for (ExternalSystemNode each = this; each != null; each = (ExternalSystemNode)each.getParent()) {
            each.myTotalErrorLevel = null;
        }
        this.sort(this.myChildrenList);
        List visibleNodes = ContainerUtil.filter(this.myChildrenList, (Condition)new Condition<ExternalSystemNode<?>>(){

            public boolean value(ExternalSystemNode<?> node) {
                return node.isVisible();
            }
        });
        this.myChildren = visibleNodes.toArray(new ExternalSystemNode[visibleNodes.size()]);
        this.myExternalProjectsView.updateUpTo(this);
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        if (this.myDataNode != null && !this.myDataNode.getChildren().isEmpty()) {
            ExternalProjectsView externalProjectsView = this.getExternalProjectsView();
            List<ExternalSystemNode<?>> list = externalProjectsView.createNodes(externalProjectsView, this, this.myDataNode);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "doBuildChildren"));
            }
            return list;
        }
        List<ExternalSystemNode<?>> list = this.myChildrenList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "doBuildChildren"));
        }
        return list;
    }

    protected void setDataNode(DataNode<T> dataNode) {
        this.myDataNode = dataNode;
    }

    public ExternalProjectsStructure.ErrorLevel getTotalErrorLevel() {
        if (this.myTotalErrorLevel == null) {
            this.myTotalErrorLevel = this.calcTotalErrorLevel();
        }
        return this.myTotalErrorLevel;
    }

    private ExternalProjectsStructure.ErrorLevel calcTotalErrorLevel() {
        ExternalProjectsStructure.ErrorLevel childrenErrorLevel = this.getChildrenErrorLevel();
        return childrenErrorLevel.compareTo(this.myErrorLevel) > 0 ? childrenErrorLevel : this.myErrorLevel;
    }

    public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        ExternalProjectsStructure.ErrorLevel result = ExternalProjectsStructure.ErrorLevel.NONE;
        for (ExternalSystemNode each : this.getChildren()) {
            ExternalProjectsStructure.ErrorLevel eachLevel = each.getTotalErrorLevel();
            if (eachLevel.compareTo(result) <= 0) continue;
            result = eachLevel;
        }
        return result;
    }

    public void setErrorLevel(ExternalProjectsStructure.ErrorLevel level, String ... errors) {
        if (this.myErrorLevel == level) {
            return;
        }
        this.myErrorLevel = level;
        this.myErrors.clear();
        Collections.addAll(this.myErrors, errors);
        this.myExternalProjectsView.updateUpTo(this);
    }

    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), null);
    }

    protected void setNameAndTooltip(String name, @Nullable String tooltip) {
        this.setNameAndTooltip(name, tooltip, (String)null);
    }

    protected void setNameAndTooltip(String name, @Nullable String tooltip, @Nullable String hint) {
        boolean ignored = this.isIgnored();
        SimpleTextAttributes textAttributes = ignored ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : this.getPlainAttributes();
        this.setNameAndTooltip(name, tooltip, textAttributes);
        if (!StringUtil.isEmptyOrSpaces((String)hint)) {
            this.addColoredFragment(" (" + hint + ")", ignored ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected void setNameAndTooltip(String name, @Nullable String tooltip, SimpleTextAttributes attributes) {
        this.clearColoredText();
        this.addColoredFragment(name, this.prepareAttributes(attributes));
        String s = (tooltip != null ? tooltip + "\n\r" : "") + StringUtil.join(this.myErrors, (String)"\n\r");
        this.getTemplatePresentation().setTooltip(s);
    }

    private SimpleTextAttributes prepareAttributes(SimpleTextAttributes from) {
        ExternalProjectsStructure.ErrorLevel level = this.getTotalErrorLevel();
        JBColor waveColor = level == ExternalProjectsStructure.ErrorLevel.NONE ? null : JBColor.RED;
        int style = from.getStyle();
        if (waveColor != null) {
            style |= 8;
        }
        return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), (Color)waveColor, style);
    }

    @Nullable
    @NonNls
    protected String getActionId() {
        return null;
    }

    @Nullable
    @NonNls
    protected String getMenuId() {
        return null;
    }

    protected String message(@NotNull String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "message"));
        }
        return ExternalSystemBundle.message((String)key, (Object[])params);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        String actionId = this.getActionId();
        this.getExternalProjectsView().handleDoubleClickOrEnter(this, actionId, inputEvent);
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/view/ExternalSystemNode", "compareTo"));
        }
        return StringUtil.compare((String)this.getName(), (String)node.getName(), (boolean)true);
    }
}

