/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.DetectedRootsChooserDialog;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootDetectionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraryEditor.RootDetectionUtil");

    private RootDetectionUtil() {
    }

    @NotNull
    public static List<OrderRoot> detectRoots(@NotNull Collection<VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project2, @NotNull LibraryRootsComponentDescriptor rootsComponentDescriptor) {
        if (rootCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidates", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        if (rootsComponentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsComponentDescriptor", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        List<OrderRoot> list = RootDetectionUtil.detectRoots(rootCandidates, parentComponent, project2, rootsComponentDescriptor.getRootsDetector(), rootsComponentDescriptor.getRootTypes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<OrderRoot> detectRoots(final @NotNull Collection<VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project2, final @NotNull LibraryRootsDetector detector, @NotNull OrderRootType[] rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
        if (rootCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidates", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        if (rootTypesAllowedToBeSelectedByUserIfNothingIsDetected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypesAllowedToBeSelectedByUserIfNothingIsDetected", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        final ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        final ArrayList<SuggestedChildRootInfo> suggestedRoots = new ArrayList<SuggestedChildRootInfo>();
        new Task.Modal(project2, "Scanning for Roots", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil$1", "run"));
                }
                try {
                    for (VirtualFile rootCandidate : rootCandidates) {
                        Collection<DetectedLibraryRoot> roots = detector.detectRoots(rootCandidate, indicator);
                        if (!roots.isEmpty() && RootDetectionUtil.allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(roots, rootCandidate)) {
                            for (DetectedLibraryRoot root : roots) {
                                LibraryRootType libraryRootType = root.getTypes().get(0);
                                result.add(new OrderRoot(root.getFile(), libraryRootType.getType(), libraryRootType.isJarDirectory()));
                            }
                            continue;
                        }
                        for (DetectedLibraryRoot root : roots) {
                            HashMap<LibraryRootType, String> names = new HashMap<LibraryRootType, String>();
                            for (LibraryRootType type : root.getTypes()) {
                                String typeName = detector.getRootTypeName(type);
                                LOG.assertTrue(typeName != null, (Object)("Unexpected root type " + type.getType().name() + (type.isJarDirectory() ? " (JAR directory)" : "") + ", detectors: " + detector));
                                names.put(type, typeName);
                            }
                            suggestedRoots.add(new SuggestedChildRootInfo(rootCandidate, root, names));
                        }
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        }.queue();
        if (!suggestedRoots.isEmpty()) {
            DetectedRootsChooserDialog dialog;
            DetectedRootsChooserDialog detectedRootsChooserDialog = dialog = parentComponent != null ? new DetectedRootsChooserDialog(parentComponent, suggestedRoots) : new DetectedRootsChooserDialog(project2, suggestedRoots);
            if (!dialog.showAndGet()) {
                List<OrderRoot> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
                }
                return list;
            }
            for (SuggestedChildRootInfo suggestedChildRootInfo : dialog.getChosenRoots()) {
                LibraryRootType selectedRootType = suggestedChildRootInfo.getSelectedRootType();
                result.add(new OrderRoot(suggestedChildRootInfo.getDetectedRoot().getFile(), selectedRootType.getType(), selectedRootType.isJarDirectory()));
            }
        }
        if (result.isEmpty() && rootTypesAllowedToBeSelectedByUserIfNothingIsDetected.length > 0) {
            HashMap<String, Pair> types = new HashMap<String, Pair>();
            for (OrderRootType orderRootType : rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
                for (Object isJarDirectory : (LibraryRootType)new boolean[]{false, true}) {
                    String typeName = detector.getRootTypeName(new LibraryRootType(orderRootType, (boolean)isJarDirectory));
                    if (typeName == null) continue;
                    types.put(StringUtil.capitalizeWords((String)typeName, (boolean)true), Pair.create((Object)orderRootType, (Object)((boolean)isJarDirectory)));
                }
            }
            LOG.assertTrue(!types.isEmpty(), (Object)("No allowed root types found for " + detector));
            ArrayList<String> arrayList = new ArrayList<String>(types.keySet());
            if (arrayList.size() == 1) {
                int answer;
                String title = "Attach Roots";
                String typeName = (String)arrayList.get(0);
                String string = ApplicationNamesInfo.getInstance().getProductName() + " cannot determine what kind of files the chosen items contain. " + "Do you want to attach them as '" + typeName + "'?";
                int n = answer = parentComponent != null ? Messages.showYesNoDialog((Component)parentComponent, (String)string, (String)title, null) : Messages.showYesNoDialog((Project)project2, (String)string, (String)title, null);
                if (answer == 0) {
                    Pair pair = (Pair)types.get(typeName);
                    for (VirtualFile candidate : rootCandidates) {
                        result.add(new OrderRoot(candidate, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                    }
                }
            } else {
                void var11_23;
                String title = "Choose Categories of Selected Files";
                String description = XmlStringUtil.wrapInHtml((CharSequence)(ApplicationNamesInfo.getInstance().getProductName() + " cannot determine what kind of files the chosen items contain.<br>" + "Choose the appropriate categories from the list."));
                if (parentComponent != null) {
                    ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(parentComponent, arrayList, title, description);
                } else {
                    ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(project2, (List<String>)arrayList, title, description);
                }
                for (String rootType : var11_23.showAndGetResult()) {
                    Pair pair = (Pair)types.get(rootType);
                    for (VirtualFile candidate : rootCandidates) {
                        result.add(new OrderRoot(candidate, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                    }
                }
            }
        }
        ArrayList<OrderRoot> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil", "detectRoots"));
        }
        return arrayList;
    }

    private static boolean allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(Collection<DetectedLibraryRoot> roots, VirtualFile candidate) {
        for (DetectedLibraryRoot root : roots) {
            if (root.getTypes().size() <= 1 && (root.getFile().equals(candidate) || root.getFile().equals(candidate.getParent()))) continue;
            return false;
        }
        return true;
    }

    private static class ChooseRootTypeElementsDialog
    extends ChooseElementsDialog<String> {
        public ChooseRootTypeElementsDialog(Project project2, List<String> names, String title, String description) {
            super(project2, names, title, description, true);
        }

        private ChooseRootTypeElementsDialog(Component parent, List<String> names, String title, String description) {
            super(parent, names, title, description, true);
        }

        @Override
        protected String getItemText(String item) {
            return item;
        }

        @Override
        @Nullable
        protected Icon getItemIcon(String item) {
            return null;
        }
    }
}

