/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.CommonBundle;
import com.intellij.diff.FileAwareSimpleContent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestPresentable
implements DiffRequestPresentable {
    private final Project myProject;
    private final Change myChange;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable");
    private boolean myIgnoreDirectoryFlag;

    public ChangeDiffRequestPresentable(Project project2, Change change) {
        this.myChange = change;
        this.myProject = project2;
    }

    public Change getChange() {
        return this.myChange;
    }

    public void setIgnoreDirectoryFlag(boolean ignoreDirectoryFlag) {
        this.myIgnoreDirectoryFlag = ignoreDirectoryFlag;
    }

    public DiffRequestPresentable.MyResult step(DiffChainContext context) {
        SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
        ArrayList<String> errSb = new ArrayList<String>();
        if (!this.canShowChange(context, errSb)) {
            return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.removeFromList, StringUtil.join(errSb, (String)"\n"));
        }
        if (!this.loadCurrentContents(request, this.myChange)) {
            return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.quit);
        }
        return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.useRequest);
    }

    public String getPathPresentation() {
        return ChangesUtil.getFilePath((Change)this.myChange).getPath();
    }

    public void haveStuff() throws VcsException {
        ArrayList<String> errSb = new ArrayList<String>();
        boolean canShow = ChangeDiffRequestPresentable.checkContentsAvailable(this.myChange.getBeforeRevision(), this.myChange.getAfterRevision(), errSb);
        if (!canShow) {
            throw new VcsException(StringUtil.join(errSb, (String)"\n"));
        }
    }

    public List<? extends AnAction> createActions(DiffExtendUIFactory uiFactory) {
        return uiFactory.createActions(this.myChange);
    }

    private boolean loadCurrentContents(final SimpleDiffRequest request, Change change) {
        String afterRevisionTitle;
        String title;
        String afterPath;
        final ContentRevision bRev = change.getBeforeRevision();
        final ContentRevision aRev = change.getAfterRevision();
        String beforePath = bRev != null ? bRev.getFile().getPath() : null;
        String string = afterPath = aRev != null ? aRev.getFile().getPath() : null;
        if (beforePath != null && afterPath != null && !beforePath.equals(afterPath)) {
            beforePath = FileUtil.toSystemDependentName((String)beforePath);
            afterPath = FileUtil.toSystemDependentName((String)afterPath);
            title = beforePath + " -> " + afterPath;
        } else {
            title = beforePath != null ? (beforePath = FileUtil.toSystemDependentName((String)beforePath)) : (afterPath != null ? (afterPath = FileUtil.toSystemDependentName((String)afterPath)) : VcsBundle.message((String)"diff.unknown.path.title", (Object[])new Object[0]));
        }
        request.setWindowTitle(title);
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                if (pi != null) {
                    pi.setIndeterminate(true);
                }
                request.setContents(ChangeDiffRequestPresentable.this.createContent(bRev), ChangeDiffRequestPresentable.this.createContent(aRev));
            }
        }, VcsBundle.message((String)"progress.loading.diff.revisions", (Object[])new Object[0]), true, this.myProject);
        if (!result) {
            return false;
        }
        String beforeRevisionTitle = bRev != null ? bRev.getRevisionNumber().asString() : "";
        String string2 = afterRevisionTitle = aRev != null ? aRev.getRevisionNumber().asString() : "";
        if (beforeRevisionTitle == null || beforeRevisionTitle.length() == 0) {
            beforeRevisionTitle = "Base version";
        }
        if (afterRevisionTitle == null || afterRevisionTitle.length() == 0) {
            afterRevisionTitle = "Your version";
        }
        request.setContentTitles(beforeRevisionTitle, afterRevisionTitle);
        return true;
    }

    @NotNull
    private DiffContent createContent(ContentRevision revision) {
        String revisionContent;
        ProgressManager.checkCanceled();
        if (revision == null) {
            SimpleContent simpleContent = SimpleContent.createEmpty();
            if (simpleContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
            }
            return simpleContent;
        }
        if (revision instanceof CurrentContentRevision) {
            CurrentContentRevision current = (CurrentContentRevision)revision;
            VirtualFile vFile = current.getVirtualFile();
            Object object = vFile != null ? new FileContent(this.myProject, vFile) : new SimpleContent("");
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
            }
            return object;
        }
        FilePath filePath = revision.getFile();
        if (revision instanceof BinaryContentRevision) {
            FileContent fileContent;
            String name = filePath.getName();
            try {
                fileContent = FileContent.createFromTempFile((Project)this.myProject, (String)name, (String)name, (byte[])((BinaryContentRevision)revision).getBinaryContent());
            }
            catch (IOException e) {
                FileContent fileContent2;
                LOG.info((Throwable)e);
                try {
                    fileContent2 = FileContent.createFromTempFile((Project)this.myProject, (String)name, (String)name, (byte[])ArrayUtil.EMPTY_BYTE_ARRAY);
                }
                catch (IOException e1) {
                    LOG.info((Throwable)e1);
                    if (null == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
                    }
                    return null;
                }
                if (fileContent2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
                }
                return fileContent2;
            }
            catch (VcsException e) {
                FileContent fileContent3;
                LOG.info((Throwable)e);
                try {
                    fileContent3 = FileContent.createFromTempFile((Project)this.myProject, (String)name, (String)name, (byte[])ArrayUtil.EMPTY_BYTE_ARRAY);
                }
                catch (IOException e1) {
                    LOG.info((Throwable)e1);
                    if (null == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
                    }
                    return null;
                }
                if (fileContent3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
                }
                return fileContent3;
            }
            if (fileContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
            }
            return fileContent;
        }
        try {
            revisionContent = revision.getContent();
        }
        catch (VcsException ex) {
            LOG.info((Throwable)ex);
            revisionContent = null;
        }
        SimpleContent content = revisionContent == null ? new SimpleContent("") : new FileAwareSimpleContent(this.myProject, filePath, revisionContent, filePath.getFileType());
        VirtualFile vFile = filePath.getVirtualFile();
        if (vFile != null) {
            content.setCharset(vFile.getCharset());
            content.setBOM(vFile.getBOM());
        }
        content.setReadOnly(true);
        SimpleContent simpleContent = content;
        if (simpleContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable", "createContent"));
        }
        return simpleContent;
    }

    private boolean canShowChange(DiffChainContext context, List<String> errSb) {
        ContentRevision bRev = this.myChange.getBeforeRevision();
        ContentRevision aRev = this.myChange.getAfterRevision();
        if (this.myIgnoreDirectoryFlag) {
            return ChangeDiffRequestPresentable.checkContentsAvailable(bRev, aRev, errSb);
        }
        boolean isOk = this.checkContentRevision(bRev, context, errSb);
        return isOk &= this.checkContentRevision(aRev, context, errSb);
    }

    private boolean checkContentRevision(ContentRevision rev, DiffChainContext context, List<String> errSb) {
        if (rev == null) {
            return true;
        }
        if (rev.getFile().isDirectory()) {
            return false;
        }
        if (!ChangeDiffRequestPresentable.hasContents(rev, errSb)) {
            return false;
        }
        FileType type = rev.getFile().getFileType();
        if (!type.isBinary()) {
            return true;
        }
        if (FileTypes.UNKNOWN.equals(type)) {
            boolean bl = ChangeDiffRequestPresentable.checkAssociate(this.myProject, rev.getFile().getName(), context);
        }
        return true;
    }

    private static boolean hasContents(@Nullable ContentRevision rev, List<String> errSb) {
        if (rev == null) {
            return false;
        }
        try {
            if (rev instanceof BinaryContentRevision) {
                return ((BinaryContentRevision)rev).getBinaryContent() != null;
            }
            return rev.getContent() != null;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            errSb.add(e.getMessage());
            return false;
        }
    }

    private static boolean checkContentsAvailable(@Nullable ContentRevision bRev, @Nullable ContentRevision aRev, List<String> errSb) {
        if (ChangeDiffRequestPresentable.hasContents(bRev, errSb)) {
            return true;
        }
        if (ChangeDiffRequestPresentable.hasContents(aRev, errSb)) {
            return true;
        }
        errSb.add("Can't load revisions content:");
        if (bRev != null) {
            errSb.add("Can't load content of " + bRev.getFile().getPresentableUrl() + " at " + bRev.getRevisionNumber().asString());
        }
        if (aRev != null) {
            errSb.add("Can't load content of " + aRev.getFile().getPresentableUrl() + " at " + aRev.getRevisionNumber().asString());
        }
        if (aRev == null && bRev == null) {
            errSb.add("Both revisions are empty");
        }
        return false;
    }

    public static boolean checkAssociate(Project project2, String fileName, DiffChainContext context) {
        String pattern = FileUtilRt.getExtension((String)fileName).toLowerCase();
        if (context.contains(pattern)) {
            return false;
        }
        int rc = Messages.showOkCancelDialog((Project)project2, (String)VcsBundle.message((String)"diff.unknown.file.type.prompt", (Object[])new Object[]{fileName}), (String)VcsBundle.message((String)"diff.unknown.file.type.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"diff.unknown.file.type.associate", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            FileType fileType = FileTypeChooser.associateFileType(fileName);
            return fileType != null && !fileType.isBinary();
        }
        context.add(pattern);
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeDiffRequestPresentable that = (ChangeDiffRequestPresentable)o;
        return !(this.myChange != null ? !this.myChange.equals((Object)that.myChange) : that.myChange != null);
    }

    public int hashCode() {
        return this.myChange != null ? this.myChange.hashCode() : 0;
    }
}

