/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementPath {
    public static final PackagingElementPath EMPTY = new PackagingElementPath(null, null);
    private final PackagingElementPath myParentPath;
    private final PackagingElement<?> myLastElement;

    private PackagingElementPath(PackagingElementPath parentPath, PackagingElement<?> lastElement) {
        this.myParentPath = parentPath;
        this.myLastElement = lastElement;
    }

    public PackagingElementPath appendComplex(ComplexPackagingElement<?> element) {
        return new PackagingElementPath(this, (PackagingElement<?>)element);
    }

    public PackagingElementPath appendComposite(CompositePackagingElement<?> element) {
        return new PackagingElementPath(this, (PackagingElement<?>)element);
    }

    @NotNull
    public String getPathString() {
        String string = this.getPathString("/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/PackagingElementPath", "getPathString"));
        }
        return string;
    }

    @NotNull
    public String getPathString(String separator) {
        String string = this.getPathStringFrom(separator, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/PackagingElementPath", "getPathString"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getPathStringFrom(String separator, @Nullable CompositePackagingElement<?> ancestor) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        List<CompositePackagingElement<?>> parents = this.getParentsFrom(ancestor);
        for (int i = parents.size() - 1; i >= 0; --i) {
            builder.append(parents.get(i).getName());
            if (i <= 0) continue;
            builder.append(separator);
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/PackagingElementPath", "getPathStringFrom"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public List<CompositePackagingElement<?>> getParents() {
        return this.getParentsFrom(null);
    }

    public List<CompositePackagingElement<?>> getParentsFrom(@Nullable CompositePackagingElement<?> ancestor) {
        SmartList result = new SmartList();
        PackagingElementPath path = this;
        while (path != EMPTY && path.myLastElement != ancestor) {
            if (path.myLastElement instanceof CompositePackagingElement) {
                result.add((CompositePackagingElement)path.myLastElement);
            }
            path = path.myParentPath;
        }
        return result;
    }

    public List<PackagingElement<?>> getAllElements() {
        SmartList result = new SmartList();
        PackagingElementPath path = this;
        while (path != EMPTY) {
            result.add(path.myLastElement);
            path = path.myParentPath;
        }
        return result;
    }

    @Nullable
    public CompositePackagingElement<?> getLastParent() {
        PackagingElementPath path = this;
        while (path != EMPTY) {
            if (path.myLastElement instanceof CompositePackagingElement) {
                return (CompositePackagingElement)path.myLastElement;
            }
            path = path.myParentPath;
        }
        return null;
    }

    @Nullable
    public Artifact findLastArtifact(PackagingElementResolvingContext context) {
        PackagingElementPath path = this;
        while (path != EMPTY) {
            PackagingElement<?> element = path.myLastElement;
            if (element instanceof ArtifactPackagingElement) {
                return ((ArtifactPackagingElement)element).findArtifact(context);
            }
            path = path.myParentPath;
        }
        return null;
    }

    public static PackagingElementPath createPath(@NotNull List<PackagingElement<?>> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/packaging/impl/artifacts/PackagingElementPath", "createPath"));
        }
        PackagingElementPath path = EMPTY;
        for (PackagingElement<?> element : elements) {
            path = new PackagingElementPath(path, element);
        }
        return path;
    }
}

