/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler;
import org.jetbrains.annotations.NotNull;

public class EncapsulateFieldsAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/actions/EncapsulateFieldsAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/actions/EncapsulateFieldsAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/actions/EncapsulateFieldsAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/actions/EncapsulateFieldsAction", "isAvailableOnElementInEditorAndFile"));
        }
        PsiElement psiElement = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        if (containingClass != null) {
            PsiField[] fields;
            for (PsiField field : fields = containingClass.getFields()) {
                if (!EncapsulateFieldsAction.isAcceptedField((PsiElement)field)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/EncapsulateFieldsAction", "isEnabledOnElements"));
        }
        if (elements.length == 1) {
            return elements[0] instanceof PsiClass && elements[0].getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || EncapsulateFieldsAction.isAcceptedField(elements[0]);
        }
        if (elements.length > 1) {
            for (int idx = 0; idx < elements.length; ++idx) {
                if (EncapsulateFieldsAction.isAcceptedField(elements[idx])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/EncapsulateFieldsAction", "getHandler"));
        }
        return new EncapsulateFieldsHandler();
    }

    private static boolean isAcceptedField(PsiElement element) {
        return element instanceof PsiField && element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && ((PsiField)element).getContainingClass() != null;
    }
}

