/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import gnu.trove.THashMap;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTreeState {
    private final NodeInfo myRootInfo;
    private Rectangle myLastVisibleNodeRect;

    private XDebuggerTreeState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState", "<init>"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebuggerTreeNode root = tree.getRoot();
        NodeInfo nodeInfo = this.myRootInfo = root != null ? new NodeInfo("", "", tree.isPathSelected(root.getPath())) : null;
        if (root != null) {
            this.addChildren(tree, this.myRootInfo, root);
        }
    }

    public XDebuggerTreeRestorer restoreState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState", "restoreState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebuggerTreeRestorer restorer = null;
        if (this.myRootInfo != null) {
            restorer = new XDebuggerTreeRestorer(tree, this.myLastVisibleNodeRect);
            restorer.restore(tree.getRoot(), this.myRootInfo);
        }
        return restorer;
    }

    public static XDebuggerTreeState saveState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState", "saveState"));
        }
        return new XDebuggerTreeState(tree);
    }

    private void addChildren(XDebuggerTree tree, NodeInfo nodeInfo, XDebuggerTreeNode treeNode) {
        List<? extends XDebuggerTreeNode> children2;
        if (tree.isExpanded(treeNode.getPath()) && (children2 = treeNode.getLoadedChildren()) != null) {
            nodeInfo.myExpanded = true;
            for (XDebuggerTreeNode xDebuggerTreeNode : children2) {
                NodeInfo childInfo;
                TreePath path = xDebuggerTreeNode.getPath();
                Rectangle bounds = tree.getPathBounds(path);
                if (bounds != null) {
                    Rectangle treeVisibleRect;
                    Rectangle rectangle = treeVisibleRect = tree.getParent() instanceof JViewport ? ((JViewport)tree.getParent()).getViewRect() : tree.getVisibleRect();
                    if (treeVisibleRect.contains(bounds)) {
                        this.myLastVisibleNodeRect = bounds;
                    }
                }
                if ((childInfo = XDebuggerTreeState.createNode(xDebuggerTreeNode, tree.isPathSelected(path))) == null) continue;
                nodeInfo.addChild(childInfo);
                this.addChildren(tree, childInfo, xDebuggerTreeNode);
            }
        }
    }

    @Nullable
    private static NodeInfo createNode(XDebuggerTreeNode node, boolean selected) {
        RestorableStateNode valueNode;
        if (node instanceof RestorableStateNode && (valueNode = (RestorableStateNode)((Object)node)).isComputed()) {
            return new NodeInfo(valueNode.getName(), valueNode.getRawValue(), selected);
        }
        return null;
    }

    public static class NodeInfo {
        private final String myName;
        private final String myValue;
        private boolean myExpanded;
        private final boolean mySelected;
        private Map<String, NodeInfo> myChildren;

        public NodeInfo(String name, String value, boolean selected) {
            this.myName = name;
            this.myValue = value;
            this.mySelected = selected;
        }

        public void addChild(@NotNull NodeInfo child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState$NodeInfo", "addChild"));
            }
            if (this.myChildren == null) {
                this.myChildren = new THashMap();
            }
            this.myChildren.put(child.myName, child);
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public String getValue() {
            return this.myValue;
        }

        @Nullable
        public NodeInfo removeChild(String name) {
            return this.myChildren != null ? this.myChildren.remove(name) : null;
        }
    }
}

