/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DanglingJavadocInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dangling.javadoc.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dangling.javadoc.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new DeleteCommentFix(), new ConvertCommentFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DanglingJavadocVisitor();
    }

    private static class DanglingJavadocVisitor
    extends BaseInspectionVisitor {
        private DanglingJavadocVisitor() {
        }

        public void visitDocComment(PsiDocComment comment) {
            super.visitDocComment(comment);
            if (comment.getOwner() != null) {
                return;
            }
            if (JavaDocUtil.isInsidePackageInfo(comment) && PsiTreeUtil.skipSiblingsForward((PsiElement)comment, (Class[])new Class[]{PsiWhiteSpace.class}) instanceof PsiPackageStatement && "package-info.java".equals(comment.getContainingFile().getName())) {
                return;
            }
            this.registerError(comment.getFirstChild(), new Object[0]);
        }
    }

    private static class DeleteCommentFix
    extends InspectionGadgetsFix {
        private DeleteCommentFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("dangling.javadoc.delete.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection$DeleteCommentFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection$DeleteCommentFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            element.getParent().delete();
        }
    }

    private static class ConvertCommentFix
    extends InspectionGadgetsFix {
        private ConvertCommentFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("dangling.javadoc.convert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection$ConvertCommentFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/DanglingJavadocInspection$ConvertCommentFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement docComment = element.getParent();
            StringBuilder newCommentText = new StringBuilder();
            for (PsiElement child : docComment.getChildren()) {
                if (child instanceof PsiDocToken) {
                    PsiDocToken docToken = (PsiDocToken)child;
                    IElementType tokenType = docToken.getTokenType();
                    if (JavaDocTokenType.DOC_COMMENT_START.equals(tokenType)) {
                        newCommentText.append("/*");
                        continue;
                    }
                    if (JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS.equals(tokenType)) continue;
                    newCommentText.append(child.getText());
                    continue;
                }
                newCommentText.append(child.getText());
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiComment newComment = factory.createCommentFromText(newCommentText.toString(), element);
            docComment.replace((PsiElement)newComment);
        }
    }
}

