/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TestUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TestMethodWithoutAssertionInspectionBase
extends BaseInspection {
    protected final MethodMatcher methodMatcher = new MethodMatcher(true, "assertionMethods").add("org.junit.Assert", "assert.*|fail.*").add("junit.framework.Assert", "assert.*|fail.*").add("org.mockito.Mockito", "verify.*").add("org.mockito.InOrder", "verify").add("org.junit.rules.ExpectedException", "expect.*").add("org.hamcrest.MatcherAssert", "assertThat").finishDefault();
    public boolean assertKeywordIsAssertion;

    @NotNull
    public String getID() {
        if ("JUnitTestMethodWithNoAssertions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "getID"));
        }
        return "JUnitTestMethodWithNoAssertions";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        this.methodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "writeSettings"));
        }
        this.methodMatcher.writeSettings(element);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodWithoutAssertionVisitor();
    }

    private class ContainsAssertionVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsAssertion;

        private ContainsAssertionVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$ContainsAssertionVisitor", "visitElement"));
            }
            if (!this.containsAssertion) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$ContainsAssertionVisitor", "visitMethodCallExpression"));
            }
            if (this.containsAssertion) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (TestMethodWithoutAssertionInspectionBase.this.methodMatcher.matches(call)) {
                this.containsAssertion = true;
            }
        }

        public void visitAssertStatement(PsiAssertStatement statement2) {
            if (this.containsAssertion) {
                return;
            }
            super.visitAssertStatement(statement2);
            if (!TestMethodWithoutAssertionInspectionBase.this.assertKeywordIsAssertion) {
                return;
            }
            this.containsAssertion = true;
        }

        boolean containsAssertion() {
            return this.containsAssertion;
        }
    }

    private class TestMethodWithoutAssertionVisitor
    extends BaseInspectionVisitor {
        private TestMethodWithoutAssertionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$TestMethodWithoutAssertionVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            if (this.hasExpectedExceptionAnnotation(method)) {
                return;
            }
            if (this.containsAssertion((PsiElement)method)) {
                return;
            }
            if (this.lastStatementIsCallToMethodWithAssertion(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean lastStatementIsCallToMethodWithAssertion(PsiMethod method) {
            PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
            if (!(lastStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)lastStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression)) {
                return false;
            }
            PsiMethod targetMethod = methodCallExpression.resolveMethod();
            return this.containsAssertion((PsiElement)targetMethod);
        }

        private boolean containsAssertion(PsiElement element) {
            if (element == null) {
                return false;
            }
            ContainsAssertionVisitor visitor = new ContainsAssertionVisitor();
            element.accept((PsiElementVisitor)visitor);
            return visitor.containsAssertion();
        }

        private boolean hasExpectedExceptionAnnotation(PsiMethod method) {
            PsiNameValuePair[] nameValuePairs;
            PsiModifierList modifierList = method.getModifierList();
            PsiAnnotation testAnnotation = modifierList.findAnnotation("org.junit.Test");
            if (testAnnotation == null) {
                return false;
            }
            PsiAnnotationParameterList parameterList = testAnnotation.getParameterList();
            for (PsiNameValuePair nameValuePair : nameValuePairs = parameterList.getAttributes()) {
                String parameterName = nameValuePair.getName();
                if (!"expected".equals(parameterName)) continue;
                return true;
            }
            return false;
        }
    }
}

