/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.MemoryRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;

public interface PathListener {
    public void notifyPath(PathEvent var1);

    public static class PathEvent {
        public final Path path;
        public final Object source;

        public PathEvent(Path path, Object source) {
            this.path = path;
            this.source = source;
        }

        public <T extends Path> T findPathOfType(Class<T> cls) {
            for (Path p = this.path; p != null; p = p.getParent()) {
                if (!cls.isInstance(p)) continue;
                return (T)((Path)cls.cast(p));
            }
            return null;
        }

        public DevicePath findDevicePath() {
            return this.findPathOfType(DevicePath.class);
        }

        public CapturePath findCapturePath() {
            return this.findPathOfType(CapturePath.class);
        }

        public AtomPath findAtomPath() {
            return this.findPathOfType(AtomPath.class);
        }

        public MemoryRangePath findMemoryPath() {
            return this.findPathOfType(MemoryRangePath.class);
        }
    }
}

