/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceStateAtLaunch;
import com.android.tools.idea.run.DeviceStateAtLaunchService;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.EmulatorTargetChooser;
import com.android.tools.idea.run.ExtendedDeviceChooserDialog;
import com.android.tools.idea.run.editor.ShowChooserTarget;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualTargetChooser {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ManualTargetChooser.class);
    @NotNull
    private final ShowChooserTarget.State myShowChooserState;
    @NotNull
    private final AndroidFacet myFacet;
    private final int myRunConfigId;
    @NotNull
    private final Project myProject;

    public ManualTargetChooser(@NotNull ShowChooserTarget.State state, @NotNull AndroidFacet facet, int runConfigId) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/ManualTargetChooser", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/ManualTargetChooser", "<init>"));
        }
        this.myShowChooserState = state;
        this.myFacet = facet;
        this.myRunConfigId = runConfigId;
        this.myProject = facet.getModule().getProject();
    }

    @Nullable
    public DeviceTarget getTarget(@NotNull ConsolePrinter printer, @NotNull DeviceCount deviceCount, boolean debug) {
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/ManualTargetChooser", "getTarget"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/ManualTargetChooser", "getTarget"));
        }
        Collection<IDevice> devices = this.getReusableDevices(deviceCount);
        if (!devices.isEmpty()) {
            return DeviceTarget.forDevices(devices);
        }
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + this.myFacet.getModule().getName());
            return null;
        }
        ExtendedDeviceChooserDialog chooser = new ExtendedDeviceChooserDialog(this.myFacet, platform.getTarget(), deviceCount.isMultiple(), true, this.myShowChooserState.USE_LAST_SELECTED_DEVICE);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return null;
        }
        if (chooser.isToLaunchEmulator()) {
            String selectedAvd = chooser.getSelectedAvd();
            if (selectedAvd == null) {
                return null;
            }
            EmulatorTargetChooser emulatorChooser = new EmulatorTargetChooser(this.myFacet, selectedAvd);
            return emulatorChooser.getTarget(printer, deviceCount, debug);
        }
        Object[] selectedDevices = chooser.getSelectedDevices();
        if (selectedDevices.length == 0) {
            return null;
        }
        DeviceStateAtLaunchService.getInstance(this.myProject).setDevicesUsedInLaunch(this.myRunConfigId, Sets.newHashSet((Object[])selectedDevices), this.getOnlineDevices());
        this.myShowChooserState.USE_LAST_SELECTED_DEVICE = chooser.useSameDevicesAgain();
        return DeviceTarget.forDevices(Arrays.asList(selectedDevices));
    }

    @NotNull
    private Collection<IDevice> getReusableDevices(@NotNull DeviceCount deviceCount) {
        Collection<IDevice> usedDevices;
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/ManualTargetChooser", "getReusableDevices"));
        }
        DeviceStateAtLaunch devicesToReuse = DeviceStateAtLaunchService.getInstance(this.myProject).getDevicesUsedInLastLaunch(this.myRunConfigId);
        if (!this.myShowChooserState.USE_LAST_SELECTED_DEVICE || devicesToReuse == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ManualTargetChooser", "getReusableDevices"));
            }
            return immutableList;
        }
        Set<IDevice> onlineDevices = this.getOnlineDevices();
        if (devicesToReuse.matchesCurrentAvailableDevices(onlineDevices) && ((usedDevices = devicesToReuse.filterByUsed(onlineDevices)).size() == 1 || deviceCount.isMultiple())) {
            Collection<IDevice> collection = usedDevices;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ManualTargetChooser", "getReusableDevices"));
            }
            return collection;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ManualTargetChooser", "getReusableDevices"));
        }
        return immutableList;
    }

    private Set<IDevice> getOnlineDevices() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
        if (debugBridge == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])debugBridge.getDevices());
    }
}

