/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChameleonSyntaxHighlightingPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;

    public ChameleonSyntaxHighlightingPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        super(project2, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range.getStartOffset();
        this.myEndOffset = range.getEndOffset();
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "doCollectInformation"));
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorColorsScheme scheme = this.myEditor.getColorsScheme();
        TextAttributes defaultAttrs = scheme.getAttributes(HighlighterColors.TEXT);
        SyntaxTraverser s = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).expand(Conditions.compose((Function)SyntaxTraverser.psiApi().TO_RANGE(), (Condition)new Condition<TextRange>(){

            public boolean value(TextRange range) {
                return range.intersects(ChameleonSyntaxHighlightingPass.this.myStartOffset, ChameleonSyntaxHighlightingPass.this.myEndOffset);
            }
        }))).filterTypes(Conditions.instanceOf(ILazyParseableElementType.class)).filterTypes(Conditions.notInstanceOf(IFileElementType.class));
        ArrayList infos = ContainerUtil.newArrayList();
        for (PsiElement e : s) {
            Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)e.getNode());
            if (language == null) continue;
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, (VirtualFile)this.myFile.getVirtualFile());
            for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)e).traverse(TreeTraversal.LEAVES_DFS)) {
                TextAttributes forcedAttributes;
                TextRange tr = token.getTextRange();
                if (tr.isEmpty()) continue;
                IElementType type = PsiUtilCore.getElementType((PsiElement)token);
                TextAttributesKey[] keys = syntaxHighlighter.getTokenHighlights(type);
                TextAttributes attributes = null;
                for (TextAttributesKey key : keys) {
                    TextAttributes attrs2 = scheme.getAttributes(key);
                    if (attrs2 == null) continue;
                    attributes = attributes == null ? attrs2 : TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2);
                }
                if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                    forcedAttributes = TextAttributes.ERASE_MARKER;
                } else {
                    infos.add(HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally());
                    forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
                }
                infos.add(HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(forcedAttributes).createUnconditionally());
            }
        }
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, infos, this.getColorsScheme(), this.getId());
    }

    public static class Factory
    extends AbstractProjectComponent
    implements TextEditorHighlightingPassFactory {
        protected Factory(Project project2, TextEditorHighlightingPassRegistrar registrar) {
            super(project2);
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.FIRST, -1, false, false);
        }

        @Override
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createHighlightingPass"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createHighlightingPass"));
            }
            return new ChameleonSyntaxHighlightingPass(this.myProject, file2, editor);
        }
    }
}

