/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTypeCastExpression;
import java.util.ArrayList;
import java.util.List;

public class TypeCastSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiTypeCastExpression;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.addAll(TypeCastSelectioner.expandToWholeLine(editorText, e.getTextRange(), false));
        PsiTypeCastExpression expression = (PsiTypeCastExpression)e;
        PsiElement[] children2 = expression.getChildren();
        PsiJavaToken lParen = null;
        PsiJavaToken rParen = null;
        for (PsiElement child : children2) {
            if (!(child instanceof PsiJavaToken)) continue;
            PsiJavaToken token = (PsiJavaToken)child;
            if (token.getTokenType() == JavaTokenType.LPARENTH) {
                lParen = token;
            }
            if (token.getTokenType() != JavaTokenType.RPARENTH) continue;
            rParen = token;
        }
        if (lParen != null && rParen != null) {
            result.addAll(TypeCastSelectioner.expandToWholeLine(editorText, new TextRange(lParen.getTextRange().getStartOffset(), rParen.getTextRange().getEndOffset()), false));
        }
        return result;
    }
}

