/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.tokens;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateToken
extends ZenCodingToken {
    public static final String ATTRS = "ATTRS";
    public static final TemplateToken EMPTY_TEMPLATE_TOKEN = new TemplateToken("", Collections.emptyMap());
    @NotNull
    private final String myKey;
    private TemplateImpl myTemplate;
    @NotNull
    private final Map<String, String> myAttributes;
    private XmlFile myFile;

    public TemplateToken(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "<init>"));
        }
        this(key, Collections.emptyMap());
    }

    public TemplateToken(@NotNull String key, @NotNull Map<String, String> attribute2value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "<init>"));
        }
        if (attribute2value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute2value", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "<init>"));
        }
        this.myKey = key;
        this.myAttributes = attribute2value;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Map<String, String> map = this.myAttributes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "getAttributes"));
        }
        return map;
    }

    public XmlFile getFile() {
        return this.myFile;
    }

    public void setFile(XmlFile file2) {
        this.myFile = file2;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "getKey"));
        }
        return string;
    }

    public boolean setTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "setTemplate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "setTemplate"));
        }
        this.myTemplate = template;
        XmlFile xmlFile = TemplateToken.parseXmlFileInTemplate(template, callback, this.getAttributes());
        this.setFile(xmlFile);
        XmlTag tag = xmlFile.getRootTag();
        return this.getAttributes().isEmpty() || tag != null;
    }

    private static boolean containsAttrsVar(@NotNull TemplateImpl template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "containsAttrsVar"));
        }
        for (int i = 0; i < template.getVariableCount(); ++i) {
            String varName = template.getVariableNameAt(i);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static XmlFile parseXmlFileInTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback, @NotNull Map<String, String> attributes) {
        XmlFile xmlFile;
        VirtualFile vFile;
        XmlFile dummyFile;
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "parseXmlFileInTemplate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "parseXmlFileInTemplate"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "parseXmlFileInTemplate"));
        }
        XmlTag dummyRootTag = null;
        String templateString = template.getString();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)callback.getProject());
        if (!TemplateToken.containsAttrsVar(template) && (dummyRootTag = (dummyFile = (XmlFile)psiFileFactory.createFileFromText("dummy.html", (Language)HTMLLanguage.INSTANCE, (CharSequence)templateString, false, true)).getRootTag()) != null) {
            TemplateToken.addMissingAttributes(dummyRootTag, attributes);
        }
        if ((vFile = (xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)(templateString = dummyRootTag != null ? dummyRootTag.getContainingFile().getText() : templateString), LocalTimeCounter.currentTime(), true)).getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "parseXmlFileInTemplate"));
        }
        return xmlFile2;
    }

    private static void addMissingAttributes(@NotNull XmlTag tag, @NotNull Map<String, String> attributes) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "addMissingAttributes"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "addMissingAttributes"));
        }
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            XmlTag htmlTag;
            XmlAttribute newAttribute;
            if ("%default".equals(attribute.getKey()) || tag.getAttribute(attribute.getKey()) != null || (newAttribute = (XmlAttribute)ArrayUtil.getFirstElement((Object[])(htmlTag = XmlElementFactory.getInstance((Project)tag.getProject()).createHTMLTagFromText("<dummy " + attribute.getKey() + "=\"\"/>")).getAttributes())) == null) continue;
            tag.add((PsiElement)newAttribute);
        }
    }

    @Nullable
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public String toString() {
        if ("TEMPLATE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "toString"));
        }
        return "TEMPLATE";
    }
}

