/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.StandardInstructionVisitor");
    private static final Object ANY_VALUE = new Object();
    private final Set<BinopInstruction> myReachable = new THashSet();
    private final Set<BinopInstruction> myCanBeNullInInstanceof = new THashSet();
    private final MultiMap<PushInstruction, Object> myPossibleVariableValues = MultiMap.createSet();
    private final Set<PsiElement> myNotToReportReachability = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();
    private final FactoryMap<MethodCallInstruction, Nullness> myReturnTypeNullability = new FactoryMap<MethodCallInstruction, Nullness>(){

        protected Nullness create(MethodCallInstruction key) {
            PsiCallExpression callExpression = key.getCallExpression();
            if (callExpression instanceof PsiNewExpression) {
                return Nullness.NOT_NULL;
            }
            return callExpression != null ? DfaPsiUtil.getElementNullability(key.getResultType(), (PsiModifierListOwner)callExpression.resolveMethod()) : null;
        }
    };

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (dfaDest instanceof DfaVariableValue) {
            boolean forceDeclaredNullity;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            boolean bl = forceDeclaredNullity = !(psi instanceof PsiParameter) || !(psi.getParent() instanceof PsiParameterList);
            if (forceDeclaredNullity && var.getInherentNullability() == Nullness.NOT_NULL) {
                this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, (PsiElement)instruction.getRExpression());
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullness.NULLABLE && !memState.isNotNull(dfaSource) && instruction.isVariableInitializer()) {
                DfaMemoryStateImpl stateImpl = (DfaMemoryStateImpl)memState;
                stateImpl.setVariableState(var, stateImpl.getVariableState(var).withNullability(Nullness.NULLABLE));
            }
        } else if (dfaDest instanceof DfaTypeValue && ((DfaTypeValue)dfaDest).isNotNull()) {
            this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, (PsiElement)instruction.getRExpression());
        }
        memState.push(dfaDest);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue retValue = memState.pop();
        this.checkNotNullable(memState, retValue, NullabilityProblem.nullableReturn, instruction.getReturn());
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitFieldReference(FieldReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue qualifier = memState.pop();
        if (!this.checkNotNullable(memState, qualifier, NullabilityProblem.fieldAccessNPE, (PsiElement)instruction.getElementToAssert())) {
            StandardInstructionVisitor.forceNotNull(runner, memState, qualifier);
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue;
        if (!instruction.isReferenceWrite() && instruction.getPlace() instanceof PsiReferenceExpression && (dfaValue = instruction.getValue()) instanceof DfaVariableValue) {
            DfaConstValue constValue = memState.getConstantValue((DfaVariableValue)dfaValue);
            this.myPossibleVariableValues.putValue((Object)instruction, constValue != null && (constValue.getValue() == null || constValue.getValue() instanceof Boolean) ? constValue : ANY_VALUE);
        }
        return super.visitPush(instruction, runner, memState);
    }

    public List<Pair<PsiReferenceExpression, DfaConstValue>> getConstantReferenceValues() {
        ArrayList result = ContainerUtil.newArrayList();
        for (PushInstruction instruction : this.myPossibleVariableValues.keySet()) {
            Object singleValue;
            Collection values = this.myPossibleVariableValues.get((Object)instruction);
            if (values.size() != 1 || (singleValue = values.iterator().next()) == ANY_VALUE) continue;
            result.add(Pair.create((Object)((PsiReferenceExpression)instruction.getPlace()), (Object)((DfaConstValue)singleValue)));
        }
        return result;
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaValue dfaExpr = factory.createValue(instruction.getCasted());
        if (dfaExpr != null) {
            DfaTypeValue dfaType = (DfaTypeValue)factory.createTypeValue(instruction.getCastTo(), Nullness.UNKNOWN);
            DfaRelationValue dfaInstanceof = factory.getRelationFactory().createRelation(dfaExpr, dfaType, JavaTokenType.INSTANCEOF_KEYWORD, false);
            if (dfaInstanceof != null && !memState.applyInstanceofOrNull(dfaInstanceof)) {
                this.onInstructionProducesCCE(instruction);
            }
        }
        if (instruction.getCastTo() instanceof PsiPrimitiveType) {
            memState.push(runner.getFactory().getBoxedFactory().createUnboxed(memState.pop()));
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue[] argValues = this.popCallArguments(instruction, runner, memState);
        DfaValue qualifier = this.popQualifier(instruction, runner, memState);
        LinkedHashSet currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{memState});
        LinkedHashSet finalStates = ContainerUtil.newLinkedHashSet();
        if (argValues != null) {
            for (MethodContract contract : instruction.getContracts()) {
                currentStates = this.addContractResults(argValues, contract, currentStates, instruction, runner.getFactory(), finalStates);
                if (currentStates.size() + finalStates.size() <= 300) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                }
                finalStates.clear();
                currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{memState});
                break;
            }
        }
        for (DfaMemoryState state : currentStates) {
            state.push(this.getMethodResultValue(instruction, qualifier, runner.getFactory()));
            finalStates.add(state);
        }
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i = 0;
        for (DfaMemoryState state : finalStates) {
            if (instruction.shouldFlushFields()) {
                state.flushFields();
            }
            result[i++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result;
    }

    @Nullable
    private DfaValue[] popCallArguments(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue[] argValues;
        PsiExpression[] args = instruction.getArgs();
        PsiMethod method = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        if (method == null || instruction.getContracts().isEmpty()) {
            argValues = null;
        } else {
            PsiParameterList paramList = method.getParameterList();
            int paramCount = paramList.getParametersCount();
            if (paramCount == args.length || method.isVarArgs() && args.length >= paramCount - 1) {
                argValues = new DfaValue[paramCount];
                if (varargCall) {
                    argValues[paramCount - 1] = runner.getFactory().createTypeValue(paramList.getParameters()[paramCount - 1].getType(), Nullness.NOT_NULL);
                }
            } else {
                argValues = null;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            PsiExpression expr;
            Nullness requiredNullability;
            DfaValue arg = memState.pop();
            int paramIndex = args.length - i - 1;
            if (!(argValues == null || paramIndex >= argValues.length - 1 && varargCall)) {
                argValues[paramIndex] = arg;
            }
            if ((requiredNullability = instruction.getArgRequiredNullability(expr = args[paramIndex])) == Nullness.NOT_NULL) {
                if (this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableToNotNullParameter, (PsiElement)expr)) continue;
                StandardInstructionVisitor.forceNotNull(runner, memState, arg);
                continue;
            }
            if (instruction.updateOfNullable(memState, arg) || requiredNullability != Nullness.UNKNOWN) continue;
            this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter, (PsiElement)expr);
        }
        return argValues;
    }

    private DfaValue popQualifier(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression anchor;
        DfaValue qualifier = memState.pop();
        boolean unboxing = instruction.getMethodType() == MethodCallInstruction.MethodType.UNBOXING;
        NullabilityProblem problem = unboxing ? NullabilityProblem.unboxingNullable : NullabilityProblem.callNPE;
        Object object = anchor = unboxing ? instruction.getContext() : instruction.getCallExpression();
        if (!this.checkNotNullable(memState, qualifier, problem, (PsiElement)anchor)) {
            StandardInstructionVisitor.forceNotNull(runner, memState, qualifier);
        }
        return qualifier;
    }

    private LinkedHashSet<DfaMemoryState> addContractResults(DfaValue[] argValues, MethodContract contract, LinkedHashSet<DfaMemoryState> states, MethodCallInstruction instruction, DfaValueFactory factory, Set<DfaMemoryState> finalStates) {
        DfaConstValue.Factory constFactory = factory.getConstFactory();
        LinkedHashSet falseStates = ContainerUtil.newLinkedHashSet();
        for (int i = 0; i < argValues.length; ++i) {
            DfaValue argValue = argValues[i];
            MethodContract.ValueConstraint constraint = contract.arguments[i];
            DfaConstValue expectedValue = constraint.getComparisonValue(factory);
            if (expectedValue == null) continue;
            boolean nullContract = expectedValue == constFactory.getNull();
            boolean invertCondition = constraint.shouldUseNonEqComparison();
            DfaValue condition = factory.getRelationFactory().createRelation(argValue, expectedValue, JavaTokenType.EQEQ, invertCondition);
            if (condition == null) {
                if (!(argValue instanceof DfaConstValue)) {
                    for (DfaMemoryState state : states) {
                        DfaMemoryState falseCopy = state.createCopy();
                        if (nullContract) {
                            (invertCondition ? falseCopy : state).markEphemeral();
                        }
                        falseStates.add(falseCopy);
                    }
                    continue;
                }
                condition = constFactory.createFromValue(argValue == expectedValue != invertCondition, (PsiType)PsiType.BOOLEAN, null);
            }
            LinkedHashSet nextStates = ContainerUtil.newLinkedHashSet();
            for (DfaMemoryState state : states) {
                boolean unknownVsNull = nullContract && argValue instanceof DfaVariableValue && ((DfaMemoryStateImpl)state).getVariableState((DfaVariableValue)argValue).getNullability() == Nullness.UNKNOWN;
                DfaMemoryState falseCopy = state.createCopy();
                if (state.applyCondition(condition)) {
                    if (unknownVsNull && !invertCondition) {
                        state.markEphemeral();
                    }
                    nextStates.add(state);
                }
                if (!falseCopy.applyCondition(condition.createNegated())) continue;
                if (unknownVsNull && invertCondition) {
                    falseCopy.markEphemeral();
                }
                falseStates.add(falseCopy);
            }
            states = nextStates;
        }
        for (DfaMemoryState state : states) {
            state.push(this.getDfaContractReturnValue(contract, instruction, factory));
            finalStates.add(state);
        }
        return falseStates;
    }

    private DfaValue getDfaContractReturnValue(MethodContract contract, MethodCallInstruction instruction, DfaValueFactory factory) {
        switch (contract.returnValue) {
            case NULL_VALUE: {
                return factory.getConstFactory().getNull();
            }
            case NOT_NULL_VALUE: {
                return factory.createTypeValue(instruction.getResultType(), Nullness.NOT_NULL);
            }
            case TRUE_VALUE: {
                return factory.getConstFactory().getTrue();
            }
            case FALSE_VALUE: {
                return factory.getConstFactory().getFalse();
            }
            case THROW_EXCEPTION: {
                return factory.getConstFactory().getContractFail();
            }
        }
        return this.getMethodResultValue(instruction, null, factory);
    }

    private static void forceNotNull(DataFlowRunner runner, DfaMemoryState memState, DfaValue arg) {
        if (arg instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)arg;
            memState.setVarValue(var, runner.getFactory().createTypeValue(var.getVariableType(), Nullness.NOT_NULL));
        }
    }

    @NotNull
    private DfaValue getMethodResultValue(MethodCallInstruction instruction, @Nullable DfaValue qualifierValue, DfaValueFactory factory) {
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            DfaValue dfaValue = precalculated;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        PsiType type = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            DfaValue dfaValue = factory.getBoxedFactory().createUnboxed(qualifierValue);
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.BOXING) {
            DfaValue boxed = factory.getBoxedFactory().createBoxed(qualifierValue);
            DfaValue dfaValue = boxed == null ? factory.createTypeValue(type, Nullness.NOT_NULL) : boxed;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.CAST) {
            assert (qualifierValue != null);
            if (qualifierValue instanceof DfaConstValue) {
                Object casted = TypeConversionUtil.computeCastTo((Object)((DfaConstValue)qualifierValue).getValue(), (PsiType)type);
                DfaConstValue dfaConstValue = factory.getConstFactory().createFromValue(casted, type, ((DfaConstValue)qualifierValue).getConstant());
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
                }
                return dfaConstValue;
            }
            DfaValue dfaValue = qualifierValue;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (type != null && (type instanceof PsiClassType || type.getArrayDimensions() > 0)) {
            Nullness nullability = (Nullness)((Object)this.myReturnTypeNullability.get((Object)instruction));
            if (nullability == Nullness.UNKNOWN && factory.isUnknownMembersAreNullable()) {
                nullability = Nullness.NULLABLE;
            }
            DfaValue dfaValue = factory.createTypeValue(type, nullability);
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
        }
        return dfaUnknownValue;
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value, NullabilityProblem problem, PsiElement anchor) {
        boolean notNullable = state.checkNotNullable(value);
        if (notNullable && problem != NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.getRelationFactory().createRelation(value, factory.getConstFactory().getNull(), JavaTokenType.NE, false));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        if (opSign != null) {
            DfaInstructionState[] states = StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaRight, dfaLeft, opSign);
            if (states == null) {
                states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft);
            }
            if (states != null) {
                return states;
            }
            if (JavaTokenType.PLUS == opSign) {
                memState.push(instruction.getNonNullStringValue(runner.getFactory()));
            } else {
                if (instruction instanceof InstanceofInstruction) {
                    this.handleInstanceof((InstanceofInstruction)instruction, dfaRight, dfaLeft);
                }
                memState.push(DfaUnknownValue.getInstance());
            }
        } else {
            memState.push(DfaUnknownValue.getInstance());
        }
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft) {
        DfaMemoryState falseCopy;
        DfaValueFactory factory = runner.getFactory();
        Instruction next = runner.getInstruction(instruction.getIndex() + 1);
        DfaRelationValue dfaRelation = factory.getRelationFactory().createRelation(dfaLeft, dfaRight, instruction.getOperationSign(), false);
        if (dfaRelation == null) {
            return null;
        }
        this.myCanBeNullInInstanceof.add(instruction);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>();
        DfaMemoryState trueCopy = memState.createCopy();
        if (trueCopy.applyCondition(dfaRelation)) {
            trueCopy.push(factory.getConstFactory().getTrue());
            instruction.setTrueReachable();
            states.add(new DfaInstructionState(next, trueCopy));
        }
        if ((falseCopy = memState).applyCondition(dfaRelation.createNegated())) {
            falseCopy.push(factory.getConstFactory().getFalse());
            instruction.setFalseReachable();
            states.add(new DfaInstructionState(next, falseCopy));
            if (instruction instanceof InstanceofInstruction && !falseCopy.isNull(dfaLeft)) {
                this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
            }
        }
        return states.toArray(new DfaInstructionState[states.size()]);
    }

    public void skipConstantConditionReporting(@Nullable PsiElement anchor) {
        ContainerUtil.addIfNotNull(this.myNotToReportReachability, (Object)anchor);
    }

    private void handleInstanceof(InstanceofInstruction instruction, DfaValue dfaRight, DfaValue dfaLeft) {
        if (dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaTypeValue) {
            if (!((DfaTypeValue)dfaLeft).isNotNull()) {
                this.myCanBeNullInInstanceof.add(instruction);
            }
            if (((DfaTypeValue)dfaRight).getDfaType().isAssignableFrom(((DfaTypeValue)dfaLeft).getDfaType())) {
                return;
            }
        }
        this.myUsefulInstanceofs.add(instruction);
    }

    @Nullable
    private static DfaInstructionState[] handleConstantComparison(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, IElementType opSign) {
        DfaInstructionState[] result;
        Object value;
        if (dfaRight instanceof DfaConstValue && dfaLeft instanceof DfaVariableValue && (value = ((DfaConstValue)dfaRight).getValue()) instanceof Number && (result = StandardInstructionVisitor.checkComparingWithConstant(instruction, runner, memState, (DfaVariableValue)dfaLeft, opSign, ((Number)value).doubleValue())) != null) {
            return result;
        }
        if (dfaRight instanceof DfaVariableValue && dfaLeft instanceof DfaConstValue) {
            return StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaLeft, dfaRight, DfaRelationValue.getSymmetricOperation(opSign));
        }
        if (JavaTokenType.EQEQ != opSign && JavaTokenType.NE != opSign) {
            return null;
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue || dfaLeft == runner.getFactory().getConstFactory().getContractFail() || dfaRight == runner.getFactory().getConstFactory().getContractFail()) {
            boolean negated;
            if (dfaLeft == dfaRight ^ (negated = JavaTokenType.NE == opSign ^ (DfaMemoryStateImpl.isNaN(dfaLeft) || DfaMemoryStateImpl.isNaN(dfaRight)))) {
                return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
            }
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        return null;
    }

    @Nullable
    private static DfaInstructionState[] checkComparingWithConstant(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaVariableValue var, IElementType opSign, double comparedWith) {
        double minValue;
        Object knownValue;
        DfaConstValue knownConstantValue = memState.getConstantValue(var);
        Object object = knownValue = knownConstantValue == null ? null : knownConstantValue.getValue();
        if (knownValue instanceof Number) {
            double knownDouble = ((Number)knownValue).doubleValue();
            return StandardInstructionVisitor.checkComparisonWithKnownRange(instruction, runner, memState, opSign, comparedWith, knownDouble, knownDouble);
        }
        PsiType varType = var.getVariableType();
        if (!(varType instanceof PsiPrimitiveType)) {
            return null;
        }
        if (PsiType.FLOAT.equals((Object)varType) || PsiType.DOUBLE.equals((Object)varType)) {
            return null;
        }
        double d = PsiType.BYTE.equals((Object)varType) ? -128.0 : (PsiType.SHORT.equals((Object)varType) ? -32768.0 : (PsiType.INT.equals((Object)varType) ? -2.147483648E9 : (minValue = PsiType.CHAR.equals((Object)varType) ? 0.0 : -9.223372036854776E18)));
        double maxValue = PsiType.BYTE.equals((Object)varType) ? 127.0 : (PsiType.SHORT.equals((Object)varType) ? 32767.0 : (PsiType.INT.equals((Object)varType) ? 2.147483647E9 : (PsiType.CHAR.equals((Object)varType) ? 65535.0 : 9.223372036854776E18)));
        return StandardInstructionVisitor.checkComparisonWithKnownRange(instruction, runner, memState, opSign, comparedWith, minValue, maxValue);
    }

    @Nullable
    private static DfaInstructionState[] checkComparisonWithKnownRange(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, IElementType opSign, double comparedWith, double rangeMin, double rangeMax) {
        if (comparedWith < rangeMin || comparedWith > rangeMax) {
            if (opSign == JavaTokenType.EQEQ) {
                return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
            }
            if (opSign == JavaTokenType.NE) {
                return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
            }
        }
        if (opSign == JavaTokenType.LT && comparedWith <= rangeMin) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.LT && comparedWith > rangeMax) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.LE && comparedWith >= rangeMax) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.LE && comparedWith < rangeMin) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GT && comparedWith >= rangeMax) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GT && comparedWith < rangeMin) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GE && comparedWith <= rangeMin) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GE && comparedWith > rangeMax) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        return null;
    }

    private static DfaInstructionState[] alwaysFalse(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getFalse());
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private static DfaInstructionState[] alwaysTrue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getTrue());
        instruction.setTrueReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(BinopInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    public boolean silenceConstantCondition(@Nullable PsiElement element) {
        for (PsiElement skipped : this.myNotToReportReachability) {
            if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)skipped, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

