/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.context;

import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContextStringUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ContextRelevantVariableGetter;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.MethodIncompleteSignatureResolver;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.TargetType;
import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCompletionContext {
    private final TargetType myTarget;
    private final Set<String> myContainingClassQNames;
    private final MultiMap<String, PsiVariable> myContextVars;
    private final MultiMap<String, PsiMethod> myContainingClassGetters;
    private final MultiMap<String, ContextRelevantVariableGetter> myContextVarsGetters;
    private final Map<String, PsiVariable> myStringVars;
    private final Set<String> myExcludedQNames;
    private final GlobalSearchScope myResolveScope;
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final MethodIncompleteSignatureResolver myNotDeprecatedMethodsResolver;
    private final NotNullLazyValue<Set<String>> contextTypesQNames = new NotNullLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            HashSet hashSet = ChainCompletionContext.unionToHashSet(new Collection[]{ChainCompletionContext.this.myContainingClassQNames, ChainCompletionContext.this.myContextVars.keySet(), ChainCompletionContext.this.myContainingClassGetters.keySet(), ChainCompletionContext.this.myContextVarsGetters.keySet()});
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ChainCompletionContext$1", "compute"));
            }
            return hashSet;
        }
    };

    public Set<String> getExcludedQNames() {
        return this.myExcludedQNames;
    }

    ChainCompletionContext(TargetType target, Set<String> containingClassQNames, MultiMap<String, PsiVariable> contextVars, MultiMap<String, PsiMethod> containingClassGetters, MultiMap<String, ContextRelevantVariableGetter> contextVarsGetters, Map<String, PsiVariable> stringVars, Set<String> excludedQNames, Project project2, GlobalSearchScope resolveScope) {
        this.myTarget = target;
        this.myContainingClassQNames = containingClassQNames;
        this.myContextVars = contextVars;
        this.myContainingClassGetters = containingClassGetters;
        this.myContextVarsGetters = contextVarsGetters;
        this.myStringVars = stringVars;
        this.myExcludedQNames = excludedQNames;
        this.myResolveScope = resolveScope;
        this.myProject = project2;
        this.myPsiManager = PsiManager.getInstance((Project)project2);
        this.myNotDeprecatedMethodsResolver = new MethodIncompleteSignatureResolver(JavaPsiFacade.getInstance((Project)project2), resolveScope);
    }

    public TargetType getTarget() {
        return this.myTarget;
    }

    @Nullable
    public PsiVariable findRelevantStringInContext(@Nullable String stringParamName) {
        if (stringParamName == null) {
            return null;
        }
        for (Map.Entry<String, PsiVariable> e : this.myStringVars.entrySet()) {
            if (!ChainCompletionContextStringUtil.isSimilar(e.getKey(), stringParamName)) continue;
            return e.getValue();
        }
        return null;
    }

    public Set<String> getContainingClassQNames() {
        return this.myContainingClassQNames;
    }

    public Collection<PsiVariable> getVariables(String typeQName) {
        return this.myContextVars.get((Object)typeQName);
    }

    public Collection<PsiMethod> getContainingClassMethods(String typeQName) {
        return this.myContainingClassGetters.get((Object)typeQName);
    }

    public Collection<ContextRelevantVariableGetter> getRelevantVariablesGetters(String typeQName) {
        return this.myContextVarsGetters.get((Object)typeQName);
    }

    public Collection<?> getContextRefElements(String typeQName) {
        Collection<PsiVariable> variables = this.getVariables(typeQName);
        Collection<PsiMethod> containingClassMethods = this.getContainingClassMethods(typeQName);
        ArrayList<Object> refElements = new ArrayList<Object>(variables.size() + containingClassMethods.size());
        refElements.addAll(variables);
        refElements.addAll(containingClassMethods);
        for (ContextRelevantVariableGetter contextRelevantVariableGetter : this.getRelevantVariablesGetters(typeQName)) {
            refElements.add(contextRelevantVariableGetter.createLookupElement());
        }
        return refElements;
    }

    public boolean contains(@Nullable String typeQualifierName) {
        return typeQualifierName != null && ((Set)this.contextTypesQNames.getValue()).contains(typeQualifierName);
    }

    public Set<String> getContextTypes() {
        return (Set)this.contextTypesQNames.getValue();
    }

    public GlobalSearchScope getResolveScope() {
        return this.myResolveScope;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @NotNull
    public PsiMethod[] resolveNotDeprecated(MethodIncompleteSignature methodIncompleteSignature) {
        PsiMethod[] psiMethodArray = this.myNotDeprecatedMethodsResolver.get(methodIncompleteSignature);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ChainCompletionContext", "resolveNotDeprecated"));
        }
        return psiMethodArray;
    }

    private static <T> HashSet<T> unionToHashSet(Collection<T> ... collections) {
        HashSet<T> res = new HashSet<T>();
        for (Collection<T> set : collections) {
            res.addAll(set);
        }
        return res;
    }
}

