/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DirectoryBasedStorageKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DirectoryStorageUtil;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathKt;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\rJ\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/openapi/components/impl/stores/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "dir", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;)V", "componentName", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "getSerializedState", "Lorg/jdom/Element;", "storageData", "component", "", "archive", "", "getVirtualFile", "hasState", "loadData", "setStorageData", "newStates", "setVirtualDir", "startExternalization", "Lcom/intellij/openapi/components/StateStorage$ExternalizationSession;", "MySaveSession", "configuration-store-impl"})
public class DirectoryBasedStorage
extends StateStorageBase<StateMap> {
    private volatile VirtualFile virtualFile;
    private String componentName;
    private final Path dir;
    private final StateSplitter splitter;
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;

    public final void setVirtualDir(@Nullable VirtualFile dir) {
        this.virtualFile = dir;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap newData = this.loadData();
        this.getStorageDataRef().set(newData);
        if (this.componentName != null) {
            String string = this.componentName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            componentNames.add(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        if (storageData.isEmpty()) {
            return null;
        }
        Element state = new Element("component");
        if (this.splitter instanceof StateSplitterEx) {
            String[] stringArray = storageData.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                Element subState;
                String fileName = stringArray[i];
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                ((StateSplitterEx)this.splitter).mergeStateInto(state, subState);
            }
        } else {
            Object fileName;
            SmartList subElements = new SmartList();
            String[] subState = storageData.keys();
            for (int i = 0; i < subState.length; ++i) {
                Element subState2;
                fileName = subState[i];
                if (storageData.getState((String)fileName, archive) == null) {
                    return null;
                }
                subElements.add((Object)subState2);
            }
            if (!subElements.isEmpty()) {
                void $receiver$iv;
                fileName = (Collection)subElements;
                Element element = state;
                StateSplitter stateSplitter = this.splitter;
                Collection thisCollection$iv = (Collection)$receiver$iv;
                Element[] elementArray = thisCollection$iv.toArray(new Element[thisCollection$iv.size()]);
                if (elementArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] objectArray = elementArray;
                stateSplitter.mergeStatesInto(element, (Element[])objectArray);
            }
        }
        return state;
    }

    @Override
    @NotNull
    protected StateMap loadData() {
        Map<String, Element> map = DirectoryStorageUtil.loadFrom(this.getVirtualFile(), this.pathMacroSubstitutor);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"DirectoryStorageUtil.loa\u2026(), pathMacroSubstitutor)");
        return StateMap.Companion.fromMap(map);
    }

    private final VirtualFile getVirtualFile() {
        VirtualFile result = this.virtualFile;
        if (result == null) {
            this.virtualFile = result = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath(this.dir));
        }
        return result;
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? (StateStorage.ExternalizationSession)null : (StateStorage.ExternalizationSession)new MySaveSession(this, (StateMap)StateStorageBase.getStorageData$default(this, false, 1, null));
    }

    private final void setStorageData(StateMap newStates) {
        this.getStorageDataRef().set(newStates);
    }

    @Override
    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasStates();
    }

    public DirectoryBasedStorage(@NotNull Path dir, @NotNull StateSplitter splitter, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
        this.dir = dir;
        this.splitter = splitter;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
    }

    public /* synthetic */ DirectoryBasedStorage(Path path, StateSplitter stateSplitter, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        this(path, stateSplitter, trackingPathMacroSubstitutor);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getVirtualFile$p(DirectoryBasedStorage $this) {
        return $this.virtualFile;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001a\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0014R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage$MySaveSession;", "Lcom/intellij/configurationStore/SaveSessionBase;", "storage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "(Lcom/intellij/configurationStore/DirectoryBasedStorage;Lcom/intellij/configurationStore/StateMap;)V", "copiedStorageData", "", "", "", "dirtyFileNames", "Lcom/intellij/util/containers/SmartHashSet;", "someFileRemoved", "", "createSaveSession", "deleteFiles", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSetState", "fileName", "subState", "Lorg/jdom/Element;", "save", "saveStates", "states", "setSerializedState", "componentName", "element", "configuration-store-impl"})
    private static final class MySaveSession
    extends SaveSessionBase {
        private Map<String, Object> copiedStorageData;
        private final SmartHashSet<String> dirtyFileNames;
        private boolean someFileRemoved;
        private final DirectoryBasedStorage storage;
        private final StateMap originalStates;

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            block9: {
                block7: {
                    block8: {
                        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
                        this.storage.componentName = componentName;
                        if (!JDOMUtil.isEmpty((Element)element)) break block7;
                        if (this.copiedStorageData == null) break block8;
                        Map<String, Object> map = this.copiedStorageData;
                        if (map == null) {
                            Intrinsics.throwNpe();
                        }
                        map.clear();
                        break block9;
                    }
                    if (this.originalStates.isEmpty()) break block9;
                    this.copiedStorageData = (Map)new THashMap();
                    break block9;
                }
                StateSplitter stateSplitter = this.storage.splitter;
                Element element2 = element;
                if (element2 == null) {
                    Intrinsics.throwNpe();
                }
                List stateAndFileNameList = stateSplitter.splitState(element2);
                for (Pair pair : stateAndFileNameList) {
                    String string = (String)pair.second;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pair.second");
                    Element element3 = (Element)pair.first;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"pair.first");
                    this.doSetState(string, element3);
                }
                String[] stringArray = this.originalStates.keys();
                block1: for (int i = 0; i < stringArray.length; ++i) {
                    String key = stringArray[i];
                    for (Pair pair : stateAndFileNameList) {
                        if (!Intrinsics.areEqual((Object)((String)pair.second), (Object)key)) continue;
                        continue block1;
                    }
                    if (this.copiedStorageData == null) {
                        this.copiedStorageData = this.originalStates.toMutableMap();
                    }
                    this.someFileRemoved = true;
                    Map<String, Object> map = this.copiedStorageData;
                    if (map == null) {
                        Intrinsics.throwNpe();
                    }
                    map.remove(key);
                }
            }
        }

        private final void doSetState(String fileName, Element subState) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = StateMapKt.setStateAndCloneIfNeed$default(fileName, subState, this.originalStates, null, 8, null);
                if (this.copiedStorageData != null) {
                    this.dirtyFileNames.add((Object)fileName);
                }
            } else {
                Map<String, Object> map = this.copiedStorageData;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                if (StateMapKt.updateState$default(map, fileName, subState, null, 8, null)) {
                    this.dirtyFileNames.add((Object)fileName);
                }
            }
        }

        @Nullable
        public MySaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? (MySaveSession)null : this;
        }

        public void save() {
            Map<String, Object> map = this.copiedStorageData;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            StateMap stateMap = StateMap.Companion.fromMap(map);
            VirtualFile dir = this.storage.getVirtualFile();
            Map<String, Object> map2 = this.copiedStorageData;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            if (map2.isEmpty()) {
                if (dir != null && dir.exists()) {
                    FileBasedStorageKt.deleteFile(this, dir);
                }
                this.storage.setStorageData(stateMap);
                return;
            }
            if (dir == null || !dir.isValid()) {
                dir = SchemeManagerImplKt.createDir(this.storage.dir, this);
                this.storage.virtualFile = dir;
            }
            if (!this.dirtyFileNames.isEmpty()) {
                this.saveStates(dir, stateMap);
            }
            if (this.someFileRemoved && dir.exists()) {
                this.deleteFiles(dir);
            }
            this.storage.setStorageData(stateMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void saveStates(VirtualFile dir, StateMap states) {
            Element storeElement = new Element("component");
            String[] stringArray = states.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String fileName = stringArray[i];
                if (!this.dirtyFileNames.contains((Object)fileName)) continue;
                Element element = null;
                try {
                    Unit unit;
                    element = states.getElement(fileName, null);
                    TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.storage.pathMacroSubstitutor;
                    if (trackingPathMacroSubstitutor != null) {
                        trackingPathMacroSubstitutor.collapsePaths(element);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    String string = this.storage.componentName;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    storeElement.setAttribute("name", string);
                    storeElement.addContent(element);
                    VirtualFile file2 = SchemeManagerImplKt.getFile(fileName, dir, this);
                    File file3 = null;
                    LineSeparator lineSeparator = LineSeparator.fromString((String)(file2.exists() ? (String)DirectoryBasedStorageKt.access$loadFile((VirtualFile)file2).second : SystemProperties.getLineSeparator()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator, (String)"LineSeparator.fromString\u2026rties.getLineSeparator())");
                    FileBasedStorageKt.writeFile(file3, this, file2, storeElement, lineSeparator, false);
                    continue;
                }
                catch (IOException e) {
                    ComponentStoreImplKt.getLOG().error((Throwable)e);
                    continue;
                }
                finally {
                    if (element != null) {
                        element.detach();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void deleteFiles(VirtualFile dir) {
            AccessToken token$iv = WriteAction.start();
            try {
                VirtualFile[] virtualFileArray = dir.getChildren();
                for (int i = 0; i < virtualFileArray.length; ++i) {
                    VirtualFile file2 = virtualFileArray[i];
                    String fileName = file2.getName();
                    if (!StringsKt.endsWith$default((String)fileName, (String)".xml", (boolean)false, (int)2, null)) continue;
                    Map<String, Object> map = this.copiedStorageData;
                    if (map == null) {
                        Intrinsics.throwNpe();
                    }
                    if (map.containsKey(fileName)) continue;
                    try {
                        file2.delete((Object)this);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw (Throwable)new ReadOnlyModificationException(file2, e, null);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                token$iv.finish();
            }
        }

        public MySaveSession(@NotNull DirectoryBasedStorage storage2, @NotNull StateMap originalStates) {
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            this.storage = storage2;
            this.originalStates = originalStates;
            this.dirtyFileNames = new SmartHashSet();
        }
    }
}

