/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.FieldDataBinding;
import java.lang.reflect.Field;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NonNls;

public class ToggleButtonBinding
extends FieldDataBinding {
    private final JToggleButton myToggleButton;

    public ToggleButtonBinding(@NonNls String dataFieldName, JToggleButton checkBox) {
        super(dataFieldName);
        this.myToggleButton = checkBox;
    }

    @Override
    public void doLoadData(Object from, Field field) throws IllegalAccessException {
        Boolean value = (Boolean)field.get(from);
        this.myToggleButton.setSelected(value);
    }

    @Override
    public void doSaveData(Object to, Field field) throws IllegalAccessException {
        field.set(to, this.myToggleButton.isSelected());
    }

    @Override
    protected boolean isModified(Object obj, Field field) throws IllegalAccessException {
        Boolean value = (Boolean)field.get(obj);
        return this.myToggleButton.isSelected() != value.booleanValue();
    }
}

