/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialog;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.errorreport.itn.ITNProxy;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ITNReporter
extends ErrorReportSubmitter {
    private static int previousExceptionThreadId = 0;

    public String getReportActionText() {
        return DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, String additionalInfo, @NotNull Component parentComponent, @NotNull Consumer<SubmittedReportInfo> consumer) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/diagnostic/ITNReporter", "submit"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/diagnostic/ITNReporter", "submit"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/diagnostic/ITNReporter", "submit"));
        }
        ErrorBean errorBean = new ErrorBean(events[0].getThrowable(), IdeaLogger.ourLastActionId);
        return ITNReporter.doSubmit(events[0], parentComponent, consumer, errorBean, additionalInfo);
    }

    public boolean showErrorInRelease(IdeaLoggingEvent event) {
        return false;
    }

    private static boolean doSubmit(final IdeaLoggingEvent event, final Component parentComponent, final Consumer<SubmittedReportInfo> callback, final ErrorBean errorBean, final String description) {
        Object data;
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId;
        Throwable t;
        JetBrainsAccountDialog dlg;
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        ErrorReportConfigurable settings = ErrorReportConfigurable.getInstance();
        if (!settings.KEEP_ITN_PASSWORD && !StringUtil.isEmpty((String)settings.ITN_LOGIN) && StringUtil.isEmpty((String)settings.getPlainItnPassword()) && !(dlg = new JetBrainsAccountDialog(parentComponent)).showAndGet()) {
            return false;
        }
        errorBean.setDescription(description);
        errorBean.setMessage(event.getMessage());
        if (previousExceptionThreadId != 0) {
            errorBean.setPreviousException(previousExceptionThreadId);
        }
        if ((t = event.getThrowable()) != null && (pluginId = IdeErrorsDialog.findPluginId(t)) != null && (ideaPluginDescriptor = PluginManager.getPlugin(pluginId)) != null && (!ideaPluginDescriptor.isBundled() || ideaPluginDescriptor.allowBundledUpdate())) {
            errorBean.setPluginName(ideaPluginDescriptor.getName());
            errorBean.setPluginVersion(ideaPluginDescriptor.getVersion());
        }
        if ((data = event.getData()) instanceof AbstractMessage) {
            errorBean.setAssigneeId(((AbstractMessage)data).getAssigneeId());
            errorBean.setAttachments(((AbstractMessage)data).getAttachments());
        }
        String login = settings.ITN_LOGIN;
        String password = settings.getPlainItnPassword();
        if (StringUtil.isEmptyOrSpaces((String)login) && StringUtil.isEmptyOrSpaces((String)password)) {
            login = "idea_anonymous";
            password = "guest";
        }
        ITNProxy.sendError(project2, login, password, errorBean, new Consumer<Integer>(){

            public void consume(Integer threadId) {
                ITNReporter.updatePreviousThreadId(threadId);
                String url = ITNProxy.getBrowseUrl(threadId);
                String linkText = String.valueOf(threadId);
                final SubmittedReportInfo reportInfo = new SubmittedReportInfo(url, linkText, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback.consume((Object)reportInfo);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder text = new StringBuilder();
                        IdeErrorsDialog.appendSubmissionInformation(reportInfo, text);
                        text.append('.').append("<br/>").append(DiagnosticBundle.message("error.report.gratitude", new Object[0]));
                        String content = XmlStringUtil.wrapInHtml((CharSequence)text);
                        ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, content, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project2);
                    }
                });
            }
        }, new Consumer<Exception>(){

            public void consume(final Exception e) {
                Logger.getInstance(ITNReporter.class).info("reporting failed: " + e);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = e instanceof NoSuchEAPUserException ? DiagnosticBundle.message("error.report.authentication.failed", new Object[0]) : (e instanceof InternalEAPException ? DiagnosticBundle.message("error.report.posting.failed", e.getMessage()) : DiagnosticBundle.message("error.report.sending.failure", new Object[0]));
                        if (e instanceof UpdateAvailableException) {
                            String message = DiagnosticBundle.message("error.report.new.eap.build.message", e.getMessage());
                            ITNReporter.showMessageDialog(parentComponent, project2, message, CommonBundle.getWarningTitle(), Messages.getWarningIcon());
                            callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                        } else if (ITNReporter.showYesNoDialog(parentComponent, project2, msg, ReportMessages.ERROR_REPORT, Messages.getErrorIcon()) != 0) {
                            callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                        } else {
                            if (e instanceof NoSuchEAPUserException) {
                                JetBrainsAccountDialog dialog = parentComponent.isShowing() ? new JetBrainsAccountDialog(parentComponent) : new JetBrainsAccountDialog(project2);
                                dialog.show();
                            }
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ITNReporter.doSubmit(event, parentComponent, (Consumer<SubmittedReportInfo>)callback, errorBean, description);
                                }
                            });
                        }
                    }
                });
            }
        });
        return true;
    }

    private static void updatePreviousThreadId(Integer threadId) {
        previousExceptionThreadId = threadId;
    }

    private static void showMessageDialog(Component parentComponent, Project project2, String message, String title, Icon icon) {
        if (parentComponent.isShowing()) {
            Messages.showMessageDialog((Component)parentComponent, (String)message, (String)title, (Icon)icon);
        } else {
            Messages.showMessageDialog((Project)project2, (String)message, (String)title, (Icon)icon);
        }
    }

    @Messages.YesNoResult
    private static int showYesNoDialog(Component parentComponent, Project project2, String message, String title, Icon icon) {
        if (parentComponent.isShowing()) {
            return Messages.showYesNoDialog((Component)parentComponent, (String)message, (String)title, (Icon)icon);
        }
        return Messages.showYesNoDialog((Project)project2, (String)message, (String)title, (Icon)icon);
    }
}

