/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface BlockAlignmentProcessor {
    public Result applyAlignment(@NotNull Context var1);

    public static class Context {
        @NotNull
        public final Document document;
        @NotNull
        public final AlignmentImpl alignment;
        @NotNull
        public final LeafBlockWrapper targetBlock;
        @NotNull
        public final Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings;
        @NotNull
        public final Map<LeafBlockWrapper, Set<LeafBlockWrapper>> backwardShiftedAlignedBlocks;
        @NotNull
        public final CommonCodeStyleSettings.IndentOptions indentOptions;

        public Context(@NotNull Document document, @NotNull AlignmentImpl alignment, @NotNull LeafBlockWrapper targetBlock, @NotNull Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings, @NotNull Map<LeafBlockWrapper, Set<LeafBlockWrapper>> backwardShiftedAlignedBlocks, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/formatting/BlockAlignmentProcessor$Context", "<init>"));
            }
            if (alignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignment", "com/intellij/formatting/BlockAlignmentProcessor$Context", "<init>"));
            }
            if (targetBlock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetBlock", "com/intellij/formatting/BlockAlignmentProcessor$Context", "<init>"));
            }
            if (alignmentMappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignmentMappings", "com/intellij/formatting/BlockAlignmentProcessor$Context", "<init>"));
            }
            if (backwardShiftedAlignedBlocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backwardShiftedAlignedBlocks", "com/intellij/formatting/BlockAlignmentProcessor$Context", "<init>"));
            }
            if (indentOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/intellij/formatting/BlockAlignmentProcessor$Context", "<init>"));
            }
            this.document = document;
            this.alignment = alignment;
            this.targetBlock = targetBlock;
            this.alignmentMappings = alignmentMappings;
            this.backwardShiftedAlignedBlocks = backwardShiftedAlignedBlocks;
            this.indentOptions = indentOptions;
        }
    }

    public static enum Result {
        TARGET_BLOCK_PROCESSED_NOT_ALIGNED,
        TARGET_BLOCK_ALIGNED,
        BACKWARD_BLOCK_ALIGNED,
        RECURSION_DETECTED,
        UNABLE_TO_ALIGN_BACKWARD_BLOCK;

    }
}

