/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinActiveTabAction
extends ToggleAction
implements DumbAware {
    @Nullable
    private static VirtualFile getFile(DataContext context) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project2 == null) {
            return null;
        }
        return (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
    }

    @Nullable
    private static Content getContent(DataContext context) {
        Content[] contents = (Content[])ViewContext.CONTENT_KEY.getData(context);
        if (contents != null && contents.length == 1) {
            return contents[0];
        }
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(context, true);
        if (contentManager == null) {
            return null;
        }
        return contentManager.getSelectedContent();
    }

    public boolean isSelected(AnActionEvent e) {
        EditorWindow editorWindow;
        DataContext context = e.getDataContext();
        VirtualFile file2 = PinActiveTabAction.getFile(context);
        if (file2 != null && (editorWindow = PinActiveTabAction.getEditorWindow(context)) != null) {
            if (!editorWindow.isFileOpen(file2) && (file2 = editorWindow.getSelectedFile()) == null) {
                return false;
            }
            return editorWindow.isFilePinned(file2);
        }
        Content content = PinActiveTabAction.getContent(context);
        if (content != null) {
            return content.isPinned();
        }
        return false;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        EditorWindow editorWindow;
        DataContext context = e.getDataContext();
        VirtualFile file2 = PinActiveTabAction.getFile(context);
        if (file2 != null && (editorWindow = PinActiveTabAction.getEditorWindow(context)) != null) {
            if (!editorWindow.isFileOpen(file2) && (file2 = editorWindow.getSelectedFile()) == null) {
                return;
            }
            editorWindow.setFilePinned(file2, state);
            return;
        }
        Content content = PinActiveTabAction.getContent(context);
        assert (content != null) : context;
        content.setPinned(state);
    }

    private static EditorWindow getEditorWindow(DataContext dataContext) {
        Project project2;
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (editorWindow == null && (project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null) {
            editorWindow = FileEditorManagerEx.getInstanceEx(project2).getCurrentWindow();
        }
        return editorWindow;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "update"));
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        DataContext context = e.getDataContext();
        EditorWindow window = PinActiveTabAction.getEditorWindow(context);
        if (window == null || window.getOwner().isPreview()) {
            presentation.setEnabledAndVisible(false);
        } else if (PinActiveTabAction.getFile(context) != null) {
            presentation.setEnabledAndVisible(true);
        } else {
            Content content = PinActiveTabAction.getContent(context);
            presentation.setEnabledAndVisible(content != null && content.isPinnable());
        }
        if ("EditorTabPopup".equals(e.getPlace()) || "debuggerCellPopup".equals(e.getPlace())) {
            presentation.setText(this.isSelected(e) ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
        } else {
            presentation.setText(this.isSelected(e) ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0]));
        }
    }
}

