/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PsiPackageFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, ViewSettings viewSettings) {
        block9: {
            String currentViewId;
            ArrayList<AbstractTreeNode> result;
            Project project2;
            block8: {
                PsiElement element;
                project2 = (Project)CommonDataKeys.PROJECT.getData(context);
                if (project2 == null) {
                    return null;
                }
                PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
                if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
                    elements = new PsiElement[]{element};
                }
                result = new ArrayList<AbstractTreeNode>();
                if (elements != null) {
                    for (PsiElement element2 : elements) {
                        PsiPackage psiPackage;
                        PsiDirectory[] directories;
                        if (!(element2 instanceof PsiPackage) || (directories = (psiPackage = (PsiPackage)element2).getDirectories()).length <= 0) continue;
                        VirtualFile firstDir = directories[0].getVirtualFile();
                        boolean isLibraryRoot = ProjectRootsUtil.isLibraryRoot(firstDir, project2);
                        PackageElement packageElement = new PackageElement((Module)LangDataKeys.MODULE.getData(context), psiPackage, isLibraryRoot);
                        result.add((AbstractTreeNode)new PackageElementNode(project2, packageElement, viewSettings));
                    }
                    return result.isEmpty() ? null : result;
                }
                currentViewId = ProjectView.getInstance(project2).getCurrentViewId();
                Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context);
                if (modules == null) break block8;
                for (Module module2 : modules) {
                    if ("PackagesPane".equals(currentViewId)) {
                        result.add((AbstractTreeNode)new PackageViewModuleNode(project2, module2, viewSettings));
                        continue;
                    }
                    result.add((AbstractTreeNode)new ProjectViewModuleNode(project2, module2, viewSettings));
                }
                break block9;
            }
            ModuleGroup[] data = (ModuleGroup[])ModuleGroup.ARRAY_DATA_KEY.getData(context);
            if (data == null) break block9;
            for (ModuleGroup moduleGroup : data) {
                if ("PackagesPane".equals(currentViewId)) {
                    result.add((AbstractTreeNode)new PackageViewModuleGroupNode(project2, moduleGroup, viewSettings));
                    continue;
                }
                result.add((AbstractTreeNode)new ProjectViewModuleGroupNode(project2, moduleGroup, viewSettings));
            }
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project2, Object element, ViewSettings viewSettings) {
        if (element instanceof PackageElement) {
            return new PackageElementNode(project2, element, viewSettings);
        }
        return super.createNode(project2, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, final VirtualFile vFile) {
        if (element instanceof PackageElement) {
            PsiDirectory[] directories;
            final HashSet find = new HashSet();
            ContentIterator contentIterator = new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (fileOrDir != null && fileOrDir.getPath().equals(vFile.getPath())) {
                        find.add(Boolean.TRUE);
                    }
                    return true;
                }
            };
            PackageElement packageElement = (PackageElement)element;
            PsiPackage aPackage = packageElement.getPackage();
            Project project2 = aPackage.getProject();
            GlobalSearchScope scope = packageElement.getModule() != null ? GlobalSearchScope.moduleScope((Module)packageElement.getModule()) : GlobalSearchScope.projectScope((Project)project2);
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            for (PsiDirectory directory : directories = aPackage.getDirectories(scope)) {
                projectFileIndex.iterateContentUnderDirectory(directory.getVirtualFile(), contentIterator);
            }
            return !find.isEmpty();
        }
        return false;
    }

    public int getElementWeight(Object element, boolean isSortByType) {
        if (element instanceof PackageElement) {
            return 2;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            Module module2 = packageElement.getModule();
            return (module2 != null ? module2.getName() + ":" : "") + packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PackageElement && !((PackageElement)element).getPackage().isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("package" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/PsiPackageFavoriteNodeProvider", "getFavoriteTypeId"));
        }
        return "package";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            PsiPackage aPackage = packageElement.getPackage();
            if (aPackage == null) {
                return null;
            }
            return aPackage.getQualifiedName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            Module module2 = packageElement.getModule();
            return module2 == null ? null : module2.getName();
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project2, String url, String moduleName) {
        Module module2 = moduleName != null ? ModuleManager.getInstance((Project)project2).findModuleByName(moduleName) : null;
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project2).findPackage(url);
        if (aPackage == null) {
            return null;
        }
        PackageElement packageElement = new PackageElement(module2, aPackage, false);
        return new Object[]{packageElement};
    }

    public PsiElement getPsiElement(Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).getPackage();
        }
        return super.getPsiElement(element);
    }
}

