/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.ProjectUtil");

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(String projectFilePath) {
        File lastProjectLocation = new File(projectFilePath);
        if (lastProjectLocation.isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path = lastProjectLocation.getPath();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(path.replace(File.separatorChar, '/'));
    }

    public static boolean closeAndDispose(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectUtil", "closeAndDispose"));
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project2);
    }

    @Nullable
    public static Project openOrImport(@NotNull String path, Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor provider;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "openOrImport"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        virtualFile.refresh(false, false);
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        ProjectOpenProcessor strong = ProjectOpenProcessor.getStrongImportProvider((VirtualFile)virtualFile);
        if (strong != null) {
            return strong.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        }
        if (path.endsWith(".ipr") || virtualFile.isDirectory() && virtualFile.findChild(".idea") != null) {
            return ProjectUtil.openProject(path, projectToClose, forceOpenInNewFrame);
        }
        if (virtualFile.isDirectory()) {
            for (VirtualFile child : virtualFile.getChildren()) {
                String childPath = child.getPath();
                if (!childPath.endsWith(".ipr")) continue;
                return ProjectUtil.openProject(childPath, projectToClose, forceOpenInNewFrame);
            }
        }
        if ((provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) != null) {
            final Project project2 = provider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
            if (project2 != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindow toolWindow;
                        if (!project2.isDisposed() && (toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.PROJECT_VIEW)) != null) {
                            toolWindow.activate(null);
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
            return project2;
        }
        return null;
    }

    @Nullable
    public static Project openProject(String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        File file2 = new File(path);
        if (!file2.exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{path}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        if (file2.isDirectory() && !new File(file2, ".idea").exists()) {
            String message = IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{new File(file2, ".idea").getPath()});
            Messages.showErrorDialog((String)message, (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1) {
                Project toClose;
                Project project2 = toClose = projectToClose != null ? projectToClose : openProjects[openProjects.length - 1];
                if (!ProjectUtil.closeAndDispose(toClose)) {
                    return null;
                }
            } else if (exitCode != 0) {
                return null;
            }
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project3 = null;
        try {
            project3 = projectManager.loadAndOpenProject(path);
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return project3;
    }

    @Nullable
    private static Project findAndFocusExistingProjectForPath(String path) {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (project2.isDefault() || !ProjectUtil.isSameProject(path, project2)) continue;
            ProjectUtil.focusProjectWindow(project2, false);
            return project2;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    public static boolean isSameProject(String path, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectUtil", "isSameProject"));
        }
        IProjectStore projectStore = (IProjectStore)ServiceKt.getStateStore((ComponentManager)project2);
        String toOpen = FileUtil.toSystemIndependentName((String)path);
        String existing = projectStore.getProjectFilePath();
        String existingBaseDir = projectStore.getProjectBasePath();
        if (existingBaseDir == null) {
            return false;
        }
        File openFile = new File(toOpen);
        if (openFile.isDirectory()) {
            return FileUtil.pathsEqual((String)toOpen, (String)existingBaseDir);
        }
        if (StorageScheme.DIRECTORY_BASED == projectStore.getStorageScheme()) {
            return FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)openFile.getParentFile().getPath()), (String)existingBaseDir);
        }
        return FileUtil.pathsEqual((String)toOpen, (String)existing);
    }

    public static void focusProjectWindow(final Project p, boolean executeIfAppInactive) {
        FocusCommand cmd = new FocusCommand(){

            @NotNull
            public ActionCallback run() {
                JFrame f = WindowManager.getInstance().getFrame(p);
                if (f != null) {
                    f.toFront();
                }
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectUtil$2", "run"));
                }
                return actionCallback;
            }
        };
        if (executeIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)WindowManager.getInstance().getFrame(p));
            cmd.run();
        } else {
            IdeFocusManager.getInstance((Project)p).requestFocus(cmd, true);
        }
    }

    public static String getBaseDir() {
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        return userHome.replace('/', File.separatorChar) + File.separator + ApplicationNamesInfo.getInstance().getLowercaseProductName() + "Projects";
    }

    public static boolean isDirectoryBased(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectUtil", "isDirectoryBased"));
        }
        IComponentStore store = ServiceKt.getStateStore((ComponentManager)project2);
        return store instanceof IProjectStore && StorageScheme.DIRECTORY_BASED.equals((Object)((IProjectStore)store).getStorageScheme());
    }
}

