/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PresentationFactory {
    private final Map<AnAction, Presentation> myAction2Presentation = ContainerUtil.createWeakKeySoftValueMap();

    @NotNull
    public final Presentation getPresentation(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/impl/PresentationFactory", "getPresentation"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Presentation presentation = this.myAction2Presentation.get(action);
        if (presentation == null || !action.isDefaultIcon()) {
            Presentation templatePresentation = action.getTemplatePresentation();
            if (presentation == null) {
                presentation = templatePresentation.clone();
                this.myAction2Presentation.put(action, presentation);
            }
            if (!action.isDefaultIcon()) {
                presentation.setIcon(templatePresentation.getIcon());
                presentation.setDisabledIcon(templatePresentation.getDisabledIcon());
            }
            this.processPresentation(presentation);
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/PresentationFactory", "getPresentation"));
        }
        return presentation2;
    }

    protected void processPresentation(Presentation presentation) {
    }

    public void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAction2Presentation.clear();
    }
}

