/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil");
    public static final String MAIN_MENU_TITLE = KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    public static final String MAIN_TOOLBAR = KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    public static final String EDITOR_POPUP = KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    public static final String EDITOR_TAB_POPUP = KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    public static final String FAVORITES_POPUP = KeyMapBundle.message((String)"favorites.popup.title", (Object[])new Object[0]);
    public static final String PROJECT_VIEW_POPUP = KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    public static final String COMMANDER_POPUP = KeyMapBundle.message((String)"commender.view.popup.menu.title", (Object[])new Object[0]);
    public static final String J2EE_POPUP = KeyMapBundle.message((String)"j2ee.view.popup.menu.title", (Object[])new Object[0]);
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";
    @NonNls
    private static final String TOOL_ACTION_PREFIX = "Tool_";

    private ActionsTreeUtil() {
    }

    private static Group createPluginsActionsGroup(Condition<AnAction> filtered) {
        AnAction anAction;
        String[] pluginActions;
        Group pluginGroup;
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null, null);
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        ArrayList plugins2 = new ArrayList();
        Collections.addAll(plugins2, PluginManagerCore.getPlugins());
        Collections.sort(plugins2, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<PluginId> collected = new ArrayList<PluginId>();
        for (IdeaPluginDescriptor plugin : plugins2) {
            collected.add(plugin.getPluginId());
            if (plugin.getName().equals("IDEA CORE")) continue;
            pluginGroup = new Group(plugin.getName(), null, null);
            pluginActions = managerEx.getPluginActions(plugin.getPluginId());
            if (pluginActions == null || pluginActions.length == 0) continue;
            Arrays.sort(pluginActions, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return ActionsTreeUtil.getTextToCompare(o1).compareTo(ActionsTreeUtil.getTextToCompare(o2));
                }
            });
            for (String pluginAction : pluginActions) {
                if (keymapManager.getBoundActions().contains(pluginAction)) continue;
                anAction = managerEx.getActionOrStub(pluginAction);
                if (filtered != null && !filtered.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        for (PluginId pluginId : PluginId.getRegisteredIds().values()) {
            if (collected.contains(pluginId)) continue;
            pluginGroup = new Group(pluginId.getIdString(), null, null);
            pluginActions = managerEx.getPluginActions(pluginId);
            if (pluginActions == null || pluginActions.length == 0) continue;
            for (String pluginAction : pluginActions) {
                if (keymapManager.getBoundActions().contains(pluginAction)) continue;
                anAction = managerEx.getActionOrStub(pluginAction);
                if (filtered != null && !filtered.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        return pluginsGroup;
    }

    private static Group createMainMenuGroup(Condition<AnAction> filtered) {
        Group group = new Group(MAIN_MENU_TITLE, "MainMenu", AllIcons.Nodes.KeymapMainMenu);
        ActionGroup mainMenuGroup = (ActionGroup)ActionManager.getInstance().getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group, filtered);
        return group;
    }

    @Nullable
    private static Condition<AnAction> wrapFilter(final @Nullable Condition<AnAction> filter, final Keymap keymap, final ActionManager actionManager) {
        final ActionShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance();
        return new Condition<AnAction>(){

            public boolean value(AnAction action) {
                String id;
                if (action == null) {
                    return false;
                }
                String string = id = action instanceof ActionStub ? ((ActionStub)action).getId() : actionManager.getId(action);
                if (id != null) {
                    if (!Registry.is((String)"keymap.show.alias.actions")) {
                        boolean bound;
                        String binding = ActionsTreeUtil.getActionBinding(keymap, id);
                        boolean bl = bound = binding != null && actionManager.getAction(binding) != null && !ActionsTreeUtil.hasAssociatedShortcutsInHierarchy(id, keymap);
                        if (bound) {
                            return false;
                        }
                    }
                    if (!shortcutRestrictions.getForActionId((String)id).allowChanging) {
                        return false;
                    }
                }
                return filter == null || filter.value((Object)action);
            }
        };
    }

    private static boolean hasAssociatedShortcutsInHierarchy(String id, Keymap keymap) {
        while (keymap != null) {
            if (((KeymapImpl)keymap).hasOwnActionId(id)) {
                return true;
            }
            keymap = keymap.getParent();
        }
        return false;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup, Group group, Condition<AnAction> filtered) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action : mainMenuTopGroups = actionGroup instanceof DefaultActionGroup ? ((DefaultActionGroup)actionGroup).getChildActionsOrStubs() : actionGroup.getChildren(null)) {
            Group subGroup;
            if (!(action instanceof ActionGroup) || (subGroup = ActionsTreeUtil.createGroup((ActionGroup)action, false, filtered)).getSize() <= 0) continue;
            group.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup, boolean ignore, Condition<AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, ActionsTreeUtil.getName((AnAction)actionGroup), null, null, ignore, filtered);
    }

    private static String getName(AnAction action) {
        String id;
        String name = action.getTemplatePresentation().getText();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String string = id = action instanceof ActionStub ? ((ActionStub)action).getId() : ActionManager.getInstance().getId(action);
        if (id != null) {
            return id;
        }
        if (action instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group = (DefaultActionGroup)action;
            if (group.getChildrenCount() == 0) {
                return "Empty group";
            }
            for (AnAction child : children2 = group.getChildActionsOrStubs()) {
                if (child instanceof Separator) continue;
                return "group." + ActionsTreeUtil.getName(child);
            }
            return "Empty unnamed group";
        }
        return action.getClass().getName();
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon, Icon openIcon, boolean ignore, Condition<AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, groupName, icon, openIcon, ignore, filtered, true);
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon, Icon openIcon, boolean ignore, Condition<AnAction> filtered, boolean normalizeSeparators) {
        AnAction[] children2;
        ActionManager actionManager = ActionManager.getInstance();
        Group group = new Group(groupName, actionManager.getId((AnAction)actionGroup), icon);
        for (AnAction action : children2 = actionGroup instanceof DefaultActionGroup ? ((DefaultActionGroup)actionGroup).getChildActionsOrStubs() : actionGroup.getChildren(null)) {
            String id;
            if (action == null) {
                LOG.error(groupName + " contains null actions");
                continue;
            }
            if (action instanceof ActionGroup) {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action, ActionsTreeUtil.getName(action), null, null, ignore, filtered, normalizeSeparators);
                if (subGroup.getSize() > 0) {
                    if (!ignore && !((ActionGroup)action).isPopup()) {
                        group.addAll(subGroup);
                        continue;
                    }
                    group.addGroup(subGroup);
                    continue;
                }
                if (filtered != null && !filtered.value((Object)action)) continue;
                group.addGroup(subGroup);
                continue;
            }
            if (action instanceof Separator) {
                group.addSeparator();
                continue;
            }
            String string = id = action instanceof ActionStub ? ((ActionStub)action).getId() : actionManager.getId(action);
            if (id == null || id.startsWith(TOOL_ACTION_PREFIX) || filtered != null && !filtered.value((Object)action)) continue;
            group.addActionId(id);
        }
        if (normalizeSeparators) {
            group.normalizeSeparators();
        }
        return group;
    }

    private static Group createEditorActionsGroup(Condition<AnAction> filtered) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        ArrayList<String> ids = new ArrayList<String>();
        ActionsTreeUtil.addEditorActions(filtered, editorGroup, ids);
        Collections.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", AllIcons.Nodes.KeymapEditor);
        for (String id : ids) {
            group.addActionId(id);
        }
        return group;
    }

    @Nullable
    private static String getActionBinding(Keymap keymap, String id) {
        if (keymap == null) {
            return null;
        }
        Keymap parent = keymap.getParent();
        String result = ((KeymapImpl)keymap).getActionBinding(id);
        if (result == null && parent != null) {
            result = ((KeymapImpl)parent).getActionBinding(id);
        }
        return result;
    }

    private static void addEditorActions(Condition<AnAction> filtered, DefaultActionGroup editorGroup, ArrayList<String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            String actionId;
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String string = actionId = editorAction instanceof ActionStub ? ((ActionStub)editorAction).getId() : actionManager.getId(editorAction);
            if (actionId == null || filtered != null && !filtered.value((Object)editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static Group createExtensionGroup(Condition<AnAction> filtered, Project project2, KeymapExtension provider) {
        return (Group)provider.createGroup(filtered, project2);
    }

    private static Group createMacrosGroup(Condition<AnAction> filtered) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds("Macro.");
        Arrays.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, null);
        for (Object id : ids) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub((String)id))) continue;
            group.addActionId((String)id);
        }
        return group;
    }

    private static Group createQuickListsGroup(Condition<AnAction> filtered, String filter, boolean forceFiltering, QuickList[] quickLists) {
        Arrays.sort(quickLists, new Comparator<QuickList>(){

            @Override
            public int compare(QuickList l1, QuickList l2) {
                return l1.getActionId().compareTo(l2.getActionId());
            }
        });
        Group group = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]), null, null);
        for (QuickList quickList : quickLists) {
            if (filtered != null && filtered.value((Object)ActionManagerEx.getInstanceEx().getAction(quickList.getActionId()))) {
                group.addQuickList(quickList);
                continue;
            }
            if (SearchUtil.isComponentHighlighted(quickList.getName(), filter, forceFiltering, null)) {
                group.addQuickList(quickList);
                continue;
            }
            if (filtered != null || !StringUtil.isEmpty((String)filter)) continue;
            group.addQuickList(quickList);
        }
        return group;
    }

    private static Group createOtherGroup(Condition<AnAction> filtered, Group addedActions, Keymap keymap) {
        String[] registeredActionIds;
        addedActions.initIds();
        ArrayList<String> result = new ArrayList<String>();
        if (keymap != null) {
            String[] actionIds;
            for (String id : actionIds = keymap.getActionIds()) {
                AnAction action;
                if (id.startsWith(EDITOR_PREFIX) && (action = ActionManager.getInstance().getActionOrStub("$" + id.substring(6))) != null || id.startsWith("QuickList.") || addedActions.containsId(id)) continue;
                result.add(id);
            }
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        for (String id : registeredActionIds = actionManager.getActionIds("")) {
            AnAction actionOrStub = actionManager.getActionOrStub(id);
            if (actionOrStub instanceof ActionGroup && !((ActionGroup)actionOrStub).canBePerformed(DataManager.getInstance().getDataContext()) || id.startsWith("QuickList.") || addedActions.containsId(id) || result.contains(id) || keymapManager.getBoundActions().contains(id)) continue;
            result.add(id);
        }
        ActionsTreeUtil.filterOtherActionsGroup(result);
        ContainerUtil.quickSort(result, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                return ActionsTreeUtil.getTextToCompare(id1).compareToIgnoreCase(ActionsTreeUtil.getTextToCompare(id2));
            }
        });
        Group group = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), AllIcons.Nodes.KeymapOther);
        for (String id : result) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id))) continue;
            group.addActionId(id);
        }
        return group;
    }

    private static String getTextToCompare(String id) {
        AnAction action = ActionManager.getInstance().getActionOrStub(id);
        if (action == null) {
            return id;
        }
        String text = action.getTemplatePresentation().getText();
        return text != null ? text : id;
    }

    private static void filterOtherActionsGroup(ArrayList<String> actions) {
        ActionsTreeUtil.filterOutGroup(actions, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions, "ChangeScheme");
    }

    private static void filterOutGroup(ArrayList<String> actions, String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getActionOrStub(groupId);
        if (action instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group = (DefaultActionGroup)action;
            for (AnAction child : children2 = group.getChildActionsOrStubs()) {
                String childId;
                String string = childId = child instanceof ActionStub ? ((ActionStub)child).getId() : actionManager.getId(child);
                if (childId == null) continue;
                if (child instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions, childId);
                    continue;
                }
                actions.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(group);
        for (Object child : group.getChildren()) {
            if (child instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child);
                node.add(childNode);
                continue;
            }
            LOG.assertTrue(child != null);
            node.add(new DefaultMutableTreeNode(child));
        }
        return node;
    }

    public static Group createMainGroup(Project project2, Keymap keymap, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project2, keymap, quickLists, null, false, null);
    }

    public static Group createMainGroup(Project project2, Keymap keymap, QuickList[] quickLists, String filter, boolean forceFiltering, Condition<AnAction> filtered) {
        Condition<AnAction> wrappedFilter = ActionsTreeUtil.wrapFilter(filtered, keymap, ActionManager.getInstance());
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]), null, null);
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(wrappedFilter));
        for (KeymapExtension extension : (KeymapExtension[])Extensions.getExtensions((ExtensionPointName)KeymapExtension.EXTENSION_POINT_NAME)) {
            Group group = ActionsTreeUtil.createExtensionGroup(wrappedFilter, project2, extension);
            if (group == null) continue;
            mainGroup.addGroup(group);
        }
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(wrappedFilter, filter, forceFiltering, quickLists));
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createOtherGroup(wrappedFilter, mainGroup, keymap));
        if (!StringUtil.isEmpty((String)filter) || filtered != null) {
            ArrayList<Object> list = mainGroup.getChildren();
            Iterator<Object> i = list.iterator();
            while (i.hasNext()) {
                Group group;
                Object o = i.next();
                if (!(o instanceof Group) || (group = (Group)o).getSize() != 0 || SearchUtil.isComponentHighlighted(group.getName(), filter, forceFiltering, null)) continue;
                i.remove();
            }
        }
        return mainGroup;
    }

    public static Condition<AnAction> isActionFiltered(final String filter, final boolean force) {
        return new Condition<AnAction>(){

            public boolean value(AnAction action) {
                if (filter == null) {
                    return true;
                }
                if (action == null) {
                    return false;
                }
                String insensitiveFilter = filter.toLowerCase();
                for (String text : new String[]{action.getTemplatePresentation().getText(), action.getTemplatePresentation().getDescription(), action instanceof ActionStub ? ((ActionStub)action).getId() : ActionManager.getInstance().getId(action)}) {
                    if (text == null) continue;
                    String lowerText = text.toLowerCase();
                    if (SearchUtil.isComponentHighlighted(lowerText, insensitiveFilter, force, null)) {
                        return true;
                    }
                    if (!lowerText.contains(insensitiveFilter)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Condition<AnAction> isActionFiltered(final ActionManager actionManager, final Keymap keymap, final Shortcut shortcut) {
        return new Condition<AnAction>(){

            public boolean value(AnAction action) {
                Shortcut[] actionShortcuts;
                if (shortcut == null) {
                    return true;
                }
                if (action == null) {
                    return false;
                }
                for (Shortcut actionShortcut : actionShortcuts = keymap.getShortcuts(action instanceof ActionStub ? ((ActionStub)action).getId() : actionManager.getId(action))) {
                    if (!shortcut.equals(actionShortcut)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap, Shortcut shortcut, String filter, boolean force) {
        return filter != null && filter.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter, force) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, keymap, shortcut) : null);
    }
}

