/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryInfoImpl
extends DirectoryInfo {
    public static final int MAX_ROOT_TYPE_ID = 127;
    private final VirtualFile myRoot;
    private final Module module;
    private final VirtualFile libraryClassRoot;
    private final VirtualFile contentRoot;
    private final VirtualFile sourceRoot;
    private final boolean myInModuleSource;
    private final boolean myInLibrarySource;
    private final boolean myExcluded;
    private final byte mySourceRootTypeId;

    DirectoryInfoImpl(@NotNull VirtualFile root, Module module2, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, int sourceRootTypeId) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/DirectoryInfoImpl", "<init>"));
        }
        this.myRoot = root;
        this.module = module2;
        this.libraryClassRoot = libraryClassRoot;
        this.contentRoot = contentRoot;
        this.sourceRoot = sourceRoot;
        this.myInModuleSource = inModuleSource;
        this.myInLibrarySource = inLibrarySource;
        this.myExcluded = isExcluded;
        if (sourceRootTypeId > 127) {
            throw new IllegalArgumentException("Module source root type id " + sourceRootTypeId + " exceeds the maximum allowable value (" + 127 + ")");
        }
        this.mySourceRootTypeId = (byte)sourceRootTypeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myRoot.equals(((DirectoryInfoImpl)o).myRoot);
    }

    public int hashCode() {
        return this.myRoot.hashCode();
    }

    public String toString() {
        return "DirectoryInfo{module=" + this.getModule() + ", isInModuleSource=" + this.isInModuleSource() + ", rootTypeId=" + this.getSourceRootTypeId() + ", isInLibrarySource=" + this.isInLibrarySource() + ", isExcludedFromModule=" + this.isExcluded() + ", libraryClassRoot=" + this.getLibraryClassRoot() + ", contentRoot=" + this.getContentRoot() + ", sourceRoot=" + this.getSourceRoot() + "}";
    }

    @Override
    public boolean isInProject() {
        return !this.isExcluded();
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    @Nullable
    public VirtualFile getSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    public VirtualFile getLibraryClassRoot() {
        return this.libraryClassRoot;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return this.contentRoot;
    }

    @Override
    public boolean isInModuleSource() {
        return this.myInModuleSource;
    }

    @Override
    public boolean isInLibrarySource() {
        return this.myInLibrarySource;
    }

    @Override
    public boolean isExcluded() {
        return this.myExcluded;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public int getSourceRootTypeId() {
        return this.mySourceRootTypeId;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryInfoImpl", "getRoot"));
        }
        return virtualFile;
    }
}

