/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LanguageLevelUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "language-level";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID, 100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LanguageLevelUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/LanguageLevelUsagesCollector", "getProjectUsages"));
        }
        HashSet languageLevels = new HashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            LanguageLevelModuleExtensionImpl instance = LanguageLevelModuleExtensionImpl.getInstance((Module)module2);
            LanguageLevel languageLevel = instance.getLanguageLevel();
            if (languageLevel == null) continue;
            languageLevels.add(languageLevel.toString());
        }
        languageLevels.add(LanguageLevelProjectExtension.getInstance((Project)project2).getLanguageLevel().toString());
        Set set = ContainerUtil.map2Set((Collection)languageLevels, (Function)new Function<String, UsageDescriptor>(){

            public UsageDescriptor fun(String languageLevel) {
                return new UsageDescriptor(languageLevel, 1);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LanguageLevelUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

