/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.LightFilePointer;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryAppearanceServiceImpl
extends OrderEntryAppearanceService {
    private static final Icon EXCLUDE_FOLDER_ICON = IconLoader.getDisabledIcon((Icon)PlatformIcons.FOLDER_ICON);
    private static final String NO_JDK = ProjectBundle.message((String)"jdk.missing.item", (Object[])new Object[0]);

    @NotNull
    public CellAppearanceEx forOrderEntry(Project project2, @NotNull OrderEntry orderEntry, boolean selected) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
        }
        if (orderEntry instanceof JdkOrderEntry) {
            JdkOrderEntry jdkLibraryEntry = (JdkOrderEntry)orderEntry;
            Sdk jdk = jdkLibraryEntry.getJdk();
            if (!orderEntry.isValid()) {
                String oldJdkName = jdkLibraryEntry.getJdkName();
                CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(oldJdkName != null ? oldJdkName : NO_JDK);
                if (cellAppearanceEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
                }
                return cellAppearanceEx;
            }
            CellAppearanceEx cellAppearanceEx = this.forJdk(jdk, false, selected, true);
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
            }
            return cellAppearanceEx;
        }
        if (!orderEntry.isValid()) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
            }
            return cellAppearanceEx;
        }
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (!libraryOrderEntry.isValid()) {
                CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
                if (cellAppearanceEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
                }
                return cellAppearanceEx;
            }
            Library library = libraryOrderEntry.getLibrary();
            assert (library != null) : libraryOrderEntry;
            CellAppearanceEx cellAppearanceEx = this.forLibrary(project2, library, !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty());
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
            }
            return cellAppearanceEx;
        }
        if (orderEntry.isSynthetic()) {
            String presentableName = orderEntry.getPresentableName();
            Icon icon = orderEntry instanceof ModuleSourceOrderEntry ? OrderEntryAppearanceServiceImpl.sourceFolderIcon(false) : null;
            SimpleTextCellAppearance simpleTextCellAppearance = new SimpleTextCellAppearance(presentableName, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
            if (simpleTextCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
            }
            return simpleTextCellAppearance;
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Icon icon = ModuleType.get((Module)((ModuleOrderEntry)orderEntry).getModule()).getIcon();
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)orderEntry.getPresentableName(), (Icon)icon);
            if (simpleTextCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
            }
            return simpleTextCellAppearance;
        }
        CompositeAppearance compositeAppearance = CompositeAppearance.single((String)orderEntry.getPresentableName());
        if (compositeAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forOrderEntry"));
        }
        return compositeAppearance;
    }

    @NotNull
    public CellAppearanceEx forLibrary(Project project2, @NotNull Library library, boolean hasInvalidRoots) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forLibrary"));
        }
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(project2).getContext();
        Icon icon = LibraryPresentationManager.getInstance().getCustomIcon(library, context);
        String name = library.getName();
        if (name != null) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.normalOrRedWaved(name, icon != null ? icon : PlatformIcons.LIBRARY_ICON, hasInvalidRoots);
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forLibrary"));
            }
            return cellAppearanceEx;
        }
        String[] files = library.getUrls(OrderRootType.CLASSES);
        if (files.length == 0) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.invalid((String)ProjectBundle.message((String)"library.empty.library.item", (Object[])new Object[0]), (Icon)PlatformIcons.LIBRARY_ICON);
            if (simpleTextCellAppearance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forLibrary"));
            }
            return simpleTextCellAppearance;
        }
        if (files.length == 1) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.forVirtualFilePointer(new LightFilePointer(files[0]));
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forLibrary"));
            }
            return cellAppearanceEx;
        }
        String url = StringUtil.trimEnd((String)files[0], (String)"!/");
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)PathUtil.getFileName((String)url), (Icon)PlatformIcons.LIBRARY_ICON);
        if (simpleTextCellAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forLibrary"));
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    public CellAppearanceEx forJdk(@Nullable Sdk jdk, boolean isInComboBox, boolean selected, boolean showVersion) {
        String versionString;
        if (jdk == null) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(NO_JDK);
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forJdk"));
            }
            return cellAppearanceEx;
        }
        String name = jdk.getName();
        CompositeAppearance appearance = new CompositeAppearance();
        SdkType sdkType = (SdkType)jdk.getSdkType();
        appearance.setIcon(sdkType.getIcon());
        SimpleTextAttributes attributes = OrderEntryAppearanceServiceImpl.getTextAttributes(sdkType.sdkHasValidPath(jdk), selected);
        CompositeAppearance.DequeEnd ending = appearance.getEnding();
        ending.addText(name, attributes);
        if (showVersion && (versionString = jdk.getVersionString()) != null && !versionString.equals(name)) {
            SimpleTextAttributes textAttributes = isInComboBox && !selected ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, Color.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            ending.addComment(versionString, textAttributes);
        }
        CompositeAppearance compositeAppearance = ending.getAppearance();
        if (compositeAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forJdk"));
        }
        return compositeAppearance;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    @NotNull
    public CellAppearanceEx forContentFolder(@NotNull ContentFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forContentFolder"));
        }
        if (folder instanceof SourceFolder) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.formatRelativePath(folder, PlatformIcons.FOLDER_ICON);
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forContentFolder"));
            }
            return cellAppearanceEx;
        }
        if (folder instanceof ExcludeFolder) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.formatRelativePath(folder, EXCLUDE_FOLDER_ICON);
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forContentFolder"));
            }
            return cellAppearanceEx;
        }
        throw new RuntimeException(folder.getClass().getName());
    }

    @NotNull
    public CellAppearanceEx forModule(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forModule"));
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)module2.getName(), (Icon)ModuleType.get((Module)module2).getIcon());
        if (simpleTextCellAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forModule"));
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    private static Icon sourceFolderIcon(boolean testSource) {
        Icon icon = testSource ? PlatformIcons.TEST_SOURCE_FOLDER : PlatformIcons.SOURCE_FOLDERS_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "sourceFolderIcon"));
        }
        return icon;
    }

    @NotNull
    private static CellAppearanceEx normalOrRedWaved(@NotNull String text, @Nullable Icon icon, boolean waved) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "normalOrRedWaved"));
        }
        SimpleTextCellAppearance simpleTextCellAppearance = waved ? new SimpleTextCellAppearance(text, icon, new SimpleTextAttributes(8, null, (Color)JBColor.RED)) : SimpleTextCellAppearance.regular((String)text, (Icon)icon);
        if (simpleTextCellAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "normalOrRedWaved"));
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    private static CellAppearanceEx forVirtualFilePointer(@NotNull LightFilePointer filePointer) {
        if (filePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forVirtualFilePointer"));
        }
        VirtualFile file2 = filePointer.getFile();
        CellAppearanceEx cellAppearanceEx = file2 != null ? FileAppearanceService.getInstance().forVirtualFile(file2) : FileAppearanceService.getInstance().forInvalidUrl(filePointer.getPresentableUrl());
        if (cellAppearanceEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "forVirtualFilePointer"));
        }
        return cellAppearanceEx;
    }

    @NotNull
    private static CellAppearanceEx formatRelativePath(@NotNull ContentFolder folder, @NotNull Icon icon) {
        SimpleTextAttributes textAttributes;
        String relativePath;
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "formatRelativePath"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "formatRelativePath"));
        }
        LightFilePointer folderFile = new LightFilePointer(folder.getUrl());
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(folder.getContentEntry().getUrl());
        if (file2 == null) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(folderFile.getPresentableUrl());
            if (cellAppearanceEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "formatRelativePath"));
            }
            return cellAppearanceEx;
        }
        String contentPath = file2.getPath();
        VirtualFile folderFileFile = folderFile.getFile();
        if (folderFileFile == null) {
            String absolutePath = folderFile.getPresentableUrl();
            relativePath = absolutePath.startsWith(contentPath) ? absolutePath.substring(contentPath.length()) : absolutePath;
            textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        } else {
            relativePath = VfsUtilCore.getRelativePath((VirtualFile)folderFileFile, (VirtualFile)file2, (char)File.separatorChar);
            textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        relativePath = StringUtil.isEmpty((String)relativePath) ? "." + File.separatorChar : relativePath;
        SimpleTextCellAppearance simpleTextCellAppearance = new SimpleTextCellAppearance(relativePath, icon, textAttributes);
        if (simpleTextCellAppearance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl", "formatRelativePath"));
        }
        return simpleTextCellAppearance;
    }
}

