/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class NewModuleAction
extends AnAction
implements DumbAware {
    public NewModuleAction() {
        super(ProjectBundle.message((String)"module.new.action", (Object[])new Object[0]), ProjectBundle.message((String)"module.new.action.description", (Object[])new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent e) {
        NewProjectWizard wizard;
        Project project2 = NewModuleAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        Object dataFromContext = this.prepareDataFromContext(e);
        String defaultPath = null;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile != null && virtualFile.isDirectory()) {
            defaultPath = virtualFile.getPath();
        }
        if ((wizard = new NewProjectWizard(project2, (ModulesProvider)new DefaultModulesProvider(project2), defaultPath)).showAndGet()) {
            this.createModuleFromWizard(project2, dataFromContext, wizard);
        }
    }

    @Nullable
    public Module createModuleFromWizard(Project project2, @Nullable Object dataFromContext, AbstractProjectWizard wizard) {
        Module module2;
        ProjectBuilder builder = wizard.getProjectBuilder();
        if (builder instanceof ModuleBuilder) {
            ModuleBuilder moduleBuilder = (ModuleBuilder)builder;
            if (moduleBuilder.getName() == null) {
                moduleBuilder.setName(wizard.getProjectName());
            }
            if (moduleBuilder.getModuleFilePath() == null) {
                moduleBuilder.setModuleFilePath(wizard.getModuleFilePath());
            }
        }
        if (!builder.validate(project2, project2)) {
            return null;
        }
        if (builder instanceof ModuleBuilder) {
            module2 = ((ModuleBuilder)builder).commitModule(project2, null);
            if (module2 != null) {
                this.processCreatedModule(module2, dataFromContext);
            }
            return module2;
        }
        List modules = builder.commit(project2, null, (ModulesProvider)new DefaultModulesProvider(project2));
        if (builder.isOpenProjectSettingsAfter()) {
            ModulesConfigurator.showDialog(project2, null, null);
        }
        module2 = modules == null || modules.isEmpty() ? null : (Module)modules.get(0);
        project2.save();
        return module2;
    }

    @Nullable
    protected Object prepareDataFromContext(AnActionEvent e) {
        return null;
    }

    protected void processCreatedModule(Module module2, @Nullable Object dataFromContext) {
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(NewModuleAction.getEventProject((AnActionEvent)e) != null);
    }
}

