/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureProblemDescription {
    private final String myMessage;
    private final String myDescription;
    private final PlaceInProjectStructure myPlace;
    private final List<? extends ConfigurationErrorQuickFix> myFixes;
    private final ProjectStructureProblemType myProblemType;
    private final ProblemLevel myProblemLevel;
    private final boolean myCanShowPlace;

    public ProjectStructureProblemDescription(@NotNull String message, @Nullable String description, @NotNull PlaceInProjectStructure place, @NotNull ProjectStructureProblemType problemType, @NotNull List<? extends ConfigurationErrorQuickFix> fixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (problemType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemType", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        this(message, description, place, problemType, ProblemLevel.PROJECT, fixes, true);
    }

    public ProjectStructureProblemDescription(@NotNull String message, @Nullable String description, @NotNull PlaceInProjectStructure place, @NotNull ProjectStructureProblemType problemType, @NotNull ProblemLevel level, @NotNull List<? extends ConfigurationErrorQuickFix> fixes, boolean canShowPlace) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (problemType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemType", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "<init>"));
        }
        this.myMessage = message;
        this.myDescription = description;
        this.myPlace = place;
        this.myFixes = fixes;
        this.myProblemType = problemType;
        this.myProblemLevel = level;
        this.myCanShowPlace = canShowPlace;
    }

    public ProblemLevel getProblemLevel() {
        return this.myProblemLevel;
    }

    public String getMessage(boolean includePlace) {
        if (includePlace && this.myCanShowPlace) {
            return this.myPlace.getContainingElement().getPresentableText() + ": " + StringUtil.decapitalize((String)this.myMessage);
        }
        return this.myMessage;
    }

    public boolean canShowPlace() {
        return this.myCanShowPlace;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public List<? extends ConfigurationErrorQuickFix> getFixes() {
        return this.myFixes;
    }

    public ProjectStructureProblemType.Severity getSeverity() {
        return this.myProblemType.getSeverity();
    }

    @NotNull
    public PlaceInProjectStructure getPlace() {
        PlaceInProjectStructure placeInProjectStructure = this.myPlace;
        if (placeInProjectStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription", "getPlace"));
        }
        return placeInProjectStructure;
    }

    public String getId() {
        String placePath = this.myPlace.getPlacePath();
        return this.myProblemType.getId() + "(" + this.myPlace.getContainingElement().getId() + (placePath != null ? "," + placePath : "") + ")";
    }

    public static enum ProblemLevel {
        PROJECT,
        GLOBAL;

    }
}

