/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.util.Alarm;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TableViewModel;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanelImpl
extends PanelWithActionsAndCloseButton {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.ui.FileHistoryDialog");
    @NotNull
    private final Project myProject;
    private final JEditorPane myComments;
    private JComponent myAdditionalDetails;
    private Consumer<VcsFileRevision> myListener;
    private String myOriginalComment;
    private final DefaultActionGroup myPopupActions;
    private final AbstractVcs myVcs;
    private final VcsHistoryProvider myProvider;
    private final AnnotationProvider myAnnotationProvider;
    private VcsHistorySession myHistorySession;
    @NotNull
    private final FilePath myFilePath;
    @Nullable
    private final VcsRevisionNumber myStartingRevision;
    @NotNull
    private final FileHistoryRefresherI myRefresherI;
    private VcsFileRevision myBottomRevisionForShowDiff;
    private final DualView myDualView;
    @NotNull
    private final DiffFromHistoryHandler myDiffHandler;
    private final Alarm myUpdateAlarm;
    private volatile boolean myInRefresh;
    private List<Object> myTargetSelection;
    private final AsynchConsumer<VcsHistorySession> myHistoryPanelRefresh;
    private static final String COMMIT_MESSAGE_TITLE = VcsBundle.message((String)"label.selected.revision.commit.message", (Object[])new Object[0]);
    @NonNls
    private static final String VCS_HISTORY_ACTIONS_GROUP = "VcsHistoryActionsGroup";
    private final Map<VcsRevisionNumber, Integer> myRevisionsOrder;
    private final Map<VcsFileRevision, VirtualFile> myRevisionToVirtualFile;
    private boolean myIsStaticAndEmbedded;
    private boolean myColumnSizesSet;
    private final Splitter myDetailsSplitter;
    private Splitter mySplitter;
    private final Comparator<VcsFileRevision> myRevisionsInOrderComparator;

    public void scheduleRefresh(final boolean canUseLastRevision) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FileHistoryPanelImpl.this.refreshImpl(canUseLastRevision);
            }
        });
    }

    @Nullable
    public VcsRevisionNumber getStartingRevision() {
        return this.myStartingRevision;
    }

    public FileHistoryPanelImpl(AbstractVcs vcs, FilePath filePath, VcsHistorySession session, VcsHistoryProvider provider, ContentManager contentManager, FileHistoryRefresherI refresherI) {
        this(vcs, filePath, session, provider, contentManager, refresherI, false);
    }

    public FileHistoryPanelImpl(AbstractVcs vcs, @NotNull FilePath filePath, VcsHistorySession session, VcsHistoryProvider provider, ContentManager contentManager, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "<init>"));
        }
        if (refresherI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresherI", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "<init>"));
        }
        this(vcs, filePath, null, session, provider, contentManager, refresherI, isStaticEmbedded);
    }

    public FileHistoryPanelImpl(AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startingRevision, VcsHistorySession session, VcsHistoryProvider provider, ContentManager contentManager, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "<init>"));
        }
        if (refresherI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresherI", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "<init>"));
        }
        super(contentManager, provider.getHelpId() != null ? provider.getHelpId() : "reference.versionControl.toolwindow.history", !isStaticEmbedded);
        this.myOriginalComment = "";
        this.myRevisionToVirtualFile = new HashMap<VcsFileRevision, VirtualFile>();
        this.myDetailsSplitter = new Splitter(false, 0.5f);
        this.myRevisionsInOrderComparator = new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                return Comparing.compare((Comparable)((Comparable)FileHistoryPanelImpl.this.myRevisionsOrder.get(o2.getRevisionNumber())), (Comparable)((Comparable)FileHistoryPanelImpl.this.myRevisionsOrder.get(o1.getRevisionNumber())));
            }
        };
        this.myProject = vcs.getProject();
        this.myIsStaticAndEmbedded = false;
        this.myVcs = vcs;
        this.myProvider = provider;
        this.myAnnotationProvider = this.myVcs.getCachingAnnotationProvider();
        this.myRefresherI = refresherI;
        this.myHistorySession = session;
        this.myFilePath = filePath;
        this.myStartingRevision = startingRevision;
        DiffFromHistoryHandler customDiffHandler = provider.getHistoryDiffHandler();
        this.myDiffHandler = customDiffHandler == null ? new StandardDiffFromHistoryHandler() : customDiffHandler;
        DualViewColumnInfo[] columns = this.createColumnList(this.myVcs.getProject(), provider, session);
        this.myComments = new JEditorPane("text/html", "");
        this.myComments.setPreferredSize(new Dimension(150, 100));
        this.myComments.setEditable(false);
        this.myComments.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myComments.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myRevisionsOrder = new HashMap<VcsRevisionNumber, Integer>();
        this.refreshRevisionsOrder();
        this.replaceTransferable();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        final HistoryAsTreeProvider treeHistoryProvider = this.myHistorySession.getHistoryAsTreeProvider();
        String storageKey = "FileHistory." + provider.getClass().getName();
        if (treeHistoryProvider != null) {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), columns, storageKey, this.myVcs.getProject());
        } else {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, FileHistoryPanelImpl.wrapWithTreeElements(this.myHistorySession.getRevisionList())), columns, storageKey, this.myVcs.getProject());
            this.myDualView.switchToTheFlatMode();
        }
        new TableSpeedSearch((JTable)this.myDualView.getFlatView()).setComparator(new SpeedSearchComparator(false));
        TableLinkMouseListener listener2 = new TableLinkMouseListener();
        listener2.installOn((Component)this.myDualView.getFlatView());
        listener2.installOn((Component)this.myDualView.getTreeView());
        this.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        this.createDualView();
        if (isStaticEmbedded) {
            this.setIsStaticAndEmbedded(isStaticEmbedded);
        }
        this.myPopupActions = this.createPopupActions();
        this.myHistoryPanelRefresh = new AsynchConsumer<VcsHistorySession>(){

            public void finished() {
                TreeTableView treeView;
                int lastRow;
                if (treeHistoryProvider != null && (lastRow = (treeView = FileHistoryPanelImpl.this.myDualView.getTreeView()).getRowCount() - 1) >= 0) {
                    treeView.scrollRectToVisible(treeView.getCellRect(lastRow, 0, true));
                }
                FileHistoryPanelImpl.this.myInRefresh = false;
                FileHistoryPanelImpl.this.myTargetSelection = null;
                FileHistoryPanelImpl.this.mySplitter.revalidate();
                FileHistoryPanelImpl.this.mySplitter.repaint();
            }

            public void consume(VcsHistorySession vcsHistorySession) {
                FileHistoryPanelImpl.this.refresh(vcsHistorySession);
            }
        };
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (FileHistoryPanelImpl.this.myVcs.getProject().isDisposed()) {
                    return;
                }
                boolean refresh = ApplicationManager.getApplication().isActive() && !FileHistoryPanelImpl.this.myInRefresh && FileHistoryPanelImpl.this.myHistorySession.shouldBeRefreshed();
                FileHistoryPanelImpl.this.myUpdateAlarm.cancelAllRequests();
                if (FileHistoryPanelImpl.this.myUpdateAlarm.isDisposed()) {
                    return;
                }
                FileHistoryPanelImpl.this.myUpdateAlarm.addRequest((Runnable)this, 20000);
                if (refresh) {
                    FileHistoryPanelImpl.this.refreshImpl(true);
                }
            }
        }, 20000);
        this.init();
        this.chooseView();
    }

    private void replaceTransferable() {
        final TransferHandler originalTransferHandler = this.myComments.getTransferHandler();
        TransferHandler newHandler = new TransferHandler("copy"){

            @Override
            public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                originalTransferHandler.exportAsDrag(comp, e, action);
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                if ((action == 1 || action == 2) && (this.getSourceActions(comp) & action) != 0) {
                    String selectedText = FileHistoryPanelImpl.this.myComments.getSelectedText();
                    TextTransferable t = selectedText == null ? new TextTransferable(FileHistoryPanelImpl.this.myComments.getText(), FileHistoryPanelImpl.this.myOriginalComment) : new TextTransferable(selectedText);
                    try {
                        clip.setContents(t, null);
                        this.exportDone(comp, t, action);
                        return;
                    }
                    catch (IllegalStateException ise) {
                        this.exportDone(comp, t, 0);
                        throw ise;
                    }
                }
                this.exportDone(comp, null, 0);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return originalTransferHandler.importData(comp, t);
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return originalTransferHandler.canImport(comp, transferFlavors);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return originalTransferHandler.getSourceActions(c);
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                return originalTransferHandler.getVisualRepresentation(t);
            }
        };
        this.myComments.setTransferHandler(newHandler);
    }

    private DualViewColumnInfo[] createColumnList(Project project2, VcsHistoryProvider provider, VcsHistorySession session) {
        VcsDependentHistoryComponents components = provider.getUICustomization(session, (JComponent)((Object)this));
        this.myAdditionalDetails = components.getDetailsComponent();
        this.myListener = components.getRevisionListener();
        ArrayList<DualViewColumnInfo> columns = new ArrayList<DualViewColumnInfo>();
        columns.add(new RevisionColumnInfo(this.myRevisionsInOrderComparator));
        if (!provider.isDateOmittable()) {
            columns.add(new DateColumnInfo());
        }
        columns.add(new AuthorColumnInfo());
        columns.addAll(this.wrapAdditionalColumns(components.getColumns()));
        columns.add(new MessageColumnInfo(project2));
        return columns.toArray(new DualViewColumnInfo[columns.size()]);
    }

    private Collection<DualViewColumnInfo> wrapAdditionalColumns(ColumnInfo[] additionalColumns) {
        ArrayList<DualViewColumnInfo> result = new ArrayList<DualViewColumnInfo>();
        if (additionalColumns != null) {
            for (ColumnInfo additionalColumn : additionalColumns) {
                result.add(new MyColumnWrapper(additionalColumn));
            }
        }
        return result;
    }

    private static List<TreeItem<VcsFileRevision>> wrapWithTreeElements(List<VcsFileRevision> revisions) {
        ArrayList<TreeItem<VcsFileRevision>> result = new ArrayList<TreeItem<VcsFileRevision>>();
        for (VcsFileRevision revision : revisions) {
            result.add((TreeItem<VcsFileRevision>)new TreeItem((Object)revision));
        }
        return result;
    }

    private void refresh(VcsHistorySession session) {
        this.myHistorySession = session;
        this.refreshRevisionsOrder();
        HistoryAsTreeProvider treeHistoryProvider = session.getHistoryAsTreeProvider();
        if (this.myHistorySession.getRevisionList().isEmpty()) {
            this.adjustEmptyText();
        }
        if (treeHistoryProvider != null) {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), this.myTargetSelection);
        } else {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, FileHistoryPanelImpl.wrapWithTreeElements(this.myHistorySession.getRevisionList())), this.myTargetSelection);
        }
        this.columnSizesOnce();
        this.myDualView.expandAll();
        this.myDualView.repaint();
    }

    private void columnSizesOnce() {
        if (!this.myColumnSizesSet) {
            this.myDualView.getFlatView().updateColumnSizes();
            this.myColumnSizesSet = true;
        }
    }

    private void adjustEmptyText() {
        VirtualFile virtualFile = this.myFilePath.getVirtualFile();
        if (!(virtualFile != null && virtualFile.isValid() || this.myFilePath.getIOFile().exists())) {
            this.setEmptyText("File " + this.myFilePath.getName() + " not found");
        } else if (this.myInRefresh) {
            this.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        } else {
            this.setEmptyText(StatusText.DEFAULT_EMPTY_TEXT);
        }
    }

    private void setEmptyText(@NotNull String emptyText) {
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "setEmptyText"));
        }
        this.myDualView.setEmptyText(emptyText);
    }

    protected void addActionsTo(DefaultActionGroup group) {
        this.addToGroup(false, group);
    }

    private void createDualView() {
        this.myDualView.setShowGrid(true);
        this.myDualView.getTreeView().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)FileHistoryPanelImpl.this.myPopupActions);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        this.myDualView.getFlatView().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)FileHistoryPanelImpl.this.myPopupActions);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        this.myDualView.requestFocus();
        this.myDualView.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileHistoryPanelImpl.this.updateMessage();
            }
        });
        this.myDualView.setRootVisible(false);
        this.myDualView.expandAll();
        TreeCellRenderer defaultCellRenderer = this.myDualView.getTree().getCellRenderer();
        Getter<VcsHistorySession> sessionGetter = new Getter<VcsHistorySession>(){

            public VcsHistorySession get() {
                return FileHistoryPanelImpl.this.myHistorySession;
            }
        };
        this.myDualView.setTreeCellRenderer((TreeCellRenderer)new MyTreeCellRenderer(defaultCellRenderer, sessionGetter));
        this.myDualView.setCellWrapper((CellWrapper)new MyCellWrapper(sessionGetter));
        this.myDualView.installDoubleClickHandler((AnAction)new MyDiffAction());
        TableView flatView = this.myDualView.getFlatView();
        TableViewModel sortableModel = flatView.getTableViewModel();
        sortableModel.setSortable(true);
        RowSorter rowSorter = flatView.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        }
    }

    private static void makeBold(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Font font = jComponent.getFont();
            if (font != null) {
                jComponent.setFont(font.deriveFont(1));
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FileHistoryPanelImpl.makeBold(container.getComponent(i));
            }
        }
    }

    private void updateMessage() {
        VcsFileRevision revision;
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        if (selection.size() != 1) {
            revision = null;
            this.myComments.setText("");
            this.myOriginalComment = "";
        } else {
            revision = this.getFirstSelectedRevision();
            if (revision != null) {
                String message;
                this.myOriginalComment = message = revision.getCommitMessage();
                String text = IssueLinkHtmlRenderer.formatTextIntoHtml(this.myVcs.getProject(), message);
                this.myComments.setText(text);
                this.myComments.setCaretPosition(0);
            }
        }
        if (this.myListener != null) {
            this.myListener.consume((Object)revision);
        }
    }

    protected JComponent createCenterPanel() {
        this.mySplitter = new Splitter(true, this.getSplitterProportion());
        this.mySplitter.setDividerWidth(4);
        this.mySplitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    FileHistoryPanelImpl.this.setSplitterProportionTo((Float)evt.getNewValue());
                }
            }
        });
        JPanel commentGroup = new JPanel(new BorderLayout());
        JLabel commentLabel = new JLabel(COMMIT_MESSAGE_TITLE + ":");
        commentGroup.add((Component)commentLabel, "North");
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myComments);
        pane.setBorder(IdeBorderFactory.createBorder((int)(3 | (this.myAdditionalDetails == null ? 0 : 4))));
        commentGroup.add((Component)pane, "Center");
        this.myDetailsSplitter.setFirstComponent((JComponent)commentGroup);
        this.myDetailsSplitter.setSecondComponent(this.myAdditionalDetails);
        this.mySplitter.setFirstComponent((JComponent)this.myDualView);
        this.setupDetails();
        return this.mySplitter;
    }

    private void setupDetails() {
        boolean showDetails;
        boolean bl = showDetails = !this.myIsStaticAndEmbedded && this.getConfiguration().SHOW_FILE_HISTORY_DETAILS;
        if (showDetails) {
            this.myDualView.setViewBorder(IdeBorderFactory.createBorder((int)9));
        } else {
            this.myDualView.setViewBorder(IdeBorderFactory.createBorder((int)1));
        }
        this.mySplitter.setSecondComponent((JComponent)(showDetails ? this.myDetailsSplitter : null));
    }

    private void chooseView() {
        if (this.showTree()) {
            this.myDualView.switchToTheTreeMode();
        } else {
            this.myDualView.switchToTheFlatMode();
        }
    }

    private boolean showTree() {
        return this.getConfiguration().SHOW_FILE_HISTORY_AS_TREE;
    }

    private void setSplitterProportionTo(Float newProportion) {
        this.getConfiguration().FILE_HISTORY_SPLITTER_PROPORTION = newProportion.floatValue();
    }

    protected float getSplitterProportion() {
        return this.getConfiguration().FILE_HISTORY_SPLITTER_PROPORTION;
    }

    private VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance((Project)this.myVcs.getProject());
    }

    private DefaultActionGroup createPopupActions() {
        return this.addToGroup(true, new DefaultActionGroup(null, false));
    }

    private DefaultActionGroup addToGroup(boolean popup, DefaultActionGroup result) {
        if (popup) {
            result.add(ActionManager.getInstance().getAction("EditSource"));
        }
        MyDiffAction diffAction = new MyDiffAction();
        diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), null);
        result.add((AnAction)diffAction);
        result.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        AnAction diffGroup = ActionManager.getInstance().getAction(VCS_HISTORY_ACTIONS_GROUP);
        if (diffGroup != null) {
            result.add(diffGroup);
        }
        result.add((AnAction)new MyCreatePatch());
        result.add((AnAction)new MyGetVersionAction());
        result.add((AnAction)new MyAnnotateAction());
        AnAction[] additionalActions = this.myProvider.getAdditionalActions(new Runnable(){

            @Override
            public void run() {
                FileHistoryPanelImpl.this.refreshImpl(true);
            }
        });
        if (additionalActions != null) {
            for (AnAction additionalAction : additionalActions) {
                if (!popup && additionalAction.getTemplatePresentation().getIcon() == null) continue;
                result.add(additionalAction);
            }
        }
        result.add((AnAction)new RefreshFileHistoryAction());
        if (!this.myIsStaticAndEmbedded) {
            result.add((AnAction)new MyToggleAction());
        }
        if (!popup && this.supportsTree()) {
            result.add((AnAction)new MyShowAsTreeAction());
        }
        return result;
    }

    private void refreshImpl(final boolean useLastRevision) {
        new AbstractCalledLater(this.myVcs.getProject(), ModalityState.NON_MODAL){

            @Override
            public void run() {
                if (FileHistoryPanelImpl.this.myInRefresh) {
                    return;
                }
                FileHistoryPanelImpl.this.myInRefresh = true;
                FileHistoryPanelImpl.this.myTargetSelection = FileHistoryPanelImpl.this.myDualView.getFlatView().getSelectedObjects();
                FileHistoryPanelImpl.this.mySplitter.revalidate();
                FileHistoryPanelImpl.this.mySplitter.repaint();
                FileHistoryPanelImpl.this.myRefresherI.run(true, useLastRevision);
                FileHistoryPanelImpl.this.columnSizesOnce();
            }
        }.callMe();
    }

    public AsynchConsumer<VcsHistorySession> getHistoryPanelRefresh() {
        return this.myHistoryPanelRefresh;
    }

    private boolean supportsTree() {
        return this.myHistorySession != null && this.myHistorySession.getHistoryAsTreeProvider() != null;
    }

    public Object getData(String dataId) {
        VcsFileRevision firstSelectedRevision = this.getFirstSelectedRevision();
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            List<TreeNodeOnVcsRevision> selectedItems = this.getSelection();
            if (selectedItems.size() != 1) {
                return null;
            }
            if (!this.myHistorySession.isContentAvailable(firstSelectedRevision)) {
                return null;
            }
            VirtualFile virtualFileForRevision = this.createVirtualFileForRevision(firstSelectedRevision);
            if (virtualFileForRevision != null) {
                return new OpenFileDescriptor(this.myVcs.getProject(), virtualFileForRevision);
            }
            return null;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myVcs.getProject();
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return firstSelectedRevision;
        }
        if (VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION.is(dataId) && this.myHistorySession != null) {
            return !this.myHistorySession.hasLocalSource();
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myVcs.getKeyInstanceMethod();
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            return this.getSelectedRevisions();
        }
        if (VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER.is(dataId)) {
            return new Consumer<String>(){

                public void consume(String s) {
                    FileHistoryPanelImpl.this.myDualView.rebuild();
                }
            };
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getChanges();
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            if (firstSelectedRevision == null) {
                return null;
            }
            return this.createVirtualFileForRevision(firstSelectedRevision);
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.IO_FILE.is(dataId)) {
            return this.myFilePath.getIOFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFile virtualFile = this.getVirtualFile();
            return virtualFile == null || !virtualFile.isValid() ? null : virtualFile;
        }
        if (VcsDataKeys.FILE_HISTORY_PANEL.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.HISTORY_SESSION.is(dataId)) {
            return this.myHistorySession;
        }
        if (VcsDataKeys.HISTORY_PROVIDER.is(dataId)) {
            return this.myProvider;
        }
        return super.getData(dataId);
    }

    @Nullable
    private Change[] getChanges() {
        VcsFileRevision[] revisions = this.getSelectedRevisions();
        if (revisions.length > 0) {
            Arrays.sort(revisions, new Comparator<VcsFileRevision>(){

                @Override
                public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                    return o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
                }
            });
            for (VcsFileRevision revision : revisions) {
                if (this.myHistorySession.isContentAvailable(revision)) continue;
                return null;
            }
            LoadedContentRevision startRevision = new LoadedContentRevision(this.myFilePath, revisions[0], this.myVcs.getProject());
            Object endRevision = revisions.length == 1 ? new CurrentContentRevision(this.myFilePath) : new LoadedContentRevision(this.myFilePath, revisions[revisions.length - 1], this.myVcs.getProject());
            return new Change[]{new Change((ContentRevision)startRevision, (ContentRevision)endRevision)};
        }
        return null;
    }

    private VirtualFile createVirtualFileForRevision(VcsFileRevision revision) {
        if (!this.myRevisionToVirtualFile.containsKey(revision)) {
            FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : this.myFilePath;
            this.myRevisionToVirtualFile.put(revision, (VirtualFile)(filePath.isDirectory() ? new VcsVirtualFolder(filePath.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance())));
        }
        return this.myRevisionToVirtualFile.get(revision);
    }

    private List<TreeNodeOnVcsRevision> getSelection() {
        return this.myDualView.getSelection();
    }

    @Nullable
    private VcsFileRevision getFirstSelectedRevision() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0).myRevision;
    }

    public VcsFileRevision[] getSelectedRevisions() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        VcsFileRevision[] result = new VcsFileRevision[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            result[i] = selection.get(i).myRevision;
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        this.myDualView.dispose();
        this.myUpdateAlarm.dispose();
    }

    @NotNull
    public FileHistoryRefresherI getRefresher() {
        FileHistoryRefresherI fileHistoryRefresherI = this.myRefresherI;
        if (fileHistoryRefresherI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "getRefresher"));
        }
        return fileHistoryRefresherI;
    }

    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "getFilePath"));
        }
        return filePath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFilePath.getVirtualFile();
    }

    private VirtualFile getVirtualParent() {
        return this.myFilePath.getVirtualFileParent();
    }

    private String getMaxValue(String name) {
        TableColumn column;
        if (this.myDualView == null) {
            return null;
        }
        TableView table = this.myDualView.getFlatView();
        if (table.getRowCount() == 0) {
            return null;
        }
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        int idx = 0;
        while (columns.hasMoreElements() && !name.equals((column = columns.nextElement()).getHeaderValue())) {
            ++idx;
        }
        if (idx >= table.getColumnModel().getColumnCount() - 1) {
            return null;
        }
        FontMetrics fm = table.getFontMetrics(table.getFont().deriveFont(1));
        Object header = table.getColumnModel().getColumn(idx).getHeaderValue();
        double maxValue = fm.stringWidth((String)header);
        String value = (String)header;
        for (int i = 0; i < table.getRowCount(); ++i) {
            int newWidth;
            Object at = table.getValueAt(i, idx);
            if (!(at instanceof String) || !((double)(newWidth = fm.stringWidth((String)at)) > maxValue)) continue;
            maxValue = newWidth;
            value = (String)at;
        }
        return value + "ww";
    }

    private void refreshRevisionsOrder() {
        List list = this.myHistorySession.getRevisionList();
        this.myRevisionsOrder.clear();
        int cnt = 0;
        for (VcsFileRevision revision : list) {
            this.myRevisionsOrder.put(revision.getRevisionNumber(), cnt);
            ++cnt;
        }
    }

    public void setIsStaticAndEmbedded(boolean isStaticAndEmbedded) {
        this.myIsStaticAndEmbedded = isStaticAndEmbedded;
        this.myDualView.setZipByHeight(isStaticAndEmbedded);
        this.myDualView.getFlatView().updateColumnSizes();
        if (this.myIsStaticAndEmbedded) {
            this.disableClose();
            this.myDualView.getFlatView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getTreeView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getFlatView().setBorder(null);
            this.myDualView.getTreeView().setBorder(null);
        }
    }

    public void setBottomRevisionForShowDiff(VcsFileRevision bottomRevisionForShowDiff) {
        this.myBottomRevisionForShowDiff = bottomRevisionForShowDiff;
    }

    public boolean equals(Object obj) {
        return obj instanceof FileHistoryPanelImpl && FileHistoryPanelImpl.sameHistories((FileHistoryPanelImpl)((Object)obj), this.myFilePath, this.myStartingRevision);
    }

    public int hashCode() {
        int result = this.myFilePath.hashCode();
        result = 31 * result + (this.myStartingRevision != null ? this.myStartingRevision.asString().hashCode() : 0);
        return result;
    }

    static boolean sameHistories(@NotNull FileHistoryPanelImpl historyPanel, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber) {
        if (historyPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyPanel", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "sameHistories"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl", "sameHistories"));
        }
        String existingRevision = historyPanel.getStartingRevision() == null ? null : historyPanel.getStartingRevision().asString();
        String newRevision = startingRevisionNumber == null ? null : startingRevisionNumber.asString();
        return historyPanel.getFilePath().equals(path) && Comparing.equal((String)existingRevision, (String)newRevision);
    }

    private class MyToggleAction
    extends ToggleAction
    implements DumbAware {
        public MyToggleAction() {
            super("Show Details", "Display details panel", AllIcons.Actions.Preview);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_DETAILS;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_DETAILS = state;
            FileHistoryPanelImpl.this.setupDetails();
        }
    }

    public class MyCreatePatch
    extends DumbAwareAction {
        private final CreatePatchFromChangesAction myUsualDelegate;

        public MyCreatePatch() {
            super(VcsBundle.message((String)"action.name.create.patch.for.selected.revisions", (Object[])new Object[0]), VcsBundle.message((String)"action.description.create.patch.for.selected.revisions", (Object[])new Object[0]), AllIcons.Actions.CreatePatch);
            this.myUsualDelegate = new CreatePatchFromChangesAction();
        }

        public void actionPerformed(AnActionEvent e) {
            if (FileHistoryPanelImpl.this.myFilePath.isDirectory()) {
                List selection = FileHistoryPanelImpl.this.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new FolderPatchCreationTask(FileHistoryPanelImpl.this.myVcs, (TreeNodeOnVcsRevision)selection.get(0)));
            } else {
                this.myUsualDelegate.actionPerformed(e);
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(true);
            if (FileHistoryPanelImpl.this.myFilePath.isNonLocal()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            boolean enabled = !FileHistoryPanelImpl.this.myFilePath.isDirectory() || FileHistoryPanelImpl.this.myProvider.supportsHistoryForDirectories();
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            if (enabled && !FileHistoryPanelImpl.this.myFilePath.isDirectory()) {
                enabled = selectionSize > 0 && selectionSize < 3;
            } else if (enabled) {
                enabled = selectionSize == 1 && ((TreeNodeOnVcsRevision)FileHistoryPanelImpl.this.getSelection().get(0)).getChangedRepositoryPath() != null;
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private static class FolderPatchCreationTask
    extends Task.Backgroundable {
        @Nullable
        private final AbstractVcs myVcs;
        private final TreeNodeOnVcsRevision myRevision;
        private CommittedChangeList myList;
        private VcsException myException;

        private FolderPatchCreationTask(@Nullable AbstractVcs vcs, TreeNodeOnVcsRevision revision) {
            super(vcs.getProject(), VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true);
            this.myVcs = vcs;
            this.myRevision = revision;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$FolderPatchCreationTask", "run"));
            }
            CommittedChangesProvider provider = this.myVcs.getCommittedChangesProvider();
            if (provider == null) {
                return;
            }
            RepositoryLocation changedRepositoryPath = this.myRevision.getChangedRepositoryPath();
            if (changedRepositoryPath == null) {
                return;
            }
            VcsVirtualFile vf = new VcsVirtualFile(changedRepositoryPath.toPresentableString(), this.myRevision.getRevision(), (VirtualFileSystem)VcsFileSystem.getInstance());
            try {
                this.myList = AbstractVcsHelperImpl.getRemoteList(this.myVcs, this.myRevision.getRevisionNumber(), (VirtualFile)vf);
            }
            catch (VcsException e1) {
                this.myException = e1;
            }
        }

        public void onSuccess() {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (this.myException != null) {
                helper.showError(this.myException, VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{this.myException.getMessage()}));
            } else {
                if (this.myList == null) {
                    helper.showError(this.myException, "Can not load changelist contents");
                    return;
                }
                CreatePatchFromChangesAction.createPatch(this.myProject, this.myList.getComment(), new ArrayList<Change>(this.myList.getChanges()));
            }
        }
    }

    private class RefreshFileHistoryAction
    extends RefreshAction
    implements DumbAware {
        public RefreshFileHistoryAction() {
            super(VcsBundle.message((String)"action.name.refresh", (Object[])new Object[0]), VcsBundle.message((String)"action.desctiption.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.registerShortcutOn((JComponent)((Object)FileHistoryPanelImpl.this));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            if (FileHistoryPanelImpl.this.myInRefresh) {
                return;
            }
            FileHistoryPanelImpl.this.refreshImpl(false);
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!FileHistoryPanelImpl.this.myInRefresh);
        }
    }

    private static class MyCellWrapper
    implements CellWrapper {
        private final Getter<VcsHistorySession> myHistorySession;

        public MyCellWrapper(Getter<VcsHistorySession> historySession) {
            this.myHistorySession = historySession;
        }

        public void wrap(Component component, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, Object treeNode) {
            VcsFileRevision revision = (VcsFileRevision)treeNode;
            if (revision == null) {
                return;
            }
            if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                FileHistoryPanelImpl.makeBold(component);
            }
        }
    }

    private class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myDefaultCellRenderer;
        private final Getter<VcsHistorySession> myHistorySession;

        public MyTreeCellRenderer(TreeCellRenderer defaultCellRenderer, Getter<VcsHistorySession> historySession) {
            this.myDefaultCellRenderer = defaultCellRenderer;
            this.myHistorySession = historySession;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            VcsFileRevision revision;
            Component result = this.myDefaultCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path == null) {
                return result;
            }
            VcsFileRevision vcsFileRevision = revision = row >= 0 ? (VcsFileRevision)path.getLastPathComponent() : null;
            if (revision != null) {
                if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                    FileHistoryPanelImpl.makeBold(result);
                }
                if (!selected && ((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                    result.setBackground(new Color(188, 227, 231));
                }
                ((JComponent)result).setOpaque(false);
            } else if (selected) {
                result.setBackground(UIUtil.getTableSelectionBackground());
            } else {
                result.setBackground(UIUtil.getTableBackground());
            }
            return result;
        }
    }

    private class MyColumnWrapper<T>
    extends DualViewColumnInfo<TreeNodeOnVcsRevision, Object> {
        private final ColumnInfo<VcsFileRevision, T> myBaseColumn;

        public Comparator<TreeNodeOnVcsRevision> getComparator() {
            final Comparator comparator2 = this.myBaseColumn.getComparator();
            if (comparator2 == null) {
                return null;
            }
            return new Comparator<TreeNodeOnVcsRevision>(){

                @Override
                public int compare(TreeNodeOnVcsRevision o1, TreeNodeOnVcsRevision o2) {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    VcsFileRevision revision1 = o1.myRevision;
                    VcsFileRevision revision2 = o2.myRevision;
                    if (revision1 == null) {
                        return -1;
                    }
                    if (revision2 == null) {
                        return 1;
                    }
                    return comparator2.compare(revision1, revision2);
                }
            };
        }

        public String getName() {
            return this.myBaseColumn.getName();
        }

        public Class getColumnClass() {
            return this.myBaseColumn.getColumnClass();
        }

        public boolean isCellEditable(TreeNodeOnVcsRevision o) {
            return this.myBaseColumn.isCellEditable((Object)o.myRevision);
        }

        public void setValue(TreeNodeOnVcsRevision o, Object aValue) {
            this.myBaseColumn.setValue((Object)o.myRevision, aValue);
        }

        public TableCellRenderer getRenderer(TreeNodeOnVcsRevision p0) {
            return this.myBaseColumn.getRenderer((Object)p0.myRevision);
        }

        public TableCellEditor getEditor(TreeNodeOnVcsRevision item) {
            return this.myBaseColumn.getEditor((Object)item.myRevision);
        }

        public String getMaxStringValue() {
            String superValue = this.myBaseColumn.getMaxStringValue();
            if (superValue != null) {
                return superValue;
            }
            return FileHistoryPanelImpl.this.getMaxValue(this.myBaseColumn.getName());
        }

        public int getAdditionalWidth() {
            return this.myBaseColumn.getAdditionalWidth();
        }

        public int getWidth(JTable table) {
            return this.myBaseColumn.getWidth(table);
        }

        public void setName(String s) {
            this.myBaseColumn.setName(s);
        }

        public MyColumnWrapper(ColumnInfo<VcsFileRevision, T> additionalColunm) {
            super(additionalColunm.getName());
            this.myBaseColumn = additionalColunm;
        }

        public boolean shouldBeShownIsTheTree() {
            return true;
        }

        public boolean shouldBeShownIsTheTable() {
            return true;
        }

        public Object valueOf(TreeNodeOnVcsRevision o) {
            return this.myBaseColumn.valueOf((Object)o.myRevision);
        }
    }

    static abstract class VcsColumnInfo<T extends Comparable>
    extends DualViewColumnInfo<VcsFileRevision, String>
    implements Comparator<VcsFileRevision> {
        public VcsColumnInfo(String name) {
            super(name);
        }

        protected abstract T getDataOf(VcsFileRevision var1);

        public Comparator<VcsFileRevision> getComparator() {
            return this;
        }

        public String valueOf(VcsFileRevision object) {
            T result = this.getDataOf(object);
            return result == null ? "" : result.toString();
        }

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return VcsColumnInfo.compareObjects(this.getDataOf(o1), this.getDataOf(o2));
        }

        private static int compareObjects(Comparable data1, Comparable data2) {
            if (data1 == data2) {
                return 0;
            }
            if (data1 == null) {
                return -1;
            }
            if (data2 == null) {
                return 1;
            }
            return data1.compareTo(data2);
        }

        public boolean shouldBeShownIsTheTree() {
            return true;
        }

        public boolean shouldBeShownIsTheTable() {
            return true;
        }
    }

    abstract class AbstractActionForSomeSelection
    extends AnAction
    implements DumbAware {
        private final int mySuitableSelectedElements;
        private final FileHistoryPanelImpl mySelectionProvider;

        public AbstractActionForSomeSelection(String name, @NonNls String description, String iconName, int suitableSelectionSize, FileHistoryPanelImpl tableProvider) {
            super(name, description, IconLoader.getIcon((String)("/actions/" + iconName + ".png")));
            this.mySuitableSelectedElements = suitableSelectionSize;
            this.mySelectionProvider = tableProvider;
        }

        protected abstract void executeAction(AnActionEvent var1);

        public boolean isEnabled() {
            return this.mySelectionProvider.getSelection().size() == this.mySuitableSelectedElements;
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.executeAction(e);
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setVisible(true);
            presentation.setEnabled(this.isEnabled());
        }
    }

    static class TreeNodeOnVcsRevision
    extends DefaultMutableTreeNode
    implements VcsFileRevision,
    DualTreeElement {
        private final VcsFileRevision myRevision;

        public TreeNodeOnVcsRevision(VcsFileRevision revision, List<TreeItem<VcsFileRevision>> roots) {
            this.myRevision = revision == null ? VcsFileRevision.NULL : revision;
            for (TreeItem<VcsFileRevision> root : roots) {
                this.add(new TreeNodeOnVcsRevision((VcsFileRevision)root.getData(), root.getChildren()));
            }
        }

        @Nullable
        public RepositoryLocation getChangedRepositoryPath() {
            return this.myRevision.getChangedRepositoryPath();
        }

        public VcsFileRevision getRevision() {
            return this.myRevision;
        }

        public String getAuthor() {
            return this.myRevision.getAuthor();
        }

        public String getCommitMessage() {
            return this.myRevision.getCommitMessage();
        }

        public byte[] loadContent() throws IOException, VcsException {
            return this.myRevision.loadContent();
        }

        public VcsRevisionNumber getRevisionNumber() {
            return this.myRevision.getRevisionNumber();
        }

        public Date getRevisionDate() {
            return this.myRevision.getRevisionDate();
        }

        public String getBranchName() {
            return this.myRevision.getBranchName();
        }

        public byte[] getContent() throws IOException, VcsException {
            return this.myRevision.getContent();
        }

        @Override
        public String toString() {
            return this.getRevisionNumber().asString();
        }

        public boolean shouldBeInTheFlatView() {
            return this.myRevision != VcsFileRevision.NULL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeNodeOnVcsRevision that = (TreeNodeOnVcsRevision)o;
            return !(this.myRevision != null ? !this.myRevision.getRevisionNumber().equals(that.myRevision.getRevisionNumber()) : that.myRevision != null);
        }

        public int hashCode() {
            return this.myRevision != null ? this.myRevision.getRevisionNumber().hashCode() : 0;
        }
    }

    private static class LoadedContentRevision
    implements ByteBackedContentRevision {
        private final FilePath myFile;
        private final VcsFileRevision myRevision;
        private final Project myProject;

        private LoadedContentRevision(FilePath file2, VcsFileRevision revision, Project project2) {
            this.myFile = file2;
            this.myRevision = revision;
            this.myProject = project2;
        }

        public String getContent() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContentGuessEncoding(this.myRevision, this.myFile.getVirtualFile(), this.myProject);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @Nullable
        public byte[] getContentAsBytes() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myFile;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$LoadedContentRevision", "getFile"));
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$LoadedContentRevision", "getRevisionNumber"));
            }
            return vcsRevisionNumber;
        }
    }

    private class MyAnnotateAction
    extends AnnotateRevisionActionBase
    implements DumbAware {
        public MyAnnotateAction() {
            super(VcsBundle.message((String)"annotate.action.name", (Object[])new Object[0]), VcsBundle.message((String)"annotate.action.description", (Object[])new Object[0]), AllIcons.Actions.Annotate);
            this.setShortcutSet(ActionManager.getInstance().getAction("Annotate").getShortcutSet());
        }

        @Override
        @Nullable
        protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyAnnotateAction", "getVcs"));
            }
            return FileHistoryPanelImpl.this.myVcs;
        }

        @Override
        @Nullable
        protected VirtualFile getFile(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyAnnotateAction", "getFile"));
            }
            Boolean nonLocal = (Boolean)e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
            if (Boolean.TRUE.equals(nonLocal)) {
                return null;
            }
            VirtualFile file2 = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
            if (file2 == null || file2.isDirectory()) {
                return null;
            }
            if (FileHistoryPanelImpl.this.myFilePath.getFileType().isBinary()) {
                return null;
            }
            return file2;
        }

        @Override
        @Nullable
        protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyAnnotateAction", "getFileRevision"));
            }
            VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
            if (!FileHistoryPanelImpl.this.myHistorySession.isContentAvailable(revision)) {
                return null;
            }
            return revision;
        }
    }

    private class MyGetVersionAction
    extends AbstractActionForSomeSelection {
        public MyGetVersionAction() {
            super(VcsBundle.message((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.message((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), "get", 1, FileHistoryPanelImpl.this);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && FileHistoryPanelImpl.this.getVirtualParent() != null && FileHistoryPanelImpl.this.myHistorySession.isContentAvailable(FileHistoryPanelImpl.this.getFirstSelectedRevision()) && !FileHistoryPanelImpl.this.myFilePath.isDirectory();
        }

        @Override
        protected void executeAction(AnActionEvent e) {
            if (ChangeListManager.getInstance((Project)FileHistoryPanelImpl.this.myVcs.getProject()).isFreezedWithNotification(null)) {
                return;
            }
            VcsFileRevision revision = FileHistoryPanelImpl.this.getFirstSelectedRevision();
            VirtualFile virtualFile = FileHistoryPanelImpl.this.getVirtualFile();
            if (virtualFile != null && !new ReplaceFileConfirmationDialog(FileHistoryPanelImpl.this.myVcs.getProject(), VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0])).confirmFor(new VirtualFile[]{virtualFile})) {
                return;
            }
            this.getVersion(revision);
            this.refreshFile(revision);
        }

        private void refreshFile(VcsFileRevision revision) {
            Runnable refresh = null;
            final VirtualFile vf = FileHistoryPanelImpl.this.getVirtualFile();
            if (vf == null) {
                final LocalHistoryAction action = this.startLocalHistoryAction(revision);
                final VirtualFile vp = FileHistoryPanelImpl.this.getVirtualParent();
                if (vp != null) {
                    refresh = new Runnable(){

                        @Override
                        public void run() {
                            vp.refresh(false, true, new Runnable(){

                                @Override
                                public void run() {
                                    action.finish();
                                }
                            });
                        }
                    };
                }
            } else {
                refresh = new Runnable(){

                    @Override
                    public void run() {
                        vf.refresh(false, false);
                    }
                };
            }
            if (refresh != null) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(refresh, "Refreshing files...", false, FileHistoryPanelImpl.this.myVcs.getProject());
            }
        }

        private void getVersion(final VcsFileRevision revision) {
            final VirtualFile file2 = FileHistoryPanelImpl.this.getVirtualFile();
            final Project project2 = FileHistoryPanelImpl.this.myVcs.getProject();
            new Task.Backgroundable(project2, VcsBundle.message((String)"show.diff.progress.title", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    byte[] revisionContent;
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyGetVersionAction$3", "run"));
                    }
                    final LocalHistoryAction action = file2 != null ? MyGetVersionAction.this.startLocalHistoryAction(revision) : LocalHistoryAction.NULL;
                    try {
                        revisionContent = VcsHistoryUtil.loadRevisionContent(revision);
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                            }
                        });
                        return;
                    }
                    catch (VcsException e) {
                        LOG.info((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                            }
                        });
                        return;
                    }
                    catch (ProcessCanceledException ex) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                new WriteCommandAction.Simple(project2, new PsiFile[0]){

                                    protected void run() throws Throwable {
                                        if (file2 != null && !file2.isWritable() && ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(new VirtualFile[]{file2}).hasReadonlyFiles()) {
                                            return;
                                        }
                                        try {
                                            MyGetVersionAction.this.write(revisionContent);
                                        }
                                        catch (IOException e) {
                                            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                                        }
                                    }
                                }.execute();
                                if (file2 != null) {
                                    VcsDirtyScopeManager.getInstance((Project)project2).fileDirty(file2);
                                }
                            }
                            finally {
                                action.finish();
                            }
                        }
                    });
                }
            }.queue();
        }

        private LocalHistoryAction startLocalHistoryAction(VcsFileRevision revision) {
            return LocalHistory.getInstance().startAction(this.createGetActionTitle(revision));
        }

        private String createGetActionTitle(VcsFileRevision revision) {
            return VcsBundle.message((String)"action.name.for.file.get.version", (Object[])new Object[]{this.getIOFile().getAbsolutePath(), revision.getRevisionNumber()});
        }

        private File getIOFile() {
            return FileHistoryPanelImpl.this.myFilePath.getIOFile();
        }

        private void write(byte[] revision) throws IOException {
            VirtualFile virtualFile = FileHistoryPanelImpl.this.getVirtualFile();
            if (virtualFile == null) {
                this.writeContentToIOFile(revision);
            } else {
                Document document = null;
                if (!virtualFile.getFileType().isBinary()) {
                    document = FileDocumentManager.getInstance().getDocument(virtualFile);
                }
                if (document == null) {
                    virtualFile.setBinaryContent(revision);
                } else {
                    this.writeContentToDocument(document, revision);
                }
            }
        }

        private void writeContentToIOFile(byte[] revisionContent) throws IOException {
            FileUtil.writeToFile((File)this.getIOFile(), (byte[])revisionContent);
        }

        private void writeContentToDocument(final Document document, byte[] revisionContent) throws IOException {
            final String content = StringUtil.convertLineSeparators((String)new String(revisionContent, FileHistoryPanelImpl.this.myFilePath.getCharset().name()));
            CommandProcessor.getInstance().executeCommand(FileHistoryPanelImpl.this.myVcs.getProject(), new Runnable(){

                @Override
                public void run() {
                    document.replaceString(0, document.getTextLength(), (CharSequence)content);
                }
            }, VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), null);
        }
    }

    private class MyDiffAction
    extends AbstractActionForSomeSelection {
        public MyDiffAction() {
            super(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]), VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]), "diff", 2, FileHistoryPanelImpl.this);
        }

        @Override
        protected void executeAction(AnActionEvent e) {
            List sel = FileHistoryPanelImpl.this.getSelection();
            int selectionSize = sel.size();
            if (selectionSize > 1) {
                List selectedRevisions = ContainerUtil.sorted((Collection)ContainerUtil.map((Collection)sel, (Function)new Function<TreeNodeOnVcsRevision, VcsFileRevision>(){

                    public VcsFileRevision fun(TreeNodeOnVcsRevision treeNode) {
                        return treeNode.getRevision();
                    }
                }), (Comparator)FileHistoryPanelImpl.this.myRevisionsInOrderComparator);
                VcsFileRevision olderRevision = (VcsFileRevision)selectedRevisions.get(0);
                VcsFileRevision newestRevision = (VcsFileRevision)selectedRevisions.get(sel.size() - 1);
                FileHistoryPanelImpl.this.myDiffHandler.showDiffForTwo((Project)e.getRequiredData(CommonDataKeys.PROJECT), FileHistoryPanelImpl.this.myFilePath, olderRevision, newestRevision);
            } else if (selectionSize == 1) {
                TableView flatView = FileHistoryPanelImpl.this.myDualView.getFlatView();
                int selectedRow = flatView.getSelectedRow();
                VcsFileRevision revision = FileHistoryPanelImpl.this.getFirstSelectedRevision();
                VcsFileRevision previousRevision = selectedRow == flatView.getRowCount() - 1 ? (FileHistoryPanelImpl.this.myBottomRevisionForShowDiff != null ? FileHistoryPanelImpl.this.myBottomRevisionForShowDiff : VcsFileRevision.NULL) : ((TreeNodeOnVcsRevision)flatView.getRow(selectedRow + 1)).getRevision();
                if (revision != null) {
                    FileHistoryPanelImpl.this.myDiffHandler.showDiffForOne(e, (Project)e.getRequiredData(CommonDataKeys.PROJECT), FileHistoryPanelImpl.this.myFilePath, previousRevision, revision);
                }
            }
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            e.getPresentation().setEnabled(selectionSize > 0 && this.isEnabled());
        }

        @Override
        public boolean isEnabled() {
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            if (selectionSize == 1) {
                List sel = FileHistoryPanelImpl.this.getSelection();
                return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(0));
            }
            if (selectionSize > 1) {
                return this.isDiffEnabled();
            }
            return false;
        }

        private boolean isDiffEnabled() {
            List sel = FileHistoryPanelImpl.this.getSelection();
            return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(0)) && FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(sel.size() - 1));
        }
    }

    private class MyShowAsTreeAction
    extends ToggleAction
    implements DumbAware {
        public MyShowAsTreeAction() {
            super(VcsBundle.message((String)"action.name.show.files.as.tree", (Object[])new Object[0]), null, PlatformIcons.SMALL_VCS_CONFIGURABLE);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_AS_TREE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_AS_TREE = state;
            FileHistoryPanelImpl.this.chooseView();
        }
    }

    public static class MessageColumnInfo
    extends VcsColumnInfo<String> {
        private final ColoredTableCellRenderer myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                this.setOpaque(selected);
                if (value instanceof String) {
                    String message = (String)value;
                    myIssueLinkRenderer.appendTextWithLinks(message);
                }
            }
        };
        private final IssueLinkRenderer myIssueLinkRenderer;

        public MessageColumnInfo(Project project2) {
            super(COMMIT_MESSAGE_TITLE);
            this.myIssueLinkRenderer = new IssueLinkRenderer(project2, (SimpleColoredComponent)this.myRenderer);
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            String originalMessage = object.getCommitMessage();
            if (originalMessage == null) {
                return "";
            }
            int index = StringUtil.indexOfAny((String)originalMessage, (String)"\n\r");
            if (index == -1) {
                return originalMessage;
            }
            return originalMessage.substring(0, index) + "...";
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'a', (int)125);
        }

        public TableCellRenderer getRenderer(VcsFileRevision p0) {
            return this.myRenderer;
        }
    }

    public static class AuthorColumnInfo
    extends VcsColumnInfo<String> {
        private final TableCellRenderer AUTHOR_RENDERER = new AuthorCellRenderer();

        public AuthorColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0]));
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            VcsFileRevision rev = object;
            if (object instanceof TreeNodeOnVcsRevision) {
                rev = ((TreeNodeOnVcsRevision)object).getRevision();
            }
            if (rev instanceof VcsFileRevisionEx && !rev.getAuthor().equals(((VcsFileRevisionEx)rev).getCommitterName())) {
                return object.getAuthor() + "*";
            }
            return object.getAuthor();
        }

        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.AUTHOR_RENDERER;
        }

        public TableCellRenderer getCustomizedRenderer(VcsFileRevision value, TableCellRenderer renderer) {
            if (renderer instanceof AuthorCellRenderer) {
                VcsFileRevision revision = value;
                if (value instanceof TreeNodeOnVcsRevision) {
                    revision = ((TreeNodeOnVcsRevision)value).getRevision();
                }
                if (revision instanceof VcsFileRevisionEx) {
                    VcsFileRevisionEx ex = (VcsFileRevisionEx)revision;
                    StringBuilder sb = new StringBuilder(ex.getAuthor());
                    if (ex.getAuthorEmail() != null) {
                        sb.append(" &lt;").append(ex.getAuthorEmail()).append("&gt;");
                    }
                    if (ex.getCommitterName() != null && !ex.getAuthor().equals(ex.getCommitterName())) {
                        sb.append(", via ").append(ex.getCommitterName());
                        if (ex.getCommitterEmail() != null) {
                            sb.append(" &lt;").append(ex.getCommitterEmail()).append("&gt;");
                        }
                    }
                    ((AuthorCellRenderer)renderer).setTooltipText(sb.toString());
                }
            }
            return renderer;
        }

        @NonNls
        public String getPreferredStringValue() {
            return "author_author";
        }
    }

    private static class AuthorCellRenderer
    extends DefaultTableCellRenderer {
        private String myTooltipText;

        private AuthorCellRenderer() {
        }

        public void setTooltipText(String text) {
            this.myTooltipText = text;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JComponent) {
                ((JComponent)c).setToolTipText(this.myTooltipText);
            }
            if (isSelected || hasFocus) {
                c.setBackground(table.getSelectionBackground());
                c.setForeground(table.getSelectionForeground());
            } else {
                c.setBackground(table.getBackground());
                c.setForeground(table.getForeground());
            }
            return c;
        }
    }

    public static class DateColumnInfo
    extends VcsColumnInfo<String> {
        public DateColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.date", (Object[])new Object[0]));
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            Date date = object.getRevisionDate();
            if (date == null) {
                return "";
            }
            return DateFormatUtil.formatPrettyDateTime((Date)date);
        }

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return Comparing.compare((Comparable)o1.getRevisionDate(), (Comparable)o2.getRevisionDate());
        }

        public String getPreferredStringValue() {
            return DateFormatUtil.formatPrettyDateTime((long)Clock.getTime());
        }
    }

    public static class RevisionColumnInfo
    extends VcsColumnInfo<VcsRevisionNumber> {
        private final Comparator<VcsFileRevision> myComparator;

        public RevisionColumnInfo(Comparator<VcsFileRevision> comparator2) {
            super(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0]));
            this.myComparator = comparator2;
        }

        @Override
        protected VcsRevisionNumber getDataOf(VcsFileRevision object) {
            return object.getRevisionNumber();
        }

        @Override
        public Comparator<VcsFileRevision> getComparator() {
            return this.myComparator;
        }

        @Override
        public String valueOf(VcsFileRevision object) {
            VcsRevisionNumber revisionNumber = object.getRevisionNumber();
            return revisionNumber instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revisionNumber).toShortString() : revisionNumber.asString();
        }

        public String getPreferredStringValue() {
            return "123.4567";
        }
    }
}

