/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class InitialInferenceState {
    private final Set<InferenceVariable> myInferenceVariables;
    private final PsiElement myContext;
    private final PsiSubstitutor myInferenceSubstitutor;
    private final PsiSubstitutor mySiteSubstitutor;
    private final ArrayList<Pair<InferenceVariable[], PsiClassType>> myCaptures;
    private final InferenceSessionContainer myInferenceSessionContainer;
    private final boolean myErased;

    InitialInferenceState(Set<InferenceVariable> inferenceVariables, PsiSubstitutor topInferenceSubstitutor, PsiElement context, PsiSubstitutor inferenceSubstitutor, PsiSubstitutor siteSubstitutor, List<Pair<InferenceVariable[], PsiClassType>> captures, boolean erased, InferenceSessionContainer inferenceSessionContainer) {
        this.myErased = erased;
        this.myInferenceVariables = new HashSet<InferenceVariable>();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (InferenceVariable inferenceVariable : inferenceVariables) {
            PsiType substitute = topInferenceSubstitutor.substitute((PsiTypeParameter)inferenceVariable);
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitute);
            if (!(aClass instanceof InferenceVariable)) continue;
            this.myInferenceVariables.add((InferenceVariable)aClass);
            if (!inferenceSubstitutor.getSubstitutionMap().containsValue(PsiSubstitutor.EMPTY.substitute((PsiTypeParameter)inferenceVariable))) continue;
            substitutor = substitutor.put(inferenceVariable.getParameter(), substitute);
            subst = subst.put((PsiTypeParameter)inferenceVariable, substitute);
        }
        this.myInferenceSubstitutor = substitutor;
        this.myContext = context;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myCaptures = new ArrayList();
        for (Pair pair : captures) {
            InferenceVariable[] newParameters = new InferenceVariable[((InferenceVariable[])pair.first).length];
            InferenceVariable[] parameters = (InferenceVariable[])pair.first;
            for (int i = 0; i < parameters.length; ++i) {
                PsiType substitute = topInferenceSubstitutor.substitute((PsiTypeParameter)parameters[i]);
                newParameters[i] = (InferenceVariable)PsiUtil.resolveClassInClassTypeOnly((PsiType)substitute);
            }
            this.myCaptures.add((Pair<InferenceVariable[], PsiClassType>)Pair.create((Object)newParameters, (Object)((PsiClassType)subst.substitute((PsiType)pair.second))));
        }
        this.myInferenceSessionContainer = inferenceSessionContainer;
    }

    InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    Set<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    PsiSubstitutor getInferenceSubstitutor() {
        return this.myInferenceSubstitutor;
    }

    PsiSubstitutor getSiteSubstitutor() {
        return this.mySiteSubstitutor;
    }

    public ArrayList<Pair<InferenceVariable[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }

    public boolean isErased() {
        return this.myErased;
    }
}

