/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression) {
        return !(expression instanceof PsiFunctionalExpression) && !(expression instanceof PsiParenthesizedExpression) && !(expression instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression) {
        ConditionalKind conditionalKind;
        if (expression instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiNewExpression && PsiDiamondTypeUtil.hasDiamond((PsiNewExpression)expression)) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        if (expression instanceof PsiMethodCallExpression) {
            MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod((PsiElement)((PsiMethodCallExpression)expression).getArgumentList());
            return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, candidateProperties != null ? candidateProperties.getMethod() : ((PsiMethodCallExpression)expression).resolveMethod());
        }
        if (expression instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression)) == null) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression, PsiMethod method) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression) && ((PsiCallExpression)expression).getTypeArguments().length == 0) {
            if (method != null) {
                HashSet<PsiTypeParameter> typeParameters = new HashSet<PsiTypeParameter>(Arrays.asList(method.getTypeParameters()));
                if (!typeParameters.isEmpty()) {
                    PsiType returnType = method.getReturnType();
                    if (returnType != null) {
                        return PsiPolyExpressionUtil.mentionsTypeParameters(returnType, typeParameters);
                    }
                } else if (method.isConstructor() && expression instanceof PsiNewExpression && PsiDiamondTypeUtil.hasDiamond((PsiNewExpression)expression)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Boolean mentionsTypeParameters(@Nullable PsiType returnType, final Set<PsiTypeParameter> typeParameters) {
        if (returnType == null) {
            return false;
        }
        return (Boolean)returnType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            @Nullable
            public Boolean visitType(PsiType type) {
                return false;
            }

            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return (Boolean)bound.accept((PsiTypeVisitor)this);
                }
                return false;
            }

            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType type : classType.getParameters()) {
                    if (!((Boolean)type.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return true;
                }
                PsiClass psiClass = classType.resolve();
                return psiClass instanceof PsiTypeParameter && typeParameters.contains(psiClass);
            }

            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }
        });
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp((PsiElement)expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition((PsiElement)expr, (PsiElement)context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable || context instanceof PsiLambdaExpression;
    }

    public static boolean isExpressionOfPrimitiveType(@Nullable PsiExpression arg) {
        if (arg != null && !PsiPolyExpressionUtil.isPolyExpression(arg)) {
            PsiType type = arg.getType();
            return type instanceof PsiPrimitiveType && type != PsiType.NULL;
        }
        if (arg instanceof PsiNewExpression || arg instanceof PsiFunctionalExpression) {
            return false;
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isExpressionOfPrimitiveType(((PsiParenthesizedExpression)arg).getExpression());
        }
        if (arg instanceof PsiConditionalExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)arg).resolveMethod();
            return method != null && method.getReturnType() instanceof PsiPrimitiveType;
        }
        assert (false) : arg;
        return false;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type = null;
        if (expr instanceof PsiNewExpression || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            type = method.getReturnType();
        }
        ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(type);
        if (kind != null) {
            return kind;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == null) {
                return thenKind;
            }
            if (thenKind == null) {
                return elseKind;
            }
        }
        return null;
    }

    @Nullable
    private static ConditionalKind isBooleanOrNumericType(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (TypeConversionUtil.isNumericType((PsiType)type)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType((PsiType)type)) {
            return ConditionalKind.BOOLEAN;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType classType : psiClass.getExtendsListTypes()) {
                ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType((PsiType)classType);
                if (kind == null) continue;
                return kind;
            }
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC;

    }
}

