/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlEntityDecl;
import java.util.HashMap;
import java.util.Map;

public class XmlEntityCache {
    private static final Key<Map<String, CachedValue<XmlEntityDecl>>> XML_ENTITY_DECL_MAP = Key.create((String)"XML_ENTITY_DECL_MAP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheParticularEntity(PsiFile file2, XmlEntityDecl decl) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            final Map<String, CachedValue<XmlEntityDecl>> cachingMap = XmlEntityCache.getCachingMap((PsiElement)file2);
            final String name = decl.getName();
            if (cachingMap.containsKey(name)) {
                return;
            }
            final SmartPsiElementPointer declPointer = SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiElementPointer((PsiElement)decl);
            cachingMap.put(name, (CachedValue<XmlEntityDecl>)CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlEntityDecl>(){

                public CachedValueProvider.Result<XmlEntityDecl> compute() {
                    PsiElement declElement = declPointer.getElement();
                    if (declElement instanceof XmlEntityDecl && declElement.isValid() && name.equals(((XmlEntityDecl)declElement).getName())) {
                        return new CachedValueProvider.Result((Object)((XmlEntityDecl)declElement), new Object[]{declElement});
                    }
                    cachingMap.put(name, null);
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
            }, false));
        }
    }

    static Map<String, CachedValue<XmlEntityDecl>> getCachingMap(PsiElement targetElement) {
        HashMap map = (HashMap)targetElement.getUserData(XML_ENTITY_DECL_MAP);
        if (map == null) {
            map = new HashMap();
            targetElement.putUserData(XML_ENTITY_DECL_MAP, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntityCaches(PsiFile file2, PsiFile context) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> cachingMap = XmlEntityCache.getCachingMap((PsiElement)file2);
            for (Map.Entry<String, CachedValue<XmlEntityDecl>> entry : XmlEntityCache.getCachingMap((PsiElement)context).entrySet()) {
                cachingMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl getCachedEntity(PsiFile file2, String name) {
        CachedValue<XmlEntityDecl> cachedValue;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> cachingMap = XmlEntityCache.getCachingMap((PsiElement)file2);
            cachedValue = cachingMap.get(name);
        }
        return cachedValue != null ? (XmlEntityDecl)cachedValue.getValue() : null;
    }
}

