/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScopeEnlarger;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeBuilderImpl
extends ProjectScopeBuilder {
    protected final Project myProject;

    public ProjectScopeBuilderImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        ProjectAndLibrariesScope result = new ProjectAndLibrariesScope(this.myProject){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/ProjectScopeBuilderImpl$1", "contains"));
                }
                return this.myProjectFileIndex.isInLibrarySource(file2) || this.myProjectFileIndex.isInLibraryClasses(file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/ProjectScopeBuilderImpl$1", "isSearchInModuleContent"));
                }
                return false;
            }
        };
        result.setDisplayName(PsiBundle.message((String)"psi.search.scope.libraries", (Object[])new Object[0]));
        ProjectAndLibrariesScope projectAndLibrariesScope = result;
        if (projectAndLibrariesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeBuilderImpl", "buildLibrariesScope"));
        }
        return projectAndLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        SearchScopeEnlarger each;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            EverythingGlobalScope everythingGlobalScope = new EverythingGlobalScope(this.myProject);
            if (everythingGlobalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeBuilderImpl", "buildAllScope"));
            }
            return everythingGlobalScope;
        }
        boolean searchOutsideRootModel = false;
        SearchScopeEnlarger[] searchScopeEnlargerArray = (SearchScopeEnlarger[])Extensions.getExtensions(SearchScopeEnlarger.EXTENSION);
        int n = searchScopeEnlargerArray.length;
        for (int i = 0; i < n && !(searchOutsideRootModel = (each = searchScopeEnlargerArray[i]).allScopeSearchesOutsideRootModel(this.myProject)); ++i) {
        }
        ProjectAndLibrariesScope projectAndLibrariesScope = new ProjectAndLibrariesScope(this.myProject, searchOutsideRootModel);
        if (projectAndLibrariesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeBuilderImpl", "buildAllScope"));
        }
        return projectAndLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            EverythingGlobalScope everythingGlobalScope = new EverythingGlobalScope(this.myProject){

                public boolean isSearchInLibraries() {
                    return false;
                }
            };
            if (everythingGlobalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeBuilderImpl", "buildProjectScope"));
            }
            return everythingGlobalScope;
        }
        ProjectScopeImpl projectScopeImpl = new ProjectScopeImpl(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
        if (projectScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeBuilderImpl", "buildProjectScope"));
        }
        return projectScopeImpl;
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        CoreProjectScopeBuilder.ContentSearchScope contentSearchScope = new CoreProjectScopeBuilder.ContentSearchScope(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
        if (contentSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeBuilderImpl", "buildContentScope"));
        }
        return contentSearchScope;
    }
}

