/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.remoteServer.agent.impl.util.FinalTask;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;

public class SequentialTaskExecutor {
    private static final Logger LOG = Logger.getInstance((String)("#" + SequentialTaskExecutor.class.getName()));
    private BlockingQueue<Runnable> myTasks = new LinkedBlockingQueue<Runnable>();

    public SequentialTaskExecutor() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Runnable task;
                    do {
                        task = (Runnable)SequentialTaskExecutor.this.myTasks.take();
                        task.run();
                    } while (!(task instanceof FinalTask));
                }
                catch (InterruptedException e) {
                    LOG.debug((Throwable)e);
                }
            }
        });
    }

    public void queueTask(Runnable task) {
        this.myTasks.offer(task);
    }

    public <V> V queueAndWaitTask(final Callable<V> task) throws Throwable {
        final Ref resultRef = new Ref();
        final Ref throwableRef = new Ref();
        final Semaphore taskSemaphore = new Semaphore();
        taskSemaphore.down();
        this.queueTask(new Runnable(){

            @Override
            public void run() {
                try {
                    resultRef.set(task.call());
                }
                catch (Throwable e) {
                    throwableRef.set((Object)e);
                    LOG.error(e);
                }
                finally {
                    taskSemaphore.up();
                }
            }
        });
        taskSemaphore.waitFor();
        if (!throwableRef.isNull()) {
            throw (Throwable)throwableRef.get();
        }
        return (V)resultRef.get();
    }
}

