/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.treeWithCheckedNodes;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.impl.CollectionsDelta;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlusMinus;
import com.intellij.util.Processor;
import com.intellij.util.TreeNodeState;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectedState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

public class SelectionManager {
    private final SelectedState<VirtualFile> myState;
    private final Convertor<DefaultMutableTreeNode, VirtualFile> myNodeConvertor;
    @Nullable
    private PlusMinus<VirtualFile> mySelectionChangeListener;

    public SelectionManager(int selectedSize, int queueSize, Convertor<DefaultMutableTreeNode, VirtualFile> nodeConvertor) {
        this.myNodeConvertor = nodeConvertor;
        this.myState = new SelectedState(selectedSize, queueSize);
    }

    public void toggleSelection(DefaultMutableTreeNode node) {
        final StateWorker stateWorker = new StateWorker(node, this.myNodeConvertor);
        final VirtualFile vf = stateWorker.getVf();
        if (vf == null) {
            return;
        }
        TreeNodeState state = this.getStateImpl(stateWorker);
        if (TreeNodeState.HAVE_SELECTED_ABOVE.equals((Object)state)) {
            return;
        }
        if (TreeNodeState.CLEAR.equals((Object)state) && !this.myState.canAddSelection()) {
            return;
        }
        HashSet<VirtualFile> old = new HashSet<VirtualFile>(this.myState.getSelected());
        final TreeNodeState futureState = this.myState.putAndPass(vf, TreeNodeState.SELECTED.equals((Object)state) ? TreeNodeState.CLEAR : TreeNodeState.SELECTED);
        if (!TreeNodeState.SELECTED.equals((Object)futureState)) {
            this.myState.clearAllCachedMatching(new Processor<VirtualFile>(){

                public boolean process(VirtualFile virtualFile) {
                    return VfsUtil.isAncestor((VirtualFile)virtualFile, (VirtualFile)vf, (boolean)false);
                }
            });
        }
        stateWorker.iterateParents(this.myState, new PairProcessor<VirtualFile, TreeNodeState>(){

            public boolean process(VirtualFile virtualFile, TreeNodeState state) {
                if (TreeNodeState.SELECTED.equals((Object)futureState)) {
                    SelectionManager.this.myState.putAndPass(virtualFile, TreeNodeState.HAVE_SELECTED_BELOW);
                } else {
                    SelectionManager.this.myState.remove(virtualFile);
                }
                return true;
            }
        });
        this.myState.clearAllCachedMatching(new Processor<VirtualFile>(){

            public boolean process(VirtualFile vf) {
                return VfsUtil.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)vf, (boolean)false);
            }
        });
        for (VirtualFile selected : this.myState.getSelected()) {
            if (!VfsUtil.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)selected, (boolean)true)) continue;
            this.myState.remove(selected);
        }
        Set<VirtualFile> selectedAfter = this.myState.getSelected();
        if (this.mySelectionChangeListener != null && !old.equals(selectedAfter)) {
            Set<VirtualFile> removed = CollectionsDelta.notInSecond(old, selectedAfter);
            Set<VirtualFile> newlyAdded = CollectionsDelta.notInSecond(selectedAfter, old);
            if (newlyAdded != null) {
                for (VirtualFile file2 : newlyAdded) {
                    if (this.mySelectionChangeListener == null) continue;
                    this.mySelectionChangeListener.plus((Object)file2);
                }
            }
            if (removed != null) {
                for (VirtualFile file2 : removed) {
                    if (this.mySelectionChangeListener == null) continue;
                    this.mySelectionChangeListener.minus((Object)file2);
                }
            }
        }
    }

    public boolean canAddSelection() {
        return this.myState.canAddSelection();
    }

    public void setSelection(Collection<VirtualFile> files) {
        this.myState.setSelection(files);
        for (VirtualFile file2 : files) {
            if (this.mySelectionChangeListener == null) continue;
            this.mySelectionChangeListener.plus((Object)file2);
        }
    }

    public TreeNodeState getState(DefaultMutableTreeNode node) {
        return this.getStateImpl(new StateWorker(node, this.myNodeConvertor));
    }

    private TreeNodeState getStateImpl(final StateWorker stateWorker) {
        if (stateWorker.getVf() == null) {
            return TreeNodeState.CLEAR;
        }
        TreeNodeState stateSelf = this.myState.get(stateWorker.getVf());
        if (stateSelf != null) {
            return stateSelf;
        }
        final Ref result = new Ref();
        stateWorker.iterateParents(this.myState, new PairProcessor<VirtualFile, TreeNodeState>(){

            public boolean process(VirtualFile virtualFile, TreeNodeState state) {
                if (state != null) {
                    if (TreeNodeState.SELECTED.equals((Object)state) || TreeNodeState.HAVE_SELECTED_ABOVE.equals((Object)state)) {
                        result.set((Object)SelectionManager.this.myState.putAndPass(stateWorker.getVf(), TreeNodeState.HAVE_SELECTED_ABOVE));
                    }
                    return false;
                }
                return true;
            }
        });
        if (!result.isNull()) {
            return (TreeNodeState)result.get();
        }
        for (VirtualFile selected : this.myState.getSelected()) {
            if (!VfsUtil.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)selected, (boolean)true)) continue;
            return this.myState.putAndPass(stateWorker.getVf(), TreeNodeState.HAVE_SELECTED_BELOW);
        }
        return TreeNodeState.CLEAR;
    }

    public void removeSelection(final VirtualFile elementAt) {
        this.myState.remove(elementAt);
        this.myState.clearAllCachedMatching(new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                return VfsUtil.isAncestor((VirtualFile)virtualFile, (VirtualFile)elementAt, (boolean)false) || VfsUtil.isAncestor((VirtualFile)elementAt, (VirtualFile)virtualFile, (boolean)false);
            }
        });
        if (this.mySelectionChangeListener != null) {
            this.mySelectionChangeListener.minus((Object)elementAt);
        }
    }

    public PlusMinus<VirtualFile> getSelectionChangeListener() {
        return this.mySelectionChangeListener;
    }

    public void setSelectionChangeListener(PlusMinus<VirtualFile> selectionChangeListener) {
        this.mySelectionChangeListener = selectionChangeListener;
    }

    private static class StateWorker {
        private final DefaultMutableTreeNode myNode;
        private final Convertor<DefaultMutableTreeNode, VirtualFile> myConvertor;
        private VirtualFile myVf;

        private StateWorker(DefaultMutableTreeNode node, Convertor<DefaultMutableTreeNode, VirtualFile> convertor) {
            this.myNode = node;
            this.myConvertor = convertor;
            this.myVf = (VirtualFile)this.myConvertor.convert((Object)node);
        }

        public VirtualFile getVf() {
            return this.myVf;
        }

        public void iterateParents(SelectedState<VirtualFile> states, PairProcessor<VirtualFile, TreeNodeState> parentsProcessor) {
            for (DefaultMutableTreeNode current = (DefaultMutableTreeNode)this.myNode.getParent(); current != null; current = (DefaultMutableTreeNode)current.getParent()) {
                VirtualFile file2 = (VirtualFile)this.myConvertor.convert((Object)current);
                if (file2 == null) {
                    return;
                }
                TreeNodeState state = states.get(file2);
                if (parentsProcessor.process((Object)file2, (Object)state)) continue;
                return;
            }
        }
    }
}

