/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.migration.ForCanBeForeachInspectionBase;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StringUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForCanBeForeachInspection
extends ForCanBeForeachInspectionBase {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForCanBeForeachFix();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("for.can.be.foreach.option", new Object[0]), "REPORT_INDEXED_LOOP");
        panel.addCheckbox(InspectionGadgetsBundle.message("for.can.be.foreach.option2", new Object[0]), "ignoreUntypedCollections");
        return panel;
    }

    static void replaceIteratorNext(PsiElement element, String contentVariableName, PsiVariable iterator, PsiType contentType, PsiElement childToSkip, StringBuilder out) {
        if (ForCanBeForeachInspection.isIteratorNext(element, iterator, contentType)) {
            out.append(contentVariableName);
        } else {
            PsiElement[] children2 = element.getChildren();
            if (children2.length == 0) {
                String text = element.getText();
                if ("instanceof".equals(text) && out.charAt(out.length() - 1) != ' ') {
                    out.append(' ');
                }
                out.append(text);
            } else {
                boolean skippingWhiteSpace = false;
                for (PsiElement child : children2) {
                    if (ForCanBeForeachInspection.shouldSkip(iterator, contentType, child) || child.equals(childToSkip)) {
                        skippingWhiteSpace = true;
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                    skippingWhiteSpace = false;
                    ForCanBeForeachInspection.replaceIteratorNext(child, contentVariableName, iterator, contentType, childToSkip, out);
                }
            }
        }
    }

    static boolean shouldSkip(PsiVariable iterator, PsiType contentType, PsiElement child) {
        if (!(child instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)child;
        PsiExpression expression = expressionStatement.getExpression();
        return ForCanBeForeachInspection.isIteratorNext((PsiElement)expression, iterator, contentType);
    }

    static boolean isIteratorNextDeclaration(PsiStatement statement2, PsiVariable iterator, PsiType contentType) {
        if (!(statement2 instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiExpression initializer = variable.getInitializer();
        return ForCanBeForeachInspection.isIteratorNext((PsiElement)initializer, iterator, contentType);
    }

    static boolean isIteratorNext(PsiElement element, PsiVariable iterator, PsiType contentType) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)element;
            PsiType type = castExpression.getType();
            if (type == null) {
                return false;
            }
            if (!type.equals(contentType)) {
                return false;
            }
            PsiExpression operand = castExpression.getOperand();
            return ForCanBeForeachInspection.isIteratorNext((PsiElement)operand, iterator, contentType);
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = callExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiReferenceExpression reference = callExpression.getMethodExpression();
        String referenceName = reference.getReferenceName();
        if (!"next".equals(referenceName)) {
            return false;
        }
        PsiExpression expression = reference.getQualifierExpression();
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        return iterator.equals(target);
    }

    static String createNewVariableName(@NotNull PsiElement scope, PsiType type, @Nullable String containerName) {
        String baseName;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/migration/ForCanBeForeachInspection", "createNewVariableName"));
        }
        Project project2 = scope.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        if (containerName != null) {
            baseName = StringUtils.createSingularFromName(containerName);
        } else {
            SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
            String[] names = suggestions.names;
            baseName = names != null && names.length > 0 ? names[0] : "value";
        }
        if (baseName == null || baseName.isEmpty()) {
            baseName = "value";
        }
        return codeStyleManager.suggestUniqueVariableName(baseName, scope, true);
    }

    @Nullable
    static PsiStatement getFirstStatement(PsiStatement body) {
        if (!(body instanceof PsiBlockStatement)) {
            return body;
        }
        PsiBlockStatement block = (PsiBlockStatement)body;
        PsiCodeBlock codeBlock = block.getCodeBlock();
        return ControlFlowUtils.getFirstStatementInBlock(codeBlock);
    }

    private class ForCanBeForeachFix
    extends InspectionGadgetsFix {
        private ForCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String newExpression;
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (!(parent instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (ForCanBeForeachInspectionBase.isArrayLoopStatement(forStatement)) {
                newExpression = this.createArrayIterationText(forStatement);
            } else if (ForCanBeForeachInspectionBase.isCollectionLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                newExpression = this.createCollectionIterationText(forStatement);
            } else if (ForCanBeForeachInspectionBase.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                newExpression = this.createListIterationText(forStatement);
            } else {
                return;
            }
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)forStatement, newExpression);
        }

        @Nullable
        private String createListIterationText(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiVariable listVariable;
            PsiType parameterType;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            PsiExpression collectionSize;
            String indexName;
            if (forStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix", "createListIterationText"));
            }
            PsiBinaryExpression condition = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(forStatement.getCondition());
            if (condition == null) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(condition.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(condition.getROperand());
            if (rhs == null) {
                return null;
            }
            IElementType tokenType = condition.getOperationTokenType();
            if (JavaTokenType.LT.equals(tokenType)) {
                indexName = lhs.getText();
                collectionSize = rhs;
            } else if (JavaTokenType.GT.equals(tokenType)) {
                indexName = rhs.getText();
                collectionSize = lhs;
            } else {
                return null;
            }
            if (collectionSize instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)collectionSize).resolve()) instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                collectionSize = ParenthesesUtils.stripParentheses(variable.getInitializer());
            }
            if (!(collectionSize instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(collectionSize);
            if (methodCallExpression == null) {
                return null;
            }
            PsiReferenceExpression listLengthExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(listLengthExpression.getQualifierExpression());
            PsiReferenceExpression listReference = qualifier instanceof PsiReferenceExpression ? (PsiReferenceExpression)qualifier : null;
            if (listReference == null) {
                parameterType = this.extractListTypeFromContainingClass((PsiElement)forStatement);
            } else {
                PsiType type = listReference.getType();
                if (type == null) {
                    return null;
                }
                parameterType = this.extractContentTypeFromType(type);
            }
            if (parameterType == null) {
                parameterType = TypeUtils.getObjectType((PsiElement)forStatement);
            }
            String typeString = parameterType.getCanonicalText();
            if (listReference == null) {
                listVariable = null;
            } else {
                PsiElement target2 = listReference.resolve();
                if (!(target2 instanceof PsiVariable)) {
                    return null;
                }
                listVariable = (PsiVariable)target2;
            }
            PsiStatement body = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body);
            boolean isDeclaration = this.isListElementDeclaration(firstStatement, listVariable, indexName, parameterType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                String collectionName = listReference == null ? null : listReference.getReferenceName();
                contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, parameterType, collectionName);
                finalString = "";
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(typeString);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            String listName = listReference == null ? "this" : listReference.getText();
            out.append(listName);
            out.append(')');
            if (body != null) {
                this.replaceCollectionGetAccess((PsiElement)body, contentVariableName, listVariable, indexName, (PsiElement)statementToSkip, out);
            }
            return out.toString();
        }

        @Nullable
        private PsiType extractContentTypeFromType(PsiType collectionType) {
            if (!(collectionType instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)collectionType;
            PsiType[] parameterTypes = classType.getParameters();
            if (parameterTypes.length == 0) {
                return null;
            }
            PsiType parameterType = parameterTypes[0];
            if (parameterType == null) {
                return null;
            }
            if (parameterType instanceof PsiWildcardType) {
                PsiWildcardType wildcardType = (PsiWildcardType)parameterType;
                return wildcardType.getExtendsBound();
            }
            if (parameterType instanceof PsiCapturedWildcardType) {
                PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)parameterType;
                PsiWildcardType wildcardType = capturedWildcardType.getWildcard();
                return wildcardType.getExtendsBound();
            }
            return parameterType;
        }

        @Nullable
        private PsiType extractListTypeFromContainingClass(PsiElement element) {
            PsiClass listClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (listClass == null) {
                return null;
            }
            PsiMethod[] getMethods = listClass.findMethodsByName("get", true);
            if (getMethods.length == 0) {
                return null;
            }
            PsiType type = getMethods[0].getReturnType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass parameterClass = classType.resolve();
            if (parameterClass == null) {
                return null;
            }
            PsiClass subClass = null;
            while (listClass != null && !listClass.hasTypeParameters()) {
                subClass = listClass;
                listClass = listClass.getSuperClass();
            }
            if (listClass == null || subClass == null) {
                return TypeUtils.getObjectType(element);
            }
            PsiTypeParameter[] typeParameters = listClass.getTypeParameters();
            if (!parameterClass.equals(typeParameters[0])) {
                return TypeUtils.getObjectType(element);
            }
            PsiReferenceList extendsList = subClass.getExtendsList();
            if (extendsList == null) {
                return null;
            }
            PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
            if (referenceElements.length == 0) {
                return null;
            }
            PsiType[] types = referenceElements[0].getTypeParameters();
            if (types.length == 0) {
                return TypeUtils.getObjectType(element);
            }
            return types[0];
        }

        @Nullable
        private String createCollectionIterationText(@NotNull PsiForStatement forStatement) throws IncorrectOperationException {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiType iteratorVariableContentType;
            if (forStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix", "createCollectionIterationText"));
            }
            PsiStatement body = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body);
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement declaredIterator = declaration.getDeclaredElements()[0];
            if (!(declaredIterator instanceof PsiVariable)) {
                return null;
            }
            PsiVariable iteratorVariable = (PsiVariable)declaredIterator;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iteratorVariable.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiType iteratorType = initializer.getType();
            if (iteratorType == null) {
                return null;
            }
            PsiType iteratorContentType = this.extractContentTypeFromType(iteratorType);
            PsiType iteratorVariableType = iteratorVariable.getType();
            PsiClassType javaLangObject = TypeUtils.getObjectType((PsiElement)forStatement);
            Object contentType = iteratorContentType == null ? ((iteratorVariableContentType = this.extractContentTypeFromType(iteratorVariableType)) == null ? javaLangObject : iteratorVariableContentType) : iteratorContentType;
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = methodExpression.getQualifierExpression();
            boolean isDeclaration = ForCanBeForeachInspection.isIteratorNextDeclaration(firstStatement, iteratorVariable, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)collection;
                    String collectionName = referenceExpression.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, contentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, contentType, null);
                }
                Project project2 = forStatement.getProject();
                CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
                finalString = codeStyleSettings.GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            String contentTypeString = contentType.getCanonicalText();
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(contentTypeString);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            if (!contentType.equals(javaLangObject)) {
                String iterableTypeString = "java.lang.Iterable<" + contentTypeString + '>';
                if (iteratorContentType == null) {
                    out.append('(');
                    out.append(iterableTypeString);
                    out.append(')');
                }
            }
            if (collection == null) {
                out.append("this");
            } else {
                out.append(collection.getText());
            }
            out.append(')');
            ForCanBeForeachInspection.replaceIteratorNext((PsiElement)body, contentVariableName, iteratorVariable, contentType, (PsiElement)statementToSkip, out);
            return out.toString();
        }

        @Nullable
        private String createArrayIterationText(@NotNull PsiForStatement forStatement) {
            PsiDeclarationStatement statementToSkip;
            String finalString;
            String contentVariableName;
            PsiType type;
            String indexName;
            PsiReferenceExpression arrayLengthExpression;
            if (forStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix", "createArrayIterationText"));
            }
            PsiExpression condition = forStatement.getCondition();
            PsiBinaryExpression strippedCondition = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(condition);
            if (strippedCondition == null) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(strippedCondition.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(strippedCondition.getROperand());
            if (rhs == null) {
                return null;
            }
            IElementType tokenType = strippedCondition.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.LT)) {
                arrayLengthExpression = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(rhs);
                indexName = lhs.getText();
            } else if (tokenType.equals(JavaTokenType.GT)) {
                arrayLengthExpression = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(lhs);
                indexName = rhs.getText();
            } else {
                return null;
            }
            if (arrayLengthExpression == null) {
                return null;
            }
            PsiReferenceExpression arrayReference = (PsiReferenceExpression)arrayLengthExpression.getQualifierExpression();
            if (arrayReference == null) {
                PsiElement target = arrayLengthExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiExpression initializer = variable.getInitializer();
                if (!(initializer instanceof PsiReferenceExpression)) {
                    return null;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)initializer;
                arrayReference = (PsiReferenceExpression)referenceExpression.getQualifierExpression();
                if (arrayReference == null) {
                    return null;
                }
            }
            if (!((type = arrayReference.getType()) instanceof PsiArrayType)) {
                return null;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            String typeText = componentType.getCanonicalText();
            PsiElement target = arrayReference.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            PsiVariable arrayVariable = (PsiVariable)target;
            PsiStatement body = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body);
            boolean isDeclaration = this.isArrayElementDeclaration(firstStatement, arrayVariable, indexName);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)forStatement)) {
                    String collectionName = arrayReference.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, componentType, collectionName);
                    Project project2 = forStatement.getProject();
                    CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
                    finalString = codeStyleSettings.GENERATE_FINAL_LOCALS ? "final " : "";
                    statementToSkip = null;
                } else {
                    contentVariableName = variable.getName();
                    statementToSkip = declarationStatement;
                    finalString = variable.hasModifierProperty("final") ? "final " : "";
                }
            } else {
                String collectionName = arrayReference.getReferenceName();
                contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, componentType, collectionName);
                Project project3 = forStatement.getProject();
                CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project3);
                finalString = codeStyleSettings.GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(typeText);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            String arrayName = arrayReference.getText();
            out.append(arrayName);
            out.append(')');
            if (body != null) {
                this.replaceArrayAccess((PsiElement)body, contentVariableName, arrayVariable, indexName, (PsiElement)statementToSkip, out);
            }
            return out.toString();
        }

        private void replaceArrayAccess(PsiElement element, String contentVariableName, PsiVariable arrayVariable, String indexName, PsiElement childToSkip, StringBuilder out) {
            if (this.isArrayLookup(element, indexName, arrayVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children2 = element.getChildren();
                if (children2.length == 0) {
                    String text = element.getText();
                    if ("instanceof".equals(text) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children2) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        this.replaceArrayAccess(child, contentVariableName, arrayVariable, indexName, childToSkip, out);
                    }
                }
            }
        }

        private void replaceCollectionGetAccess(PsiElement element, String contentVariableName, PsiVariable listVariable, String indexName, PsiElement childToSkip, StringBuilder out) {
            if (this.isListGetLookup(element, indexName, listVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children2 = element.getChildren();
                if (children2.length == 0) {
                    String text = element.getText();
                    if ("instanceof".equals(text) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children2) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        this.replaceCollectionGetAccess(child, contentVariableName, listVariable, indexName, childToSkip, out);
                    }
                }
            }
        }

        private boolean isListGetLookup(PsiElement element, String indexName, PsiVariable listVariable) {
            if (!(element instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expression = (PsiExpression)element;
            if (!ForCanBeForeachInspectionBase.expressionIsListGetLookup(expression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(expression);
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return false;
            }
            if (!indexName.equals(expressions[0].getText())) {
                return false;
            }
            if (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
                return listVariable == null;
            }
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return listVariable.equals(target);
        }

        private boolean isArrayElementDeclaration(PsiStatement statement2, PsiVariable arrayVariable, String indexName) {
            if (!(statement2 instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return this.isArrayLookup((PsiElement)initializer, indexName, arrayVariable);
        }

        private boolean isListElementDeclaration(PsiStatement statement2, PsiVariable listVariable, String indexName, PsiType type) {
            if (!(statement2 instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            if (!this.isListGetLookup((PsiElement)initializer, indexName, listVariable)) {
                return false;
            }
            return type != null && type.equals(variable.getType());
        }

        private boolean isArrayLookup(PsiElement element, String indexName, PsiVariable arrayVariable) {
            if (element == null) {
                return false;
            }
            if (!(element instanceof PsiArrayAccessExpression)) {
                return false;
            }
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)element;
            PsiExpression indexExpression = arrayAccess.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            if (!indexName.equals(indexExpression.getText())) {
                return false;
            }
            PsiExpression arrayExpression = arrayAccess.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return arrayVariable.equals(target);
        }
    }
}

