/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleOrigin;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019H\u0016J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/LibrarySourceInfo;", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "isLibrary", "", "()Z", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "kotlin.jvm.PlatformType", "copy", "dependencies", "", "toString", "", "idea-analysis"})
public final class LibrarySourceInfo
implements IdeaModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.OTHER;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    public GlobalSearchScope contentScope() {
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    @Override
    public boolean isLibrary() {
        return true;
    }

    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this), (Iterable)new LibraryInfo(this.project, this.library).dependencies());
    }

    @NotNull
    public String toString() {
        return "LibrarySourceInfo(libraryName=" + this.library.getName() + ")";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibrarySourceInfo(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        this.project = project;
        this.library = library;
        Name name2 = Name.special("<sources for library " + this.library.getName() + ">");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<sources f\u2026ibrary ${library.name}>\")");
        this.name = name2;
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltins dependencyOnBuiltins() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltins(this);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhichInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhichInternalsAreVisible(this);
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Library component2() {
        return this.library;
    }

    @NotNull
    public final LibrarySourceInfo copy(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return new LibrarySourceInfo(project, library);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LibrarySourceInfo copy$default(LibrarySourceInfo librarySourceInfo, Project project, Library library, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            project = librarySourceInfo.project;
        }
        if ((n & 2) != 0) {
            library = librarySourceInfo.library;
        }
        return librarySourceInfo.copy(project, library);
    }

    public int hashCode() {
        Project project = this.project;
        Library library = this.library;
        return (project != null ? project.hashCode() : 0) * 31 + (library != null ? library.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LibrarySourceInfo)) break block3;
                LibrarySourceInfo librarySourceInfo = (LibrarySourceInfo)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)librarySourceInfo.project) || !Intrinsics.areEqual((Object)this.library, (Object)librarySourceInfo.library)) break block3;
            }
            return true;
        }
        return false;
    }
}

