/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;

public class KotlinLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return kotlinLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/kotlin/idea/formatter/KotlinLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        switch (settingsType) {
            case WRAPPING_AND_BRACES_SETTINGS: {
                return "public class ThisIsASampleClass {\n    fun foo1(i1: Int, i2: Int, i3: Int) : Int {\n        when (i1) {\n            is Number -> 0\n            else -> 1\n        }\n        return 0\n    }\n    private fun foo2():Int {\n        try {            return foo1(12, 13, 14)\n        }        catch (e: Exception) {            return 0        }        finally {           if (true) {               return 1           }           else {               return 2           }        }    }\n    private val f = {(a: Int)->a*2}\n}";
            }
        }
        return "open class Some {\n    private val f: (Int)->Int = { (a: Int) -> a * 2 }\n    fun foo(): Int {\n        val test: Int = 12\n        for (i in 10..42) {\n            println (when {\n                i < test -> -1\n                i > test -> 1\n                else -> 0\n            })\n        }\n        return test\n    }\n    private fun <T>foo2(): Int where T : List<T> {\n        return 0\n    }\n}\nclass AnotherClass<T : Any> : Some()\n";
    }

    public String getLanguageName() {
        return "Kotlin";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/formatter/KotlinLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/kotlin/idea/formatter/KotlinLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        switch (settingsType) {
            case SPACING_SETTINGS: {
                consumer2.showStandardOptions(new String[]{"SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA"});
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_AROUND_RANGE", "Around range (..)", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", "Space before colon, after declarations' name", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", "Space after colon, before declarations' type", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_BEFORE_EXTEND_COLON", "Space before colon in new type definition", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_AFTER_EXTEND_COLON", "Space after colon in new type definition", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD", "Insert whitespaces in simple one line methods", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_AROUND_FUNCTION_TYPE_ARROW", "Surround arrow in function types with spaces", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_AROUND_WHEN_ARROW", "Surround arrow in \"when\" clause with spaces", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "SPACE_BEFORE_LAMBDA_ARROW", "Before lambda arrow", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
                break;
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                consumer2.showStandardOptions(new String[]{"ALIGN_MULTILINE_EXTENDS_LIST", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_METHOD_BRACKETS", "ALIGN_MULTILINE_BINARY_OPERATION", "ELSE_ON_NEW_LINE", "WHILE_ON_NEW_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "CALL_PARAMETERS_WRAP", "METHOD_PARAMETERS_WRAP"});
                consumer2.renameStandardOption(CodeStyleSettingsCustomizable.WRAPPING_SWITCH_STATEMENT, "'when' statements");
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "ALIGN_IN_COLUMNS_CASE_BRANCH", "Align in columns 'case' branches", CodeStyleSettingsCustomizable.WRAPPING_SWITCH_STATEMENT, new Object[0]);
                consumer2.showCustomOption(KotlinCodeStyleSettings.class, "LBRACE_ON_NEXT_LINE", "Put left brace on new line", CodeStyleSettingsCustomizable.WRAPPING_BRACES, new Object[0]);
                break;
            }
            default: {
                consumer2.showStandardOptions(new String[0]);
            }
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = new CommonCodeStyleSettings(this.getLanguage());
        commonCodeStyleSettings.initIndentOptions();
        return commonCodeStyleSettings;
    }
}

