/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J6\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J9\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinParameterProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "isToSearchForTextOccurrences", "isToSearchInComments", "psiElement", "prepareRenaming", "scope", "Lcom/intellij/psi/search/SearchScope;", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchForTextOccurrences", "enabled", "setToSearchInComments", "idea"})
public final class RenameKotlinParameterProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtParameter && ((KtParameter)element2).getOwnerFunction() instanceof KtNamedFunction;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
    }

    public void setToSearchInComments(@NotNull PsiElement element2, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element2, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE = enabled;
    }

    public void findCollisions(@NotNull PsiElement element2, @Nullable String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (newName2 == null) {
            return;
        }
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement(element2);
        if (!(psiNamedElement instanceof KtNamedDeclaration)) {
            psiNamedElement = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiNamedElement;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(declaration);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        }
        VariableDescriptor descriptor2 = (VariableDescriptor)declarationDescriptor;
        SmartList collisions = new SmartList();
        RenameConflictUtilsKt.checkRedeclarations(descriptor2, newName2, collisions);
        RenameConflictUtilsKt.checkOriginalUsagesRetargeting(declaration, newName2, result2, collisions);
        RenameConflictUtilsKt.checkNewNameUsagesRetargeting(declaration, newName2, collisions);
        Collection collection = result2;
        CollectionsKt.addAll((Collection)collection, (Iterable)collisions);
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element2, @Nullable String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        super.prepareRenaming(element2, newName2, allRenames, scope2);
        if (!(element2 instanceof KtParameter) || newName2 == null) {
            return;
        }
        KtFunction ktFunction = ((KtParameter)element2).getOwnerFunction();
        if (ktFunction == null) {
            return;
        }
        KtFunction function2 = ktFunction;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(function2);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        FunctionDescriptor originalDescriptor = (FunctionDescriptor)declarationDescriptor;
        Project project = ((KtParameter)element2).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Collection collection = OverrideResolver.getDeepestSuperDeclarations((CallableMemberDescriptor)originalDescriptor);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"OverrideResolver.getDeep\u2026tions(originalDescriptor)");
        List<PsiElement> affectedCallables2 = CallableRefactoringKt.getAffectedCallables(project, collection);
        for (PsiElement callable : affectedCallables2) {
            PsiNamedElement parameter;
            PsiNamedElement psiNamedElement;
            KtParameter it;
            Object[] $receiver$iv;
            Object object;
            if (!KotlinRefactoringUtilKt.canRefactor(callable)) continue;
            Object object2 = callable;
            if (object2 instanceof KtCallableDeclaration) {
                Object v4;
                block10: {
                    object = ((KtCallableDeclaration)callable).getValueParameters();
                    for (Object t : $receiver$iv) {
                        it = (KtParameter)t;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)((KtParameter)element2).getName())) continue;
                        v4 = t;
                        break block10;
                    }
                    v4 = null;
                }
                psiNamedElement = v4;
            } else if (object2 instanceof PsiMethod) {
                Object object3;
                block11: {
                    $receiver$iv = ((PsiMethod)callable).getParameterList().getParameters();
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object object4 = $receiver$iv[i];
                        it = (PsiParameter)object4;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)((KtParameter)element2).getName())) continue;
                        object3 = object4;
                        break block11;
                    }
                    object3 = null;
                }
                psiNamedElement = (PsiNamedElement)object3;
            } else {
                psiNamedElement = parameter = (PsiNamedElement)null;
            }
            if (parameter == null) continue;
            object2 = allRenames;
            object = newName2;
            object2.put(parameter, object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameElement(@NotNull PsiElement element2, @Nullable String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        super.renameElement(element2, newName2, usages2, listener2);
        Object[] objectArray = usages2;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void element$iv = $receiver$iv[i];
            UsageInfo it = (UsageInfo)element$iv;
            UsageInfo usageInfo = it;
            if (!(usageInfo instanceof KtResolvableCollisionUsageInfo)) {
                usageInfo = null;
            }
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = (KtResolvableCollisionUsageInfo)usageInfo;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }
}

