/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class CreateParameterForFieldIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.intentions.control.CreateParameterForFieldIntention");
    private static final Key<CachedValue<List<GrField>>> FIELD_CANDIDATES = Key.create((String)"Fields.candidates");

    @Override
    @NotNull
    public String getText() {
        String string = super.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention", "getText"));
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention", "processIntention"));
        }
        List<GrField> candidates = CreateParameterForFieldIntention.findFieldCandidates(element);
        if (candidates != null) {
            CreateParameterForFieldIntention.performForConstructor(element, project, editor, candidates);
        } else {
            List<GrMethod> constructors = CreateParameterForFieldIntention.findConstructorCandidates(element);
            CreateParameterForFieldIntention.performForField(element, project, editor, constructors);
        }
    }

    private static void performForField(PsiElement element, Project project, Editor editor, List<GrMethod> constructors) {
        GrField field = (GrField)PsiTreeUtil.getParentOfType((PsiElement)element, GrField.class);
        if (constructors.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GrMethod constructor : constructors) {
                CreateParameterForFieldIntention.addParameter(field, constructor, project);
            }
            return;
        }
        JBList list = new JBList((Object[])constructors.toArray(new GrMethod[constructors.size()]));
        list.setCellRenderer(new MethodCellRenderer(true));
        new PopupChooserBuilder((JList)list).setTitle(GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0])).setMovable(true).setItemChoosenCallback(new Runnable((JList)list, project, field){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ GrField val$field;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$field = grField;
            }

            @Override
            public void run() {
                final Object[] selectedValues = this.val$list.getSelectedValues();
                Arrays.sort(selectedValues, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((GrMethod)o2).getParameterList().getParametersCount() - ((GrMethod)o1).getParameterList().getParametersCount();
                    }
                });
                CommandProcessor.getInstance().executeCommand(this.val$project, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AccessToken accessToken = WriteAction.start();
                        try {
                            for (Object selectedValue : selectedValues) {
                                LOG.assertTrue(((GrMethod)selectedValue).isValid());
                                CreateParameterForFieldIntention.addParameter(val$field, (GrMethod)selectedValue, val$project);
                            }
                        }
                        finally {
                            accessToken.finish();
                        }
                    }
                }, GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0]), null);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void performForConstructor(PsiElement element, Project project, Editor editor, List<GrField> candidates) {
        GrMethod constructor = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (candidates.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GrField candidate : candidates) {
                CreateParameterForFieldIntention.addParameter(candidate, constructor, project);
            }
            return;
        }
        JBList list = new JBList((Object[])candidates.toArray(new GrField[candidates.size()]));
        list.setCellRenderer(new DefaultPsiElementCellRenderer());
        new PopupChooserBuilder((JList)list).setTitle(GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0])).setMovable(true).setItemChoosenCallback(new Runnable((JList)list, project, constructor){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ GrMethod val$constructor;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$constructor = grMethod;
            }

            @Override
            public void run() {
                final Object[] selectedValues = this.val$list.getSelectedValues();
                CommandProcessor.getInstance().executeCommand(this.val$project, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AccessToken accessToken = WriteAction.start();
                        try {
                            for (Object selectedValue : selectedValues) {
                                LOG.assertTrue(((GrField)selectedValue).isValid());
                                CreateParameterForFieldIntention.addParameter((GrField)selectedValue, val$constructor, val$project);
                            }
                        }
                        finally {
                            accessToken.finish();
                        }
                    }
                }, GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0]), null);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void addParameter(final GrField selectedValue, final GrMethod constructor, final Project project) {
        ArrayList<GrParameterInfo> parameters = new ArrayList<GrParameterInfo>();
        GrParameter[] constructorParameters = constructor.getParameters();
        for (int i = 0; i < constructorParameters.length; ++i) {
            parameters.add(new GrParameterInfo(constructorParameters[i], i));
        }
        Object[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.PARAMETER, (String)selectedValue.getName(), null, null).names;
        final DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(constructor, Collections.emptyList(), false);
        String parameterName = (String)ContainerUtil.find((Object[])suggestedNames, (Condition)new Condition<String>(){

            public boolean value(String name) {
                return !nameValidator.validateName(name, false).isEmpty();
            }
        });
        if (parameterName == null) {
            parameterName = nameValidator.validateName((String)suggestedNames[0], true);
        }
        parameters.add(new GrParameterInfo(parameterName, "null", "", selectedValue.getTypeGroovy(), -1, false));
        PsiClassType[] exceptionTypes = constructor.getThrowsList().getReferencedTypes();
        ThrownExceptionInfo[] thrownExceptionInfos = new ThrownExceptionInfo[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            new JavaThrownExceptionInfo(i, exceptionTypes[i]);
        }
        GrChangeInfoImpl grChangeInfo = new GrChangeInfoImpl(constructor, null, null, constructor.getName(), parameters, thrownExceptionInfos, false);
        final String finalParameterName = parameterName;
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(project, grChangeInfo){

            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention$4", "performRefactoring"));
                }
                super.performRefactoring(usages);
                GrOpenBlock block = constructor.getBlock();
                LOG.assertTrue(block != null);
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
                String text = StringUtil.equals((CharSequence)selectedValue.getName(), (CharSequence)finalParameterName) ? "this." + selectedValue.getName() + " = " + finalParameterName : selectedValue.getName() + " = " + finalParameterName;
                GrStatement assignment = factory.createStatementFromText(text);
                GrStatement statement = block.addStatementBefore(assignment, null);
                GrReferenceExpression ref = (GrReferenceExpression)((GrAssignmentExpression)statement).getLValue();
                if (!PsiManager.getInstance((Project)project).areElementsEquivalent(ref.resolve(), (PsiElement)selectedValue)) {
                    PsiUtil.qualifyMemberReference(ref, selectedValue, selectedValue.getName());
                }
            }
        };
        processor.run();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention", "getElementPredicate"));
        }
        return myPredicate;
    }

    @Nullable
    private static List<GrField> findFieldCandidates(PsiElement element) {
        GrMethod constructor = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (constructor == null || !constructor.isConstructor()) {
            return null;
        }
        if (constructor.getBlock() == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)constructor.getBlock(), (PsiElement)element, (boolean)false)) {
            return null;
        }
        PsiClass clazz = constructor.getContainingClass();
        if (!(clazz instanceof GrTypeDefinition)) {
            return null;
        }
        return CreateParameterForFieldIntention.findCandidatesCached(constructor, (GrTypeDefinition)clazz);
    }

    private static List<GrField> findCandidates(PsiMethod constructor, final GrTypeDefinition clazz) {
        GrOpenBlock block;
        final ArrayList<GrField> usedFields = new ArrayList<GrField>();
        GrOpenBlock grOpenBlock = block = constructor instanceof GrMethod ? ((GrMethod)constructor).getBlock() : null;
        if (block == null) {
            return usedFields;
        }
        final PsiManager manager = clazz.getManager();
        block.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof GrField && manager.areElementsEquivalent((PsiElement)((GrField)resolved).getContainingClass(), (PsiElement)clazz) && PsiUtil.isAccessedForWriting(referenceExpression)) {
                    usedFields.add((GrField)resolved);
                }
            }

            @Override
            public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
            }

            @Override
            public void visitClosure(GrClosableBlock closure) {
            }
        });
        ArrayList<GrField> fields = new ArrayList<GrField>();
        for (final GrField field : clazz.getFields()) {
            if (field.getInitializerGroovy() != null || ContainerUtil.find(usedFields, (Condition)new Condition<PsiField>(){

                public boolean value(PsiField o) {
                    return manager.areElementsEquivalent((PsiElement)o, (PsiElement)field);
                }
            }) != null) continue;
            fields.add(field);
        }
        return fields;
    }

    private static List<GrField> findCandidatesCached(final PsiMethod constructor, final GrTypeDefinition clazz) {
        CachedValue value = (CachedValue)constructor.getUserData(FIELD_CANDIDATES);
        if (value != null && value.getValue() != null) {
            return (List)value.getValue();
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)constructor.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<List<GrField>>(){

            public CachedValueProvider.Result<List<GrField>> compute() {
                return CachedValueProvider.Result.create((Object)CreateParameterForFieldIntention.findCandidates(constructor, clazz), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }, false);
        constructor.putUserData(FIELD_CANDIDATES, (Object)cachedValue);
        return (List)cachedValue.getValue();
    }

    @Nullable
    private static List<GrMethod> findConstructorCandidates(PsiElement element) {
        GrField field = (GrField)PsiTreeUtil.getParentOfType((PsiElement)element, GrField.class);
        if (field == null) {
            return null;
        }
        return CreateParameterForFieldIntention.findConstructorCandidates(field, (GrTypeDefinition)field.getContainingClass());
    }

    private static List<GrMethod> findConstructorCandidates(final GrField field, GrTypeDefinition psiClass) {
        ArrayList<GrMethod> result = new ArrayList<GrMethod>();
        PsiMethod[] constructors = psiClass.getConstructors();
        final PsiManager manager = field.getManager();
        for (PsiMethod constructor : constructors) {
            List<GrField> fields = CreateParameterForFieldIntention.findCandidatesCached(constructor, psiClass);
            if (ContainerUtil.find(fields, (Condition)new Condition<GrField>(){

                public boolean value(GrField grField) {
                    return manager.areElementsEquivalent((PsiElement)grField, (PsiElement)field);
                }
            }) == null) continue;
            result.add((GrMethod)constructor);
        }
        return result;
    }

    static class MyPredicate
    implements PsiElementPredicate {
        MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            List candidates = CreateParameterForFieldIntention.findFieldCandidates(element);
            if (candidates != null && !candidates.isEmpty()) {
                return true;
            }
            List constructors = CreateParameterForFieldIntention.findConstructorCandidates(element);
            return constructors != null && !constructors.isEmpty();
        }
    }
}

