/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.actions.SyncActionKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a9\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\f\u001a#\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"createMergeActions", "", "Ljavax/swing/Action;", "project", "Lcom/intellij/openapi/project/Project;", "urlTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "dialogParent", "Ljava/awt/Container;", "okAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;Ljava/awt/Container;Lkotlin/jvm/functions/Function0;)[Ljavax/swing/Action;", "updateSyncButtonState", "url", "", "syncActions", "(Ljava/lang/String;[Ljavax/swing/Action;)V", "settings-repository"})
public final class UpstreamEditorKt {
    public static final void updateSyncButtonState(@Nullable String url, @NotNull Action[] syncActions) {
        Intrinsics.checkParameterIsNotNull((Object)syncActions, (String)"syncActions");
        try {
            boolean enabled = url != null && url.length() > 1 && IcsManagerKt.getIcsManager().getRepositoryService().checkUrl(url, null);
        }
        finally {
            int n = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Action[] createMergeActions(@Nullable Project project, @NotNull TextFieldWithBrowseButton urlTextField, @NotNull Container dialogParent, @NotNull Function0<Unit> okAction) {
        void size$iv;
        void syncTypes;
        Intrinsics.checkParameterIsNotNull((Object)urlTextField, (String)"urlTextField");
        Intrinsics.checkParameterIsNotNull((Object)dialogParent, (String)"dialogParent");
        Intrinsics.checkParameterIsNotNull(okAction, (String)"okAction");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = SyncType.values();
        if (SystemInfo.isMac) {
            Object[] objectArray = ArrayUtil.reverseArray((Object[])((Object[])((SyncType[])syncTypes.element)));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.reverseArray(syncTypes)");
            syncTypes.element = (SyncType[])objectArray;
        }
        IcsManager icsManager2 = IcsManagerKt.getIcsManager();
        int n = 3;
        Action[] result$iv = new Action[size$iv];
        boolean bl = false;
        void var9_9 = size$iv - true;
        if (bl <= var9_9) {
            void i$iv;
            do {
                void it;
                void var10_10 = ++i$iv;
                void var15_13 = i$iv;
                Action[] actionArray = result$iv;
                SyncType syncType = ((SyncType[])syncTypes.element)[it];
                AbstractAction abstractAction = new AbstractAction(syncType, IcsBundleKt.icsMessage("action." + (Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.MERGE)) ? "Merge" : (Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? "ResetToTheirs" : "ResetToMy")) + "Settings.text", new Object[0]), (Ref.ObjectRef)syncTypes, urlTextField, icsManager2, dialogParent, project, okAction){
                    final /* synthetic */ SyncType $syncType;
                    final /* synthetic */ Ref.ObjectRef $syncTypes$inlined;
                    final /* synthetic */ TextFieldWithBrowseButton $urlTextField$inlined;
                    final /* synthetic */ IcsManager $icsManager$inlined;
                    final /* synthetic */ Container $dialogParent$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ Function0 $okAction$inlined;

                    private final boolean saveRemoteRepositoryUrl() {
                        String url = StringUtil.nullize((String)this.$urlTextField$inlined.getText());
                        if (url != null && !this.$icsManager$inlined.getRepositoryService().checkUrl(url, this.$dialogParent$inlined)) {
                            return false;
                        }
                        RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                        repositoryManager.createRepositoryIfNeed();
                        repositoryManager.setUpstream(url, null);
                        return true;
                    }

                    public void actionPerformed(ActionEvent event) {
                        boolean repositoryWillBeCreated = !this.$icsManager$inlined.getRepositoryManager().isRepositoryExists();
                        boolean upstreamSet = false;
                        try {
                            if (!this.saveRemoteRepositoryUrl()) {
                                if (repositoryWillBeCreated) {
                                    this.$icsManager$inlined.getRepositoryManager().deleteRepository();
                                }
                                return;
                            }
                            upstreamSet = true;
                            if (repositoryWillBeCreated && Intrinsics.areEqual((Object)((Object)this.$syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ^ true) {
                                ApplicationManager.getApplication().saveSettings();
                                this.$icsManager$inlined.sync(this.$syncType, this.$project$inlined, (Function0<Unit>)((Function0)createMergeActions.1.actionPerformed.1.INSTANCE));
                            } else {
                                this.$icsManager$inlined.sync(this.$syncType, this.$project$inlined, (Function0<Unit>)((Function0)null));
                            }
                        }
                        catch (Throwable e) {
                            if (repositoryWillBeCreated) {
                                this.$icsManager$inlined.getRepositoryManager().deleteRepository();
                            }
                            IcsManagerKt.getLOG().warn(e);
                            if (!upstreamSet || e instanceof NoRemoteRepositoryException) {
                                Messages.showErrorDialog((Component)this.$dialogParent$inlined, (String)IcsBundleKt.icsMessage("set.upstream.failed.message", e.getMessage()), (String)IcsBundleKt.icsMessage("set.upstream.failed.title", new Object[0]));
                            } else {
                                Messages.showErrorDialog((Component)this.$dialogParent$inlined, (String)StringUtil.notNullize((String)e.getMessage(), (String)"Internal error"), (String)IcsBundleKt.icsMessage(e instanceof AuthenticationException ? "sync.not.authorized.title" : "sync.rejected.title", new Object[0]));
                            }
                            return;
                        }
                        SyncActionKt.getNOTIFICATION_GROUP().createNotification(IcsBundleKt.icsMessage("sync.done.message", new Object[0]), NotificationType.INFORMATION).notify(this.$project$inlined);
                        this.$okAction$inlined.invoke();
                    }
                    {
                        this.$syncType = $captured_local_variable$1;
                        this.$syncTypes$inlined = objectRef;
                        this.$urlTextField$inlined = textFieldWithBrowseButton;
                        this.$icsManager$inlined = icsManager2;
                        this.$dialogParent$inlined = container;
                        this.$project$inlined = project;
                        this.$okAction$inlined = function0;
                        super($super_call_param$2);
                    }
                };
                actionArray[var15_13] = abstractAction;
            } while (i$iv != var9_9);
        }
        return (Action[])((Object[])result$iv);
    }
}

