/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.DevicePicker;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployTargetPickerDialog
extends DialogWrapper {
    private static final int DEVICE_TAB_INDEX = 0;
    private static final int CUSTOM_RUNPROFILE_PROVIDER_TARGET_INDEX = 1;
    private final int myContextId;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final DeployTarget myDeployTarget;
    @NotNull
    private final DeployTargetState myDeployTargetState;
    private final DeployTargetConfigurable myDeployTargetConfigurable;
    private final DevicePicker myDevicePicker;
    private final ProcessHandlerConsolePrinter myPrinter;
    private JPanel myContentPane;
    private JBTabbedPane myTabbedPane;
    private JPanel myCloudTargetsPanel;
    private JPanel myDevicesPanel;
    private Result myResult;

    public DeployTargetPickerDialog(int runContextId, @NotNull AndroidFacet facet, @NotNull List<DeployTarget> deployTargets, @NotNull Map<String, DeployTargetState> deployTargetStates, @NotNull ProcessHandlerConsolePrinter printer) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/DeployTargetPickerDialog", "<init>"));
        }
        if (deployTargets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargets", "com/android/tools/idea/run/editor/DeployTargetPickerDialog", "<init>"));
        }
        if (deployTargetStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetStates", "com/android/tools/idea/run/editor/DeployTargetPickerDialog", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/editor/DeployTargetPickerDialog", "<init>"));
        }
        super(facet.getModule().getProject(), true);
        this.$$$setupUI$$$();
        if (deployTargets.size() != 1) {
            throw new IllegalArgumentException("Only 1 custom run profile state provider can be displayed right now..");
        }
        this.myFacet = facet;
        this.myContextId = runContextId;
        this.myDeployTarget = deployTargets.get(0);
        this.myDeployTargetState = deployTargetStates.get(this.myDeployTarget.getId());
        this.myPrinter = printer;
        this.myDevicePicker = new DevicePicker(this.getDisposable(), facet);
        this.myDevicesPanel.add((Component)this.myDevicePicker.getComponent(), "Center");
        this.myDevicesPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        Module module = facet.getModule();
        this.myDeployTargetConfigurable = this.myDeployTarget.createConfigurable(module.getProject(), this.getDisposable(), new Context(module));
        JComponent component = this.myDeployTargetConfigurable.createComponent();
        if (component != null) {
            this.myCloudTargetsPanel.add((Component)component, "Center");
        }
        this.myDeployTargetConfigurable.resetFrom(this.myDeployTargetState, this.myContextId);
        this.setTitle("Select Deployment Target");
        this.setModal(true);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "deploy.picker.dialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDevicePicker.getPreferredFocusedComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myTabbedPane.getSelectedIndex() == 1) {
            this.myDeployTargetConfigurable.applyTo(this.myDeployTargetState, this.myContextId);
            List<ValidationError> errors = this.myDeployTargetState.validate(this.myFacet);
            if (!errors.isEmpty()) {
                return new ValidationInfo(errors.get(0).getMessage(), null);
            }
        } else {
            return this.myDevicePicker.validate();
        }
        return super.doValidate();
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        if (threadToUse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetPickerDialog", "getValidationThreadToUse"));
        }
        return threadToUse;
    }

    protected void doOKAction() {
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (selectedIndex == 0) {
            this.myResult = Result.create(this.myDevicePicker.getSelectedTarget(this.myPrinter));
        } else if (selectedIndex == 1) {
            this.myResult = Result.create(this.myDeployTarget, this.myDeployTargetState);
        }
        super.doOKAction();
    }

    @NotNull
    public Result getResult() {
        Result result = this.myResult;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetPickerDialog", "getResult"));
        }
        return result;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel3;
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel3.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDevicesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Devices", null, jPanel2, null);
        JBPanel jBPanel = new JBPanel();
        jBPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Cloud Testing", null, (Component)jBPanel, null);
        this.myCloudTargetsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBPanel.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jBPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static final class Context
    implements DeployTargetConfigurableContext {
        private final Module myModule;

        public Context(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Context", "<init>"));
            }
            this.myModule = module;
        }

        @Override
        @Nullable
        public Module getModule() {
            return this.myModule;
        }

        @Override
        public void addModuleChangeListener(@NotNull ActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Context", "addModuleChangeListener"));
            }
        }

        @Override
        public void removeModuleChangeListener(@NotNull ActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Context", "removeModuleChangeListener"));
            }
        }
    }

    private static class DeviceResult
    extends Result {
        private final DeviceTarget myTarget;

        private DeviceResult(@NotNull DeviceTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$DeviceResult", "<init>"));
            }
            this.myTarget = target;
        }

        @Override
        public boolean hasRunProfile() {
            return false;
        }

        @Override
        public DeviceTarget getDeviceTarget() {
            return this.myTarget;
        }
    }

    private static class RunProfileResult
    extends Result {
        private final DeployTarget myDelegate;
        private final DeployTargetState myDelegateState;

        private RunProfileResult(@NotNull DeployTarget delegate, @NotNull DeployTargetState state) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$RunProfileResult", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$RunProfileResult", "<init>"));
            }
            this.myDelegate = delegate;
            this.myDelegateState = state;
        }

        @Override
        public boolean hasRunProfile() {
            return true;
        }

        @Override
        public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$RunProfileResult", "getRunProfileState"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$RunProfileResult", "getRunProfileState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$RunProfileResult", "getRunProfileState"));
            }
            return this.myDelegate.getRunProfileState(executor, env, this.myDelegateState);
        }
    }

    public static abstract class Result {
        public boolean hasRunProfile() {
            return false;
        }

        public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "getRunProfileState"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "getRunProfileState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "getRunProfileState"));
            }
            throw new IllegalStateException();
        }

        public DeviceTarget getDeviceTarget() {
            throw new IllegalStateException();
        }

        @NotNull
        public static Result create(@NotNull DeployTarget deployTarget, @NotNull DeployTargetState deployTargetState) {
            if (deployTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTarget", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "create"));
            }
            if (deployTargetState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetState", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "create"));
            }
            RunProfileResult runProfileResult = new RunProfileResult(deployTarget, deployTargetState);
            if (runProfileResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "create"));
            }
            return runProfileResult;
        }

        @NotNull
        public static Result create(@NotNull DeviceTarget device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "create"));
            }
            DeviceResult deviceResult = new DeviceResult(device);
            if (deviceResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Result", "create"));
            }
            return deviceResult;
        }
    }
}

