/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScriptGenerator {
    @NonNls
    public static final String SCRIPT_EXT = SystemInfo.isWindows ? ".bat" : ".sh";
    private final String myPrefix;
    private final Class myMainClass;
    private final ArrayList<String> myPaths = new ArrayList();
    private final ArrayList<String> myInternalParameters = new ArrayList();

    public ScriptGenerator(String prefix, Class mainClass) {
        this.myPrefix = prefix;
        this.myMainClass = mainClass;
        this.addClasses(this.myMainClass);
    }

    public ScriptGenerator addClasses(Class ... classes) {
        for (Class c : classes) {
            this.addPath(PathUtil.getJarPathForClass((Class)c));
        }
        return this;
    }

    private void addPath(String path) {
        if (!this.myPaths.contains(path)) {
            this.myPaths.add(path);
        }
    }

    public ScriptGenerator addResource(Class base, @NonNls String resource) {
        this.addPath(ScriptGenerator.getJarForResource(base, resource));
        return this;
    }

    public ScriptGenerator addInternal(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        return this;
    }

    @NotNull
    public File generate() throws IOException {
        File file;
        String title = SystemInfo.isWindows ? "@echo off" : "#!/bin/sh";
        String parametersPassthrough = SystemInfo.isWindows ? " %*" : " \"$@\"";
        String content = title + "\n" + this.commandLine() + parametersPassthrough + "\n";
        try {
            file = ExecUtil.createTempExecutableScript((String)this.myPrefix, (String)SCRIPT_EXT, (String)content);
        }
        catch (ExecutionException e) {
            throw new IOException("The script providing interactive execution of Git commands couldn't be made executable", e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/git4idea/util/ScriptGenerator", "generate"));
        }
        return file;
    }

    public String commandLine() {
        StringBuilder cmd = new StringBuilder();
        cmd.append('\"').append(System.getProperty("java.home")).append(File.separatorChar).append("bin").append(File.separatorChar).append("java\" -cp \"");
        boolean first = true;
        for (String p : this.myPaths) {
            if (!first) {
                cmd.append(File.pathSeparatorChar);
            } else {
                first = false;
            }
            cmd.append(p);
        }
        cmd.append("\" ");
        cmd.append(this.myMainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        return line;
    }

    public static String getJarForResource(Class context, String res) {
        String resourceRoot = PathManager.getResourceRoot((Class)context, (String)res);
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }
}

