/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.util.LinkedList;
import org.apache.batik.parser.DefaultNumberListHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;

public class FloatArrayProducer
extends DefaultNumberListHandler
implements PointsHandler {
    protected LinkedList as;
    protected float[] a;
    protected int index;
    protected int count;

    public float[] getFloatArray() {
        return this.a;
    }

    @Override
    public void startNumberList() throws ParseException {
        this.as = new LinkedList();
        this.a = new float[11];
        this.count = 0;
        this.index = 0;
    }

    @Override
    public void numberValue(float f) throws ParseException {
        if (this.index == this.a.length) {
            this.as.add(this.a);
            this.a = new float[this.a.length * 2 + 1];
            this.index = 0;
        }
        this.a[this.index++] = f;
        ++this.count;
    }

    @Override
    public void endNumberList() throws ParseException {
        float[] fArray = new float[this.count];
        int n = 0;
        for (float[] fArray2 : this.as) {
            System.arraycopy(fArray2, 0, fArray, n, fArray2.length);
            n += fArray2.length;
        }
        System.arraycopy(this.a, 0, fArray, n, this.index);
        this.as.clear();
        this.a = fArray;
    }

    @Override
    public void startPoints() throws ParseException {
        this.startNumberList();
    }

    @Override
    public void point(float f, float f2) throws ParseException {
        this.numberValue(f);
        this.numberValue(f2);
    }

    @Override
    public void endPoints() throws ParseException {
        this.endNumberList();
    }
}

